/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.mut.doc.web;

import org.itsnat.core.ItsNatDOMException;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.domimpl.html.HTMLTextAreaElementImpl;
import org.itsnat.impl.core.mut.doc.web.DocMutationEventListenerStfulWebImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLStyleElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTextAreaElement;

public class DocMutationEventListenerHTMLImpl
extends DocMutationEventListenerStfulWebImpl {
    public DocMutationEventListenerHTMLImpl(ItsNatHTMLDocumentImpl itsNatDoc) {
        super(itsNatDoc);
    }

    @Override
    protected void checkOperation(MutationEvent mutEvent) {
        String type;
        if (this.itsNatDoc.isDebugMode() && (type = mutEvent.getType()).equals("DOMNodeInserted")) {
            Node newNode = (Node)((Object)mutEvent.getTarget());
            this.checkInsertedNodeTree(newNode);
        }
    }

    private void checkInsertedNodeTree(Node node) {
        this.checkInsertedNode(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.checkInsertedNodeTree(child);
        }
    }

    private void checkInsertedNode(Node node) {
        if (node.getNodeType() != 1) {
            return;
        }
        if (node instanceof HTMLTableRowElement) {
            if (node.getParentNode() instanceof HTMLTableRowElement) {
                throw new ItsNatDOMException("A TR element must be inserted below a TBODY, THEAD or TFOOT", node);
            }
        } else if (node instanceof HTMLStyleElement && !(node.getParentNode() instanceof HTMLHeadElement)) {
            throw new ItsNatDOMException("A STYLE element must be inserted below HEAD", node);
        }
    }

    @Override
    protected void beforeAfterRenderAndSendMutationCode(boolean before, MutationEvent mutEvent, ClientDocumentImpl[] allClients) {
        super.beforeAfterRenderAndSendMutationCode(before, mutEvent, allClients);
        Node target = (Node)((Object)mutEvent.getTarget());
        if (before && this.itsNatDoc.getDocument() instanceof HTMLDocument && target instanceof HTMLTextAreaElement && mutEvent.getType().equals("DOMAttrModified")) {
            HTMLTextAreaElementImpl elem = (HTMLTextAreaElementImpl)target;
            Attr attr = (Attr)mutEvent.getRelatedNode();
            if (attr.getName().equals("value")) {
                short changeType = mutEvent.getAttrChange();
                switch (changeType) {
                    case 1: 
                    case 2: {
                        String value = attr.getValue();
                        elem.setValueProperty(value);
                        break;
                    }
                    case 3: {
                        elem.setValueProperty(null);
                    }
                }
            }
        }
    }
}

