/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.mut.doc;

import java.util.LinkedList;
import java.util.Map;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.BoundElementDocContainerImpl;
import org.itsnat.impl.core.doc.ElementDocContainerWrapperImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domimpl.ElementDocContainer;
import org.itsnat.impl.core.domimpl.ItsNatNodeInternal;
import org.itsnat.impl.core.domimpl.deleg.DelegateNodeImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.mut.client.ClientMutationEventListenerStfulImpl;
import org.itsnat.impl.core.mut.doc.DocMutationEventListenerImpl;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocImpl;
import org.itsnat.impl.core.resp.norm.ResponseNormalLoadStfulDocImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class DocMutationEventListenerStfulImpl
extends DocMutationEventListenerImpl {
    public DocMutationEventListenerStfulImpl(ItsNatStfulDocumentImpl itsNatDoc) {
        super(itsNatDoc);
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return (ItsNatStfulDocumentImpl)this.itsNatDoc;
    }

    @Override
    protected ClientDocumentImpl[] getAllClientDocumentsCopy() {
        return this.getItsNatStfulDocument().getAllClientDocumentsCopy();
    }

    @Override
    protected void renderAndSendMutationCode(MutationEvent mutEvent, ClientDocumentImpl[] allClients) {
        for (int i = 0; i < allClients.length; ++i) {
            ClientDocumentStfulImpl clientDoc = (ClientDocumentStfulImpl)allClients[i];
            ClientDocumentStfulDelegateImpl clientDocDeleg = clientDoc.getClientDocumentStfulDelegate();
            ClientMutationEventListenerStfulImpl mutListener = clientDocDeleg.getClientMutationEventListenerStful();
            mutListener.beforeRenderAndSendMutationCode(mutEvent);
            if (mutListener.canRenderAndSendMutationCode()) {
                mutListener.preRenderAndSendMutationCode(mutEvent);
                mutListener.renderAndSendMutationCode(mutEvent);
                mutListener.postRenderAndSendMutationCode(mutEvent);
            }
            mutListener.afterRenderAndSendMutationCode(mutEvent);
        }
    }

    @Override
    protected void beforeAfterRenderAndSendMutationCode(boolean before, MutationEvent mutEvent, ClientDocumentImpl[] allClients) {
        super.beforeAfterRenderAndSendMutationCode(before, mutEvent, allClients);
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        String type = mutEvent.getType();
        if (before && itsNatDoc.isAutoCleanEventListeners() && (!itsNatDoc.isLoadingPhaseAndFastLoadMode() || itsNatDoc.isDebugMode()) && type.equals("DOMNodeRemoved")) {
            Node target = (Node)((Object)mutEvent.getTarget());
            this.processTreeCleanEventListeners(target, allClients);
        }
        if (!itsNatDoc.isLoadingPhaseAndFastLoadMode()) {
            if (before) {
                Element elem;
                Attr attr;
                ElementDocContainer elemDocCont;
                if (type.equals("DOMNodeInserted")) {
                    Node insertedNode = (Node)((Object)mutEvent.getTarget());
                    this.processTreeInsertedElementDocContainer(insertedNode);
                } else if (type.equals("DOMAttrModified") && (elemDocCont = ElementDocContainerWrapperImpl.getElementDocContainerIfURLAttr(attr = (Attr)mutEvent.getRelatedNode(), elem = (Element)((Object)mutEvent.getTarget()))) != null) {
                    BoundElementDocContainerImpl bindInfo = elemDocCont.getElementDocContainerWrapper().getBoundElementDocContainer();
                    if (bindInfo != null) {
                        bindInfo.unRegister();
                    }
                    short changeType = mutEvent.getAttrChange();
                    switch (changeType) {
                        case 1: 
                        case 2: {
                            bindInfo = BoundElementDocContainerImpl.register(elemDocCont, itsNatDoc);
                            break;
                        }
                    }
                }
            } else if (type.equals("DOMNodeRemoved")) {
                Node removeNode = (Node)((Object)mutEvent.getTarget());
                this.processTreeRemovedElementDocContainer(removeNode);
            }
        }
    }

    protected void processTreeCleanEventListeners(Node node, ClientDocumentImpl[] allClients) {
        this.cleanEventListeners(node, allClients);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTreeCleanEventListeners(child, allClients);
        }
    }

    private void cleanEventListeners(Node node, ClientDocumentImpl[] allClients) {
        if (node.getNodeType() == 3) {
            return;
        }
        EventTarget eventTarget = (EventTarget)((Object)node);
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        int count = 0;
        count += itsNatDoc.removeAllPlatformEventListeners(eventTarget, true);
        count += itsNatDoc.removeAllUserEventListeners(eventTarget, true);
        for (int i = 0; i < allClients.length; ++i) {
            ClientDocumentStfulImpl clientDoc = (ClientDocumentStfulImpl)allClients[i];
            count += clientDoc.getClientDocumentStfulDelegate().removeAllPlatformEventListeners(eventTarget, true);
            count += clientDoc.removeAllUserEventListeners(eventTarget, true);
            count += clientDoc.removeAllTimerEventListeners(eventTarget, true);
            count += clientDoc.removeAllContinueEventListeners(eventTarget, true);
        }
        if (count > 0 && itsNatDoc.isLoadingPhaseAndFastLoadMode()) {
            throw new ItsNatException("An event listener was registered in a node removed in the document load phase and in fast load mode", (Object)node);
        }
    }

    protected void processTreeInsertedElementDocContainer(Node node) {
        if (node instanceof ElementDocContainer) {
            ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
            ElementDocContainer elem = (ElementDocContainer)((Object)node);
            BoundElementDocContainerImpl.register(elem, itsNatDoc);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTreeInsertedElementDocContainer(child);
        }
    }

    protected void processTreeRemovedElementDocContainer(Node node) {
        if (node instanceof ElementDocContainer) {
            ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
            ElementDocContainer elem = (ElementDocContainer)((Object)node);
            BoundElementDocContainerImpl.unRegister(elem, itsNatDoc);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTreeRemovedElementDocContainer(child);
        }
    }

    @Override
    protected void handleMutationEvent(MutationEvent mutEvent) {
        String type = mutEvent.getType();
        if (type.equals("DOMNodeInserted")) {
            Element parentNode = (Element)mutEvent.getRelatedNode();
            Node newNode = (Node)((Object)mutEvent.getTarget());
            if (parentNode != null && parentNode.getFirstChild() == newNode && parentNode.getLastChild() == newNode) {
                ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
                itsNatDoc.reconnectChildNodesToClient(parentNode);
            }
        }
        super.handleMutationEvent(mutEvent);
    }

    public boolean isDisconnectedChildNodesFromClient(Node node) {
        return ((ItsNatNodeInternal)node).getDelegateNode().isDisconnectedChildNodesFromClient();
    }

    public Node disconnectChildNodesFromClient(Node node) {
        DelegateNodeImpl delegNode = ((ItsNatNodeInternal)node).getDelegateNode();
        if (delegNode.isDisconnectedChildNodesFromClient()) {
            throw new ItsNatDOMException("This node is already disconnected from client", node);
        }
        delegNode.setDisconnectedChildNodesFromClient(true);
        Node disconnectedFragment = DOMUtilInternal.extractChildren(node, true);
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        if (itsNatDoc.isLoadingPhaseAndFastLoadMode() && disconnectedFragment != null) {
            ResponseNormalLoadStfulDocImpl loadResponse = this.getResponseNormalLoadStfulDoc();
            Map<Node, Object> disconnectedNodesFastLoadMode = loadResponse.getDisconnectedNodesFastLoadMode();
            if (disconnectedFragment instanceof DocumentFragment) {
                LinkedList<Node> nodeList = new LinkedList<Node>();
                nodeList.add(disconnectedFragment);
                if (disconnectedFragment.hasChildNodes()) {
                    for (Node child = disconnectedFragment.getFirstChild(); child != null; child = child.getNextSibling()) {
                        nodeList.add(child);
                    }
                }
                disconnectedNodesFastLoadMode.put(node, nodeList);
            } else {
                disconnectedNodesFastLoadMode.put(node, disconnectedFragment);
            }
        }
        return disconnectedFragment;
    }

    public void reconnectChildNodesToClient(Node node) {
        ResponseNormalLoadStfulDocImpl loadResponse;
        DelegateNodeImpl delegNode = ((ItsNatNodeInternal)node).getDelegateNode();
        if (!delegNode.isDisconnectedChildNodesFromClient()) {
            return;
        }
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        if (itsNatDoc.isLoadingPhaseAndFastLoadMode() && (loadResponse = this.getResponseNormalLoadStfulDoc()).hasDisconnectedNodesFastLoadMode()) {
            Map<Node, Object> disconnectedNodesFastLoadMode = loadResponse.getDisconnectedNodesFastLoadMode();
            disconnectedNodesFastLoadMode.remove(node);
        }
        ClientDocumentImpl[] allClients = this.getAllClientDocumentsCopy();
        for (int i = 0; i < allClients.length; ++i) {
            ClientDocumentStfulImpl clientDoc = (ClientDocumentStfulImpl)allClients[i];
            ClientDocumentStfulDelegateImpl clientDocDeleg = clientDoc.getClientDocumentStfulDelegate();
            ClientMutationEventListenerStfulImpl mutListener = clientDocDeleg.getClientMutationEventListenerStful();
            mutListener.removeAllChildNodes(node);
        }
        delegNode.setDisconnectedChildNodesFromClient(false);
    }

    public ResponseNormalLoadStfulDocImpl getResponseNormalLoadStfulDoc() {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        ItsNatServletRequestImpl loadINSRequest = itsNatDoc.getCurrentItsNatServletRequest();
        RequestNormalLoadDocImpl loadRequest = (RequestNormalLoadDocImpl)loadINSRequest.getRequest();
        return (ResponseNormalLoadStfulDocImpl)loadRequest.getResponseNormalLoadDoc();
    }
}

