/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.mut.doc;

import java.util.LinkedList;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.listener.AutoBuildCompBeforeAfterMutationRenderListener;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.itsnat.impl.core.mut.doc.BeforeAfterMutationRenderListener;
import org.itsnat.impl.core.util.MapListImpl;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationEvent;

public abstract class DocMutationEventListenerImpl
implements EventListenerSerializableInternal {
    protected ItsNatDocumentImpl itsNatDoc;
    protected MapListImpl<Node, BeforeAfterMutationRenderListener> beforeAfterListeners;
    protected AutoBuildCompBeforeAfterMutationRenderListener autoBuildCompBeforeAfterListener;
    protected boolean enabled = true;

    public DocMutationEventListenerImpl(ItsNatDocumentImpl itsNatDoc) {
        this.itsNatDoc = itsNatDoc;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public AutoBuildCompBeforeAfterMutationRenderListener getAutoBuildCompBeforeAfterMutationRenderListener() {
        return this.autoBuildCompBeforeAfterListener;
    }

    public void setAutoBuildCompBeforeAfterMutationRenderListener(AutoBuildCompBeforeAfterMutationRenderListener listener) {
        this.autoBuildCompBeforeAfterListener = listener;
    }

    protected MapListImpl<Node, BeforeAfterMutationRenderListener> getBeforeAfterMutationRenderListeners() {
        if (this.beforeAfterListeners == null) {
            this.beforeAfterListeners = new MapListImpl();
        }
        return this.beforeAfterListeners;
    }

    protected LinkedList<BeforeAfterMutationRenderListener> getBeforeAfterMutationRenderListeners(Node node) {
        if (this.beforeAfterListeners == null) {
            return null;
        }
        return this.beforeAfterListeners.get(node);
    }

    public void addBeforeAfterMutationRenderListener(Node node, BeforeAfterMutationRenderListener listener) {
        MapListImpl<Node, BeforeAfterMutationRenderListener> listeners = this.getBeforeAfterMutationRenderListeners();
        listeners.add(node, listener);
    }

    public void removeBeforeAfterMutationRenderListener(Node node, BeforeAfterMutationRenderListener listener) {
        MapListImpl<Node, BeforeAfterMutationRenderListener> listeners = this.getBeforeAfterMutationRenderListeners();
        listeners.remove(node, listener);
    }

    @Override
    public void handleEvent(Event evt) {
        if (!this.isEnabled()) {
            return;
        }
        MutationEvent mutEvent = (MutationEvent)evt;
        this.checkOperation(mutEvent);
        this.handleMutationEvent(mutEvent);
    }

    protected void handleMutationEvent(MutationEvent mutEvent) {
        ClientDocumentImpl[] allClients = this.getAllClientDocumentsCopy();
        this.beforeAfterRenderAndSendMutationCode(true, mutEvent, allClients);
        this.renderAndSendMutationCode(mutEvent, allClients);
        this.beforeAfterRenderAndSendMutationCode(false, mutEvent, allClients);
    }

    protected abstract void checkOperation(MutationEvent var1);

    protected void beforeAfterRenderAndSendMutationCode(boolean before, MutationEvent mutEvent, ClientDocumentImpl[] allClients) {
        Node target = (Node)((Object)mutEvent.getTarget());
        String type = mutEvent.getType();
        boolean childrenFirst = type.equals("DOMNodeInserted") ? false : type.equals("DOMNodeRemoved");
        this.beforeAfterRenderAndSendMutationCodeProcessTree(before, childrenFirst, target, mutEvent, allClients);
    }

    protected void beforeAfterRenderAndSendMutationCodeProcessTree(boolean before, boolean childrenFirst, Node node, MutationEvent mutEvent, ClientDocumentImpl[] allClients) {
        Node child;
        if (childrenFirst) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.beforeAfterRenderAndSendMutationCodeProcessTree(before, childrenFirst, child, mutEvent, allClients);
            }
        }
        this.beforeAfterRenderAndSendMutationCode(before, node, mutEvent, allClients);
        if (!childrenFirst) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.beforeAfterRenderAndSendMutationCodeProcessTree(before, childrenFirst, child, mutEvent, allClients);
            }
        }
    }

    protected void beforeAfterRenderAndSendMutationCode(boolean before, Node node, MutationEvent mutEvent, ClientDocumentImpl[] allClients) {
        LinkedList<BeforeAfterMutationRenderListener> beforeAfterListeners;
        if (this.autoBuildCompBeforeAfterListener != null) {
            if (before) {
                this.autoBuildCompBeforeAfterListener.beforeRender(node, mutEvent);
            } else {
                this.autoBuildCompBeforeAfterListener.afterRender(node, mutEvent);
            }
        }
        if ((beforeAfterListeners = this.getBeforeAfterMutationRenderListeners(node)) != null && !beforeAfterListeners.isEmpty()) {
            BeforeAfterMutationRenderListener[] listenerArray = beforeAfterListeners.toArray(new BeforeAfterMutationRenderListener[beforeAfterListeners.size()]);
            for (int i = 0; i < listenerArray.length; ++i) {
                BeforeAfterMutationRenderListener listener = listenerArray[i];
                if (before) {
                    listener.beforeRender(node, mutEvent);
                    continue;
                }
                listener.afterRender(node, mutEvent);
            }
        }
    }

    protected abstract void renderAndSendMutationCode(MutationEvent var1, ClientDocumentImpl[] var2);

    protected abstract ClientDocumentImpl[] getAllClientDocumentsCopy();
}

