/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.mut.client.web;

import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.mut.client.web.ClientMutationEventListenerHTMLImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderAttributeImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.msie.JSRenderHTMLTextMSIEOldImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.MutationEvent;

public class ClientMutationEventListenerHTMLMSIEOldImpl
extends ClientMutationEventListenerHTMLImpl {
    public ClientMutationEventListenerHTMLMSIEOldImpl(ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(clientDoc);
    }

    public boolean isSVGNodeAndAdobeSVGInline(Node node) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        return NamespaceUtil.isSVGNode(node) && !SVGWebInfoImpl.isSVGWebEnabled(clientDoc);
    }

    @Override
    public void preRenderAndSendMutationCode(MutationEvent mutEvent) {
        Node node;
        Node parentNode;
        super.preRenderAndSendMutationCode(mutEvent);
        String type = mutEvent.getType();
        if (type.equals("DOMNodeInserted")) {
            Node newNode = (Node)((Object)mutEvent.getTarget());
            this.fixTreeNamespaces(newNode);
        } else if (type.equals("DOMNodeRemoved") && this.isSVGNodeAndAdobeSVGInline(parentNode = (node = (Node)((Object)mutEvent.getTarget())).getParentNode())) {
            this.fixTreeRemovedSVGNodeInAdobeSVGInline(node);
        }
    }

    @Override
    public void postRenderAndSendMutationCode(MutationEvent mutEvent) {
        CharacterData charDataNode;
        super.postRenderAndSendMutationCode(mutEvent);
        String type = mutEvent.getType();
        if (type.equals("DOMNodeInserted")) {
            Node newNode = (Node)((Object)mutEvent.getTarget());
            Node parentNode = newNode.getParentNode();
            if (this.isSVGNodeAndAdobeSVGInline(parentNode)) {
                this.fixTreeInsertedSVGNodeInAdobeSVGInline(newNode);
            }
        } else if (type.equals("DOMAttrModified")) {
            Element elem = (Element)((Object)mutEvent.getTarget());
            if (this.isSVGNodeAndAdobeSVGInline(elem)) {
                Attr attr = (Attr)mutEvent.getRelatedNode();
                short changeType = mutEvent.getAttrChange();
                this.fixAttrModifiedSVGNodeInAdobeSVGInline(elem, attr, changeType);
            }
        } else if (type.equals("DOMCharacterDataModified") && (charDataNode = (CharacterData)((Object)mutEvent.getTarget())) instanceof Text && this.isSVGNodeAndAdobeSVGInline(charDataNode)) {
            this.fixTextDataModifiedSVGNodeInAdobeSVGInline((Text)charDataNode);
        }
    }

    private void fixTreeNamespaces(Node node) {
        StringBuilder code = this.fixTreeNamespaces(node, null);
        if (code != null && code.length() > 0) {
            this.clientDoc.addCodeToSend(code.toString());
        }
    }

    private StringBuilder fixTreeNamespaces(Node node, StringBuilder code) {
        if (node.getNodeType() != 1) {
            return code;
        }
        Element elem = (Element)node;
        if (elem.hasAttributes()) {
            NamedNodeMap attribs = elem.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                String value;
                Attr attr = (Attr)attribs.item(i);
                String prefix = attr.getPrefix();
                if (prefix == null || !prefix.equals("xmlns") || NamespaceUtil.isItsNatNamespace(value = attr.getValue())) continue;
                String localName = attr.getName().substring(prefix.length() + 1);
                if (code == null) {
                    code = new StringBuilder();
                }
                code.append("itsNatDoc.doc.namespaces.add(\"" + localName + "\",\"" + value + "\");\n");
            }
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            code = this.fixTreeNamespaces(child, code);
        }
        return code;
    }

    private void fixTreeInsertedSVGNodeInAdobeSVGInline(Node node) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        StringBuilder code = new StringBuilder();
        String methodName = "fixSVGNodeInsertedAdobeSVG";
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindFixSVGNodeInsertedAdobeSVGMethod(methodName));
        }
        String jsRef = clientDoc.getNodeReference(node, true, true);
        code.append("itsNatDoc." + methodName + "(" + jsRef + ");\n");
        clientDoc.addCodeToSend(code);
    }

    private String bindFixSVGNodeInsertedAdobeSVGMethod(String methodName) {
        StringBuilder code = new StringBuilder();
        code.append("var func = function(node)\n");
        code.append("{\n");
        code.append("  if (node == null) return;");
        code.append("  var parentPeer = node.parentNode._svg_peer;");
        code.append("  if (!parentPeer) return;");
        code.append("  var svgDoc = parentPeer.ownerDocument;");
        code.append("  var nodePeer;");
        code.append("  if (node.nodeType == 1)");
        code.append("  {");
        code.append("    nodePeer = svgDoc.createElement(node.nodeName);");
        code.append("    node._svg_peer = nodePeer;");
        code.append("    for(var i = 0; i < node.attributes.length; i++)");
        code.append("    {");
        code.append("      var attr = node.attributes[i];");
        code.append("      if (attr.specified) nodePeer.setAttribute(attr.name,this.getAttribute(node,attr.name));");
        code.append("    }");
        code.append("    var sibElem = node.nextSibling;");
        code.append("    while((sibElem != null) && !sibElem._svg_peer) sibElem = sibElem.nextSibling;");
        code.append("    var sibElemPeer = sibElem != null? sibElem._svg_peer : null;");
        code.append("    parentPeer.insertBefore(nodePeer,sibElemPeer);");
        code.append("  }");
        code.append("  else if (node.nodeType == 3)");
        code.append("  {");
        code.append("    var childNodes = node.parentNode.childNodes;");
        code.append("    var i;");
        code.append("    for(i = 0; i < childNodes.length; i++)");
        code.append("    {");
        code.append("      var currNode = childNodes[i];");
        code.append("      if (node == currNode) continue;");
        code.append("      if ((currNode.nodeType == 1)||(currNode.nodeType == 3)) break;");
        code.append("    }");
        code.append("    if (i != childNodes.length) return;");
        code.append("    nodePeer = svgDoc.createTextNode(node.data);");
        code.append("    parentPeer.appendChild(nodePeer);");
        code.append("  }");
        code.append("  else return;");
        code.append("  if (!node.hasChildNodes()) return;");
        code.append("  for(var i = node.childNodes.length - 1; i >= 0; i--)");
        code.append("  {");
        code.append("    var childNode = node.childNodes[i];");
        code.append("    this." + methodName + "(childNode);");
        code.append("  }");
        code.append("};\n");
        code.append("itsNatDoc." + methodName + " = func;\n");
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    private void fixTreeRemovedSVGNodeInAdobeSVGInline(Node node) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        StringBuilder code = new StringBuilder();
        String methodName = "fixSVGNodeRemovedAdobeSVG";
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindFixSVGNodeRemovedAdobeSVGMethod(methodName));
        }
        String nodeRef = clientDoc.getNodeReference(node, false, true);
        code.append("itsNatDoc." + methodName + "(" + nodeRef + ");\n");
        clientDoc.addCodeToSend(code);
    }

    private String bindFixSVGNodeRemovedAdobeSVGMethod(String methodName) {
        StringBuilder code = new StringBuilder();
        code.append("var func = function(node)\n");
        code.append("{\n");
        code.append("  if (node == null) return;");
        code.append("  var parentPeer = node.parentNode._svg_peer;");
        code.append("  if (!parentPeer) return;");
        code.append("  var nodePeer;");
        code.append("  if (node.nodeType == 1)");
        code.append("    nodePeer = node._svg_peer;");
        code.append("  else if (node.nodeType == 3)");
        code.append("  {");
        code.append("    var childNodes = node.parentNode.childNodes;");
        code.append("    var i;");
        code.append("    for(i = 0; i < childNodes.length; i++)");
        code.append("    {");
        code.append("      var currNode = childNodes[i]; ");
        code.append("      if (node == currNode) continue;");
        code.append("      if ((currNode.nodeType == 1)||(currNode.nodeType == 3)) break;");
        code.append("    }");
        code.append("    if (i != childNodes.length) return;");
        code.append("    nodePeer = parentPeer.firstChild;");
        code.append("    while((nodePeer != null)&&(nodePeer.nodeType != 3)) nodePeer = nodePeer.nextSibling;");
        code.append("    if (!nodePeer) return;");
        code.append("    nodePeer.data = '';");
        code.append("  }");
        code.append("  else return;");
        code.append("  parentPeer.removeChild(nodePeer);");
        code.append("};\n");
        code.append("itsNatDoc." + methodName + " = func;\n");
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    private void fixAttrModifiedSVGNodeInAdobeSVGInline(Element elem, Attr attr, int changeType) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        String valueJS = null;
        switch (changeType) {
            case 1: 
            case 2: {
                valueJS = JSRenderAttributeImpl.toTransportableStringLiteral(attr.getValue(), clientDoc.getBrowserWeb());
                break;
            }
            case 3: {
                valueJS = "null";
            }
        }
        StringBuilder code = new StringBuilder();
        String methodName = "fixSVGNodeAttrAdobeSVG";
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindFixSVGNodeAttrAdobeSVGMethod(methodName));
        }
        String jsRef = clientDoc.getNodeReference(elem, false, true);
        code.append("itsNatDoc." + methodName + "(" + jsRef + ",\"" + attr.getName() + "\"," + valueJS + "," + changeType + ");\n");
        clientDoc.addCodeToSend(code);
    }

    private String bindFixSVGNodeAttrAdobeSVGMethod(String methodName) {
        StringBuilder code = new StringBuilder();
        code.append("var func = function(node,name,value,action)\n");
        code.append("{\n");
        code.append("  var nodePeer = node._svg_peer;");
        code.append("  if (!nodePeer) return;");
        code.append("  if (action == 3) nodePeer.removeAttribute(name);");
        code.append("  else nodePeer.setAttribute(name,value);");
        code.append("};\n");
        code.append("itsNatDoc." + methodName + " = func;\n");
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    private void fixTextDataModifiedSVGNodeInAdobeSVGInline(Text node) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        JSRenderHTMLTextMSIEOldImpl render = JSRenderHTMLTextMSIEOldImpl.SINGLETON;
        String dataJS = render.dataTextToJS(node, (ClientDocumentStfulDelegateImpl)clientDoc);
        StringBuilder code = new StringBuilder();
        String methodName = "fixSVGNodeTextModAdobeSVG";
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindFixSVGNodeTextModifiedAdobeSVGMethod(methodName));
        }
        String jsRef = clientDoc.getNodeReference(node, false, true);
        code.append("itsNatDoc." + methodName + "(" + jsRef + "," + dataJS + ");\n");
        clientDoc.addCodeToSend(code);
    }

    private String bindFixSVGNodeTextModifiedAdobeSVGMethod(String methodName) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        StringBuilder code = new StringBuilder();
        code.append("var func = function(node,data)\n");
        code.append("{\n");
        code.append("  if (node == null) return;");
        code.append("  var parentPeer = node.parentNode._svg_peer;");
        code.append("  if (!parentPeer) return;");
        code.append("  var nodePeer;");
        code.append("  var childNodes = node.parentNode.childNodes;");
        code.append("  var i;");
        code.append("  for(i = 0; i < childNodes.length; i++)");
        code.append("  {");
        code.append("    var currNode = childNodes[i]; ");
        code.append("    if (node == currNode) continue;");
        code.append("    if ((currNode.nodeType == 1)||(currNode.nodeType == 3)) break;");
        code.append("  }");
        code.append("  if (i != childNodes.length) return;");
        code.append("  nodePeer = parentPeer.firstChild;");
        code.append("  while((nodePeer != null) && (nodePeer.nodeType != 3)) nodePeer = nodePeer.nextSibling;");
        code.append("  if (nodePeer == null)");
        code.append("  {");
        code.append("    var svgDoc = parentPeer.ownerDocument;");
        code.append("    nodePeer = svgDoc.createTextNode('');");
        code.append("    parentPeer.appendChild(nodePeer);");
        code.append("  }");
        code.append("  nodePeer.data = data;");
        code.append("};\n");
        code.append("itsNatDoc." + methodName + " = func;\n");
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }
}

