/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.mut.client.web;

import org.itsnat.impl.core.browser.web.BrowserGecko;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.listener.WaitForEventListenerImpl;
import org.itsnat.impl.core.mut.client.ClientMutationEventListenerStfulWebImpl;
import org.itsnat.impl.core.mut.client.web.ClientMutationEventListenerHTMLDefaultImpl;
import org.itsnat.impl.core.mut.client.web.ClientMutationEventListenerHTMLMSIEOldImpl;
import org.itsnat.impl.core.mut.client.web.ClientMutationEventListenerHTMLWebKitImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class ClientMutationEventListenerHTMLImpl
extends ClientMutationEventListenerStfulWebImpl {
    public ClientMutationEventListenerHTMLImpl(ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(clientDoc);
    }

    public static ClientMutationEventListenerHTMLImpl createClientMutationEventListenerHTML(ClientDocumentStfulDelegateWebImpl clientDoc) {
        BrowserWeb browser = clientDoc.getBrowserWeb();
        if (browser instanceof BrowserMSIEOld) {
            return new ClientMutationEventListenerHTMLMSIEOldImpl(clientDoc);
        }
        if (browser instanceof BrowserWebKit) {
            return ClientMutationEventListenerHTMLWebKitImpl.createClientMutationEventListenerHTMLWebKit(clientDoc);
        }
        if (browser instanceof BrowserGecko) {
            return new ClientMutationEventListenerHTMLDefaultImpl(clientDoc);
        }
        return new ClientMutationEventListenerHTMLDefaultImpl(clientDoc);
    }

    @Override
    public void preRenderAndSendMutationCode(MutationEvent mutEvent) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        String type = mutEvent.getType();
        if (type.equals("DOMNodeRemoved") && SVGWebInfoImpl.isSVGWebEnabled(clientDoc)) {
            Node removedNode = (Node)((Object)mutEvent.getTarget());
            SVGWebInfoImpl svgWeb = clientDoc.getSVGWebInfo();
            if (!svgWeb.isSVGNodeProcessedBySVGWebFlash(removedNode)) {
                this.fixTreeRemovedSVGRootSVGWeb(removedNode);
            }
        }
    }

    @Override
    public void postRenderAndSendMutationCode(MutationEvent mutEvent) {
        super.postRenderAndSendMutationCode(mutEvent);
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        String type = mutEvent.getType();
        if (type.equals("DOMNodeRemoved")) {
            Node removedNode = (Node)((Object)mutEvent.getTarget());
            if (removedNode instanceof Text && SVGWebInfoImpl.isSVGNodeProcessedBySVGWebFlash(removedNode, clientDoc)) {
                StringBuilder code = new StringBuilder();
                Node parentNode = removedNode.getParentNode();
                String jsRef = clientDoc.getNodeReference(parentNode, true, true);
                code.append("var elem = " + jsRef + ";\n");
                code.append("var elemClone = elem.cloneNode(false);\n");
                code.append("elem.parentNode.replaceChild(elemClone,elem);");
                code.append("elemClone.parentNode.replaceChild(elem,elemClone);");
                clientDoc.addCodeToSend(code);
            }
        } else if (type.equals("DOMNodeInserted") && SVGWebInfoImpl.isSVGWebEnabled(clientDoc)) {
            Node newNode = (Node)((Object)mutEvent.getTarget());
            this.processTreeInsertedSVGRootSVGWebWaitForEvent(newNode);
        }
    }

    protected void fixTreeRemovedSVGRootSVGWeb(Node node) {
        StringBuilder code = this.fixTreeRemovedSVGRootSVGWeb(node, null);
        if (code != null && code.length() > 0) {
            this.clientDoc.addCodeToSend(code.toString());
        }
    }

    protected StringBuilder fixTreeRemovedSVGRootSVGWeb(Node node, StringBuilder code) {
        if (node.getNodeType() != 1) {
            return code;
        }
        Element elem = (Element)node;
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        if (SVGWebInfoImpl.isSVGRootElementProcessedBySVGWebFlash(elem, clientDoc)) {
            if (code == null) {
                code = new StringBuilder();
            }
            String jsRef = clientDoc.getNodeReference(elem, false, true);
            code.append("var elem = " + jsRef + ";\n");
            code.append("itsNatDoc.win.svgweb.removeChild(elem,elem.parentNode);\n");
            return code;
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            code = this.fixTreeRemovedSVGRootSVGWeb(child, code);
        }
        return code;
    }

    protected void processTreeInsertedSVGRootSVGWebWaitForEvent(Node node) {
        if (node.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)node;
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        if (SVGWebInfoImpl.isSVGRootElementProcessedBySVGWebFlash(elem, clientDoc)) {
            WaitForEventListenerImpl listener = new WaitForEventListenerImpl(elem, "SVGLoad");
            clientDoc.getClientDocumentStful().addEventListener((EventTarget)((Object)elem), "SVGLoad", listener, false);
            clientDoc.addCodeToSend(listener);
            return;
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTreeInsertedSVGRootSVGWebWaitForEvent(child);
        }
    }
}

