/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.mut.client;

import java.io.Serializable;
import java.util.LinkedList;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulOwnerImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.BoundElementDocContainerImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domimpl.ElementDocContainer;
import org.itsnat.impl.core.domimpl.ItsNatNodeInternal;
import org.itsnat.impl.core.mut.client.ClientMutationEventListenerStfulDroidImpl;
import org.itsnat.impl.core.mut.client.ClientMutationEventListenerStfulWebImpl;
import org.itsnat.impl.core.mut.doc.DocMutationEventListenerStfulImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public abstract class ClientMutationEventListenerStfulImpl
implements Serializable {
    protected ClientDocumentStfulDelegateImpl clientDoc;

    public ClientMutationEventListenerStfulImpl(ClientDocumentStfulDelegateImpl clientDoc) {
        this.clientDoc = clientDoc;
    }

    public static ClientMutationEventListenerStfulImpl createClientMutationEventListenerStful(ClientDocumentStfulDelegateImpl clientDoc) {
        Browser browser = clientDoc.getClientDocumentStful().getBrowser();
        if (browser instanceof BrowserWeb) {
            return ClientMutationEventListenerStfulWebImpl.createClientMutationEventListenerStfulWeb((ClientDocumentStfulDelegateWebImpl)clientDoc);
        }
        return new ClientMutationEventListenerStfulDroidImpl((ClientDocumentStfulDelegateDroidImpl)clientDoc);
    }

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegate() {
        return this.clientDoc;
    }

    public boolean canRenderAndSendMutationCode() {
        ItsNatStfulDocumentImpl itsNatDoc = this.clientDoc.getItsNatStfulDocument();
        return itsNatDoc.canRenderAndSendMutationCode() && this.clientDoc.getClientDocumentStful().isSendCodeEnabled();
    }

    public DocMutationEventListenerStfulImpl getDocMutationEventListenerStful() {
        return this.clientDoc.getItsNatStfulDocument().getDocMutationListenerEventStful();
    }

    public boolean isDisconnectedFromClient(Node node) {
        return ((ItsNatNodeInternal)node).getDelegateNode().isDisconnectedFromClient();
    }

    protected void removeTreeFromNodeCache(Node node, LinkedList<String> idList) {
        String id = this.clientDoc.removeNodeFromCache(node);
        if (id != null && idList != null) {
            idList.add(id);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.removeTreeFromNodeCache(child, idList);
        }
    }

    public void beforeRenderAndSendMutationCode(MutationEvent mutEvent) {
        ItsNatStfulDocumentImpl itsNatDoc = this.clientDoc.getItsNatStfulDocument();
        String type = mutEvent.getType();
        if (type.equals("DOMNodeInserted") && !itsNatDoc.isLoadingPhaseAndFastLoadMode()) {
            Node insertedNode = (Node)((Object)mutEvent.getTarget());
            this.processTreeInsertedElementDocContainer(true, insertedNode);
        }
    }

    public void afterRenderAndSendMutationCode(MutationEvent mutEvent) {
        ItsNatStfulDocumentImpl itsNatDoc = this.clientDoc.getItsNatStfulDocument();
        String type = mutEvent.getType();
        if (this.clientDoc.isNodeCacheEnabled() && (!itsNatDoc.isLoadingPhaseAndFastLoadMode() || itsNatDoc.isDebugMode()) && type.equals("DOMNodeRemoved")) {
            Node removedNode = (Node)((Object)mutEvent.getTarget());
            this.removeTreeFromNodeCache(removedNode);
        }
        if (type.equals("DOMNodeInserted") && !itsNatDoc.isLoadingPhaseAndFastLoadMode()) {
            Node insertedNode = (Node)((Object)mutEvent.getTarget());
            this.processTreeInsertedElementDocContainer(false, insertedNode);
        }
    }

    protected void processTreeInsertedElementDocContainer(boolean beforeRender, Node node) {
        ElementDocContainer elem;
        BoundElementDocContainerImpl bindInfo;
        if (node instanceof ElementDocContainer && (bindInfo = (elem = (ElementDocContainer)((Object)node)).getElementDocContainerWrapper().getBoundElementDocContainer()) != null) {
            ClientDocumentStfulImpl clientDocParent;
            DocMutationEventListenerStfulImpl docMut = this.getDocMutationEventListenerStful();
            boolean modeOld = docMut.isEnabled();
            docMut.setEnabled(false);
            if (beforeRender) {
                clientDocParent = this.clientDoc.getClientDocumentStful();
                if (clientDocParent instanceof ClientDocumentStfulOwnerImpl) {
                    bindInfo.setURLForClientOwner((ClientDocumentStfulOwnerImpl)clientDocParent);
                } else {
                    bindInfo.setURLForClientAttached((ClientDocumentAttachedClientImpl)clientDocParent);
                }
            } else {
                clientDocParent = this.clientDoc.getClientDocumentStful();
                bindInfo.restoreOriginalURL(clientDocParent);
            }
            docMut.setEnabled(modeOld);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTreeInsertedElementDocContainer(beforeRender, child);
        }
    }

    public void renderAndSendMutationCode(MutationEvent mutEvent) {
        String type = mutEvent.getType();
        if (type.equals("DOMNodeInserted")) {
            Node newNode = (Node)((Object)mutEvent.getTarget());
            Object code = this.getTreeDOMNodeInsertedCode(newNode);
            this.clientDoc.addCodeToSend(code);
        } else if (type.equals("DOMNodeRemoved")) {
            Node removedNode = (Node)((Object)mutEvent.getTarget());
            if (!this.isDisconnectedFromClient(removedNode)) {
                Object code = this.getTreeDOMNodeRemovedCode(removedNode);
                this.clientDoc.addCodeToSend(code);
            }
        } else if (type.equals("DOMAttrModified")) {
            Attr attr = (Attr)mutEvent.getRelatedNode();
            Element elem = (Element)((Object)mutEvent.getTarget());
            short changeType = mutEvent.getAttrChange();
            String code = this.getDOMAttrModifiedCode(attr, elem, changeType);
            this.clientDoc.addCodeToSend(code);
        } else if (type.equals("DOMCharacterDataModified")) {
            CharacterData charDataNode = (CharacterData)((Object)mutEvent.getTarget());
            String code = this.getCharacterDataModifiedCode(charDataNode);
            this.clientDoc.addCodeToSend(code);
        }
    }

    protected void removeTreeFromNodeCache(Node node) {
        LinkedList<String> idList = null;
        if (this.clientDoc.getClientDocumentStful().isSendCodeEnabled()) {
            idList = new LinkedList<String>();
        }
        this.removeTreeFromNodeCache(node, idList);
        if (idList != null && !idList.isEmpty()) {
            String code = this.getRemoveNodeFromCacheCode(idList);
            this.clientDoc.addCodeToSend(code);
            ItsNatStfulDocumentImpl itsNatDoc = this.clientDoc.getItsNatStfulDocument();
            if (itsNatDoc.isLoadingPhaseAndFastLoadMode()) {
                throw new ItsNatDOMException("A cached DOM node is being removed on load time in fast load mode. Avoid any access to this node or avoid removing in load time (use a load event instead) or disable fast load mode.", node);
            }
        }
    }

    public void removeAllChildNodes(Node node) {
        if (this.canRenderAndSendMutationCode()) {
            String code = this.getRemoveAllChildCode(node);
            this.clientDoc.addCodeToSend(code);
        }
    }

    public abstract String getRemoveAllChildCode(Node var1);

    public abstract void preRenderAndSendMutationCode(MutationEvent var1);

    public abstract Object getTreeDOMNodeInsertedCode(Node var1);

    public abstract Object getTreeDOMNodeRemovedCode(Node var1);

    public abstract String getRemoveNodeFromCacheCode(LinkedList<String> var1);

    protected abstract String getDOMAttrModifiedCode(Attr var1, Element var2, int var3);

    public abstract void postRenderAndSendMutationCode(MutationEvent var1);

    protected abstract String getCharacterDataModifiedCode(CharacterData var1);
}

