/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.markup.render;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ItsNatXercesHTMLSerializerOld
extends HTMLSerializer {
    protected String fUserXHTMLNamespace = null;
    protected boolean _xhtml;

    public ItsNatXercesHTMLSerializerOld(Writer writer, OutputFormat format) {
        super(false, format);
        this.setOutputCharStream(writer);
        this._xhtml = false;
    }

    protected void serializeElement(Element elem) throws IOException {
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean preserveSpace = state.preserveSpace;
        this._printer.printText('<');
        if (this._xhtml) {
            this._printer.printText(tagName.toLowerCase(Locale.ENGLISH));
        } else {
            this._printer.printText(tagName);
        }
        this._printer.indent();
        NamedNodeMap attrMap = elem.getAttributes();
        if (attrMap != null) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (!attr.getSpecified()) continue;
                this._printer.printSpace();
                if (this._xhtml) {
                    if (value == null) {
                        this._printer.printText(name);
                        this._printer.printText("=\"\"");
                        continue;
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    continue;
                }
                if (value == null) {
                    value = "";
                }
                if (!this._format.getPreserveEmptyAttributes() && value.length() == 0) {
                    this._printer.printText(name);
                    continue;
                }
                if (HTMLdtd.isURI((String)tagName, (String)name)) {
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this._printer.printText(this.escapeURI(value));
                    this._printer.printText('\"');
                    continue;
                }
                if (HTMLdtd.isBoolean((String)tagName, (String)name)) {
                    this._printer.printText(name);
                    continue;
                }
                this._printer.printText(name);
                this._printer.printText("=\"");
                this.printEscaped(value);
                this._printer.printText('\"');
            }
        }
        if (HTMLdtd.isPreserveSpace((String)tagName)) {
            preserveSpace = true;
        }
        if (elem.hasChildNodes() || !ItsNatXercesHTMLSerializerOld.isEmptyTag(tagName)) {
            state = this.enterElementState(null, null, tagName, preserveSpace);
            if (tagName.equalsIgnoreCase("A") || tagName.equalsIgnoreCase("TD")) {
                state.empty = false;
                this._printer.printText('>');
            }
            if (tagName.equalsIgnoreCase("SCRIPT") || tagName.equalsIgnoreCase("STYLE")) {
                if (this._xhtml) {
                    state.doCData = true;
                } else {
                    state.unescaped = true;
                }
            }
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.serializeNode(child);
            }
            this.endElementIO(null, null, tagName);
        } else {
            this._printer.unindent();
            if (this._xhtml) {
                this._printer.printText(" />");
            } else {
                this._printer.printText('>');
            }
            state.afterElement = true;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    protected void startDocument(String rootTagName) throws IOException {
        this._printer.leaveDTD();
        if (!this._started) {
            boolean HTML5_support = true;
            if (HTML5_support && this._docTypePublicId == null && this._docTypeSystemId == null && !this._xhtml) {
                this._printer.printText("<!DOCTYPE html>");
                this._printer.breakLine();
            } else {
                if (this._docTypePublicId == null && this._docTypeSystemId == null) {
                    if (this._xhtml) {
                        this._docTypePublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                        this._docTypeSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
                    } else {
                        this._docTypePublicId = "-//W3C//DTD HTML 4.01//EN";
                        this._docTypeSystemId = "http://www.w3.org/TR/html4/strict.dtd";
                    }
                }
                if (!this._format.getOmitDocumentType()) {
                    if (!(this._docTypePublicId == null || this._xhtml && this._docTypeSystemId == null)) {
                        if (this._xhtml) {
                            this._printer.printText("<!DOCTYPE html PUBLIC ");
                        } else {
                            this._printer.printText("<!DOCTYPE HTML PUBLIC ");
                        }
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._docTypeSystemId != null) {
                            if (this._indenting) {
                                this._printer.breakLine();
                                this._printer.printText("                      ");
                            } else {
                                this._printer.printText(' ');
                            }
                            this.printDoctypeURL(this._docTypeSystemId);
                        }
                        this._printer.printText('>');
                        this._printer.breakLine();
                    } else if (this._docTypeSystemId != null) {
                        if (this._xhtml) {
                            this._printer.printText("<!DOCTYPE html SYSTEM ");
                        } else {
                            this._printer.printText("<!DOCTYPE HTML SYSTEM ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                        this._printer.printText('>');
                        this._printer.breakLine();
                    }
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    public static boolean isEmptyTag(String tagName) {
        boolean res = HTMLdtd.isEmptyTag((String)tagName);
        if (res) {
            return res;
        }
        String tagNameUpper = tagName.toUpperCase();
        return "WBR".equals(tagNameUpper) || "EMBED".equals(tagNameUpper) || "SOURCE".equals(tagNameUpper) || "TRACK".equals(tagNameUpper) || "KEYGEN".equals(tagNameUpper) || "COMMAND".equals(tagNameUpper) || "DEVICE".equals(tagNameUpper);
    }
}

