/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.markup.render;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.markup.render.DOMRenderImpl;
import org.itsnat.impl.core.markup.render.ItsNatXercesHTMLSerializerOldDocFragment;
import org.itsnat.impl.core.markup.render.ItsNatXercesHTMLSerializerOldDocument;
import org.itsnat.impl.core.markup.render.ItsNatXercesHTMLSerializerOldSingleElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMRenderXercesOldImpl
extends DOMRenderImpl {
    protected transient OutputFormat format = this.createOutputFormat();

    public DOMRenderXercesOldImpl(Document doc, String mime, String encoding, boolean nodeOnlyRender) {
        super(doc, mime, encoding, nodeOnlyRender);
    }

    public OutputFormat createOutputFormat() {
        boolean omitDocType = this.nodeOnlyRender || this.docRef.getDoctype() == null;
        OutputFormat format = new OutputFormat(this.docRef, this.encoding, false);
        format.setLineSeparator("\n");
        format.setPreserveSpace(true);
        format.setPreserveEmptyAttributes(true);
        format.setOmitDocumentType(omitDocType);
        format.setOmitXMLDeclaration(this.nodeOnlyRender);
        return format;
    }

    public DOMSerializer getDOMSerializer(Writer out, int nodeType) {
        if (this.mime.equals("text/html")) {
            switch (nodeType) {
                case 9: {
                    return new ItsNatXercesHTMLSerializerOldDocument(out, this.format);
                }
                case 1: {
                    return new ItsNatXercesHTMLSerializerOldSingleElement(out, this.format);
                }
                case 11: {
                    return new ItsNatXercesHTMLSerializerOldDocFragment(out, this.format);
                }
            }
            return new ItsNatXercesHTMLSerializerOldDocFragment(out, this.format);
        }
        throw new ItsNatException("INTERNAL ERROR");
    }

    @Override
    public void serializeDocument(Document doc, Writer out) {
        DOMSerializer serializer = this.getDOMSerializer(out, 9);
        try {
            serializer.serialize(doc);
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
    }

    @Override
    public void serializeNode(Node node, Writer out) {
        try {
            if (node.getNodeType() == 1) {
                DOMSerializer serializer = this.getDOMSerializer(out, 1);
                serializer.serialize((Element)node);
            } else {
                DOMSerializer serializer = this.getDOMSerializer(out, 11);
                DocumentFragment docFrag = node.getOwnerDocument().createDocumentFragment();
                docFrag.appendChild(node.cloneNode(true));
                serializer.serialize(docFrag);
            }
        }
        catch (IOException ex) {
            throw new ItsNatDOMException((Throwable)ex, node);
        }
    }
}

