/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.markup.render;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.markup.render.DOMRenderJAXPBaseImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMRenderXalanImpl
extends DOMRenderJAXPBaseImpl {
    public DOMRenderXalanImpl(Document doc, String mime, String encoding, boolean nodeOnlyRender) {
        super(doc, mime, encoding, nodeOnlyRender);
    }

    @Override
    public Properties getOutputProperties() {
        Properties props = super.getOutputProperties();
        props.put("{http://xml.apache.org/xalan}omit-meta-tag", "yes");
        return props;
    }

    public DOMSerializer getDOMSerializer(Writer out) {
        Serializer serializer = SerializerFactory.getSerializer((Properties)this.defaultProps);
        serializer.setWriter(out);
        try {
            return serializer.asDOMSerializer();
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
    }

    @Override
    public void serializeDocument(Document doc, Writer out) {
        this.serializeNode(doc, out);
    }

    @Override
    public void serializeNode(Node node, Writer out) {
        DOMSerializer serializer = this.getDOMSerializer(out);
        try {
            serializer.serialize(node);
        }
        catch (IOException ex) {
            throw new ItsNatDOMException((Throwable)ex, node);
        }
    }
}

