/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.markup.render;

import java.io.StringWriter;
import java.io.Writer;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.XMLDecImpl;
import org.itsnat.impl.core.markup.render.DOMRenderXalanImpl;
import org.itsnat.impl.core.markup.render.DOMRenderXercesOldImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DOMRenderImpl {
    protected Document docRef;
    protected String mime;
    protected String encoding;
    protected boolean nodeOnlyRender;

    public DOMRenderImpl(Document doc, String mime, String encoding, boolean nodeOnlyRender) {
        this.docRef = doc;
        this.mime = mime;
        this.encoding = encoding;
        this.nodeOnlyRender = nodeOnlyRender;
    }

    public static DOMRenderImpl createDOMRender(Document doc, String mime, String encoding, boolean nodeOnlyRender) {
        if (mime.equals("text/html")) {
            return new DOMRenderXercesOldImpl(doc, mime, encoding, nodeOnlyRender);
        }
        return new DOMRenderXalanImpl(doc, mime, encoding, nodeOnlyRender);
    }

    public String serializeDocument(Document doc) {
        StringWriter out = new StringWriter();
        this.serializeDocument(doc, out);
        String markup = out.toString();
        XMLDecImpl xmlDec = ((DocumentImpl)doc).getXMLDec();
        if (xmlDec != null) {
            String standalone;
            String encoding;
            StringBuilder buffer = new StringBuilder("<?xml");
            String version = xmlDec.getVersion();
            if (version != null) {
                buffer.append(" version=\"" + version + "\"");
            }
            if ((encoding = xmlDec.getEncoding()) != null) {
                buffer.append(" encoding=\"" + encoding + "\"");
            }
            if ((standalone = xmlDec.getStandalone()) != null) {
                buffer.append(" standalone=\"" + standalone + "\"");
            }
            buffer.append("?>\n");
            buffer.append(markup);
            markup = buffer.toString();
        }
        return markup;
    }

    protected abstract void serializeDocument(Document var1, Writer var2);

    public abstract void serializeNode(Node var1, Writer var2);
}

