/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.markup.parse;

import java.io.IOException;
import org.apache.xerces.parsers.DOMParser;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.markup.parse.NekoHTMLDOMParserWrapperImpl;
import org.itsnat.impl.core.markup.parse.XercesXMLDOMParserWrapperImpl;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public abstract class XercesDOMParserWrapperImpl
implements ErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final String DEFAULT_LOAD_DTD_GRAMMAR_ID = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    protected static final String DEFAULT_LOAD_EXTERNAL_DTD_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_DTD_GRAMMAR = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = false;
    protected DOMParser parser = this.createParser();

    public XercesDOMParserWrapperImpl() {
        this.parser.setErrorHandler((ErrorHandler)this);
        try {
            this.parser.setFeature(VALIDATION_FEATURE_ID, false);
        }
        catch (SAXNotRecognizedException ex) {
            throw new ItsNatException(ex);
        }
        catch (SAXNotSupportedException ex) {
            throw new ItsNatException(ex);
        }
    }

    public static XercesDOMParserWrapperImpl createXercesDOMParserWrapper(int namespaceOfMIME, String defaultEncoding) {
        if (NamespaceUtil.isMIME_HTML_or_XHTML(namespaceOfMIME)) {
            return new NekoHTMLDOMParserWrapperImpl(defaultEncoding);
        }
        if (NamespaceUtil.isMIME_ANDROID_LAYOUT(namespaceOfMIME)) {
            return new XercesXMLDOMParserWrapperImpl(true);
        }
        return new XercesXMLDOMParserWrapperImpl(true);
    }

    public abstract DOMParser createParser();

    public Document parse(InputSource input) {
        try {
            this.parser.parse(input);
        }
        catch (SAXException ex) {
            throw new ItsNatException(ex);
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
        return this.parser.getDocument();
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    protected void printError(String type, SAXParseException ex) throws SAXException {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }
}

