/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.listener.trans;

import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.event.client.ClientItsNatNormalEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CMutationEventImpl;
import org.itsnat.impl.core.listener.trans.ParamTransportUtil;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class NodeMutationTransportUtil
extends ParamTransportUtil {
    public static final NodeMutationTransportUtil SINGLETON = new NodeMutationTransportUtil();

    @Override
    public void syncServerBeforeDispatch(ParamTransport param, RequestNormalEventImpl request, ClientItsNatNormalEventImpl event) {
        ItsNatStfulDocumentImpl itsNatDoc = event.getItsNatStfulDocument();
        MutationEvent mutEvent = (MutationEvent)((Object)event);
        String type = mutEvent.getType();
        if (type.equals("DOMNodeInserted")) {
            Element parent = (Element)mutEvent.getRelatedNode();
            W3CMutationEventImpl w3cMutEvent = (W3CMutationEventImpl)mutEvent;
            Node refNode = w3cMutEvent.getRefChild();
            String newValue = mutEvent.getNewValue();
            DocumentFragment newNodeFragment = itsNatDoc.getItsNatDocumentTemplateVersion().parseFragmentToDocFragment(newValue, itsNatDoc);
            Node newNode = newNodeFragment.getFirstChild();
            parent.insertBefore(newNode, refNode);
            w3cMutEvent.setTargetNodeInserted((EventTarget)((Object)newNode));
        } else if (!type.equals("DOMNodeRemoved")) {
            if (type.equals("DOMAttrModified")) {
                Attr attr = (Attr)mutEvent.getRelatedNode();
                Element targetElem = (Element)((Object)mutEvent.getTarget());
                short changeType = mutEvent.getAttrChange();
                switch (changeType) {
                    case 2: {
                        String attrName = mutEvent.getAttrName();
                        DOMUtilInternal.setAttribute(targetElem, attrName, mutEvent.getNewValue());
                        attr = targetElem.getAttributeNode(attrName);
                        W3CMutationEventImpl w3cMutEvent = (W3CMutationEventImpl)mutEvent;
                        w3cMutEvent.setRelatedNodeAddedAttr(attr);
                        break;
                    }
                    case 1: {
                        attr.setValue(mutEvent.getNewValue());
                        break;
                    }
                    case 3: {
                        targetElem.removeAttributeNode(attr);
                    }
                }
            } else if (type.equals("DOMCharacterDataModified")) {
                CharacterData charNode = (CharacterData)((Object)mutEvent.getTarget());
                DOMUtilInternal.setCharacterDataContent(charNode, mutEvent.getNewValue());
            }
        }
    }

    @Override
    public void syncServerAfterDispatch(ParamTransport param, RequestNormalEventImpl request, ClientItsNatNormalEventImpl event) {
        MutationEvent mutEvent = (MutationEvent)((Object)event);
        String type = mutEvent.getType();
        if (type.equals("DOMNodeRemoved")) {
            Element parent = (Element)mutEvent.getRelatedNode();
            Node removedNode = (Node)((Object)mutEvent.getTarget());
            parent.removeChild(removedNode);
        }
    }
}

