/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.listener.dom.domext;

import org.itsnat.core.ItsNatTimer;
import org.itsnat.core.event.ItsNatTimerHandle;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatTimerImpl;
import org.itsnat.impl.core.event.client.ClientItsNatNormalEventImpl;
import org.itsnat.impl.core.event.client.dom.domext.ClientItsNatTimerEventImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatDOMExtEventListenerWrapperImpl;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;
import org.itsnat.impl.core.scriptren.bsren.listener.BSRenderItsNatTimerEventListenerImpl;
import org.itsnat.impl.core.scriptren.jsren.listener.norm.domext.JSRenderItsNatTimerEventListenerImpl;
import org.itsnat.impl.core.util.UserDataMonoThreadImpl;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ItsNatTimerEventListenerWrapperImpl
extends ItsNatDOMExtEventListenerWrapperImpl
implements ItsNatTimerHandle {
    private static final int SCHEDULED = 1;
    private static final int EXECUTED = 2;
    private static final int CANCELLED = 3;
    protected int commMode;
    protected long time;
    protected long period;
    protected long nextExecutionTime;
    protected boolean fixedRate = false;
    protected int state = 1;
    protected ItsNatTimerImpl timer;
    protected UserDataMonoThreadImpl userData;

    public ItsNatTimerEventListenerWrapperImpl(EventTarget target, EventListener listener, long time, long period, boolean fixedRate, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc, ItsNatTimerImpl timer) {
        super(timer.getItsNatStfulDocument(), timer.getClientDocumentStful(), target, listener, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        this.commMode = commMode;
        this.time = time;
        this.period = period;
        this.fixedRate = fixedRate;
        this.timer = timer;
        this.nextExecutionTime = time;
    }

    @Override
    public int getCommModeDeclared() {
        return this.commMode;
    }

    @Override
    public long getFirstTime() {
        return this.time;
    }

    public long getDelayFirstTime() {
        long delay = this.getFirstTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        return delay;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public ItsNatTimer getItsNatTimer() {
        return this.timer;
    }

    public ItsNatTimerImpl getItsNatTimerImpl() {
        return this.timer;
    }

    @Override
    public boolean cancel() {
        if (this.state == 3) {
            return false;
        }
        boolean res = this.state == 1 || this.state == 2 && this.period != 0L;
        this.state = 3;
        this.timer.removeListener(this);
        return res;
    }

    @Override
    public boolean isCancelled() {
        return this.state == 3;
    }

    @Override
    public long scheduledExecutionTime() {
        return this.nextExecutionTime;
    }

    @Override
    public void handleEvent(ClientItsNatNormalEventImpl event) {
        long computedPeriod = this.handleTimerEvent((ClientItsNatTimerEventImpl)event);
        if (computedPeriod != -1L) {
            String code = null;
            ClientDocumentStfulDelegateImpl clientDoc = event.getClientDocumentStful().getClientDocumentStfulDelegate();
            if (clientDoc instanceof ClientDocumentStfulDelegateWebImpl) {
                JSRenderItsNatTimerEventListenerImpl render = JSRenderItsNatTimerEventListenerImpl.getJSRenderItsNatTimerEventListener();
                code = render.updateItsNatTimerEventListenerCode(this, computedPeriod, (ClientDocumentStfulDelegateWebImpl)clientDoc);
            } else if (clientDoc instanceof ClientDocumentStfulDelegateDroidImpl) {
                BSRenderItsNatTimerEventListenerImpl render = BSRenderItsNatTimerEventListenerImpl.getBSRenderItsNatTimerEventListener();
                code = render.updateItsNatTimerEventListenerCode(this, computedPeriod, (ClientDocumentStfulDelegateDroidImpl)clientDoc);
            }
            clientDoc.addCodeToSend(code.toString());
        }
    }

    public long handleTimerEvent(ClientItsNatTimerEventImpl event) {
        if (this.state != 3) {
            long computedPeriod;
            this.state = 2;
            super.handleEvent(event);
            if (this.state == 3) {
                return -1L;
            }
            if (this.period == 0L) {
                this.timer.removeListener(this);
                return -1L;
            }
            if (!this.fixedRate) {
                this.nextExecutionTime = System.currentTimeMillis() + this.period;
                computedPeriod = this.period;
            } else {
                this.nextExecutionTime += this.period;
                computedPeriod = System.currentTimeMillis() >= this.nextExecutionTime ? 0L : this.period;
            }
            return computedPeriod;
        }
        this.timer.removeListener(this);
        return -1L;
    }

    public static String getTypeStatic() {
        return "itsnat:timer";
    }

    @Override
    public String getType() {
        return ItsNatTimerEventListenerWrapperImpl.getTypeStatic();
    }

    public UserDataMonoThreadImpl getUserData() {
        if (this.userData == null) {
            this.userData = new UserDataMonoThreadImpl();
        }
        return this.userData;
    }

    @Override
    public boolean containsUserValueName(String name) {
        return this.getUserData().containsName(name);
    }

    @Override
    public String[] getUserValueNames() {
        return this.getUserData().getUserDataNames();
    }

    @Override
    public Object getUserValue(String name) {
        return this.getUserData().getUserData(name);
    }

    @Override
    public Object setUserValue(String name, Object value) {
        return this.getUserData().setUserData(name, value);
    }

    @Override
    public Object removeUserValue(String name) {
        return this.getUserData().removeUserData(name);
    }

    @Override
    public ClientItsNatNormalEventImpl createClientItsNatNormalEvent(RequestNormalEventImpl request) {
        return new ClientItsNatTimerEventImpl(this, request);
    }
}

