/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.listener.dom.domext;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatDocSynchronizerImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.listener.GenericTaskImpl;

public class AsyncTaskImpl
extends GenericTaskImpl
implements Runnable {
    protected boolean lockDoc;
    protected long maxWait;
    protected transient Thread thread;
    protected boolean started = false;
    protected Runnable task;
    protected ClientDocumentStfulImpl clientDoc;

    public AsyncTaskImpl(Runnable task, boolean lockDoc, long maxWait, ClientDocumentStfulImpl clientDoc) {
        if (task instanceof Thread) {
            throw new ItsNatException("Runnable object must not be a Thread", (Object)task);
        }
        this.task = task;
        this.lockDoc = lockDoc;
        this.maxWait = maxWait;
        this.clientDoc = clientDoc;
        this.thread = new Thread(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.thread = new Thread(this);
    }

    public ItsNatDocumentImpl getItsNatDocument() {
        return this.clientDoc.getItsNatStfulDocument();
    }

    public boolean isStarted() {
        return this.started;
    }

    public Runnable getTask() {
        return this.task;
    }

    public boolean locksDocument() {
        return this.lockDoc;
    }

    public void start() {
        this.thread.start();
        if (!this.started) {
            while (!this.started) {
                Thread.yield();
            }
        }
    }

    @Override
    public void dispose() {
        this.thread = null;
    }

    @Override
    public boolean isDisposed() {
        return this.thread == null;
    }

    @Override
    public boolean mustWait() {
        Thread thread = this.thread;
        if (thread == null) {
            return false;
        }
        return thread.isAlive();
    }

    @Override
    public void run() {
        this.started = true;
        final Runnable task = this.getTask();
        if (this.lockDoc) {
            ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
            ItsNatDocSynchronizerImpl syncTask = new ItsNatDocSynchronizerImpl(){

                @Override
                protected void syncMethod() {
                    task.run();
                }
            };
            syncTask.exec(itsNatDoc);
        } else {
            task.run();
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void waitToFinish() {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        if (thread.isAlive()) {
            try {
                thread.join(this.maxWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

