/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.listener;

import com.innowhere.relproxy.jproxy.JProxyScriptEngine;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.event.client.ClientItsNatNormalEventImpl;
import org.itsnat.impl.core.listener.EventListenerInternal;
import org.itsnat.impl.core.listener.EventListenerUtil;
import org.itsnat.impl.core.listener.ItsNatEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.trans.ParamTransportUtil;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;
import org.itsnat.impl.core.scriptren.shared.trans.JSAndBSRenderParamTransport;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ItsNatNormalEventListenerWrapperImpl
extends ItsNatEventListenerWrapperImpl {
    protected ClientDocumentStfulImpl clientDoc;
    protected EventListener listener;
    protected transient WeakReference<EventTarget> currTargetWeakRef;
    protected ParamTransport[] extraParams;
    protected String preSendCode;
    protected String bindToCustomFunc;
    protected long eventTimeout;

    public ItsNatNormalEventListenerWrapperImpl(ItsNatStfulDocumentImpl itsNatDoc, ClientDocumentStfulImpl clientDoc, EventTarget currTarget, EventListener listener, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        super(itsNatDoc);
        JProxyScriptEngine jProxy;
        if (listener != null && !(listener instanceof EventListenerInternal) && (jProxy = itsNatDoc.getItsNatServlet().getItsNatImpl().getJProxyScriptEngineIfConfigured()) != null) {
            listener = (EventListener)jProxy.create((Object)listener, EventListener.class);
        }
        this.clientDoc = clientDoc;
        this.eventTimeout = eventTimeout;
        this.currTargetWeakRef = currTarget != null ? new WeakReference<EventTarget>(currTarget) : null;
        this.extraParams = extraParams;
        this.preSendCode = preSendCode;
        this.listener = listener;
        this.bindToCustomFunc = bindToCustomFunc;
        this.checkClient();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        EventTarget currTarget = null;
        if (this.currTargetWeakRef != null) {
            currTarget = (EventTarget)this.currTargetWeakRef.get();
        }
        out.writeObject(currTarget);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        EventTarget currTarget = (EventTarget)in.readObject();
        if (currTarget != null) {
            this.currTargetWeakRef = new WeakReference<EventTarget>(currTarget);
        }
        in.defaultReadObject();
    }

    @Override
    public long getEventTimeout() {
        return this.eventTimeout;
    }

    public void checkClient() {
        if (this.clientDoc != null && !this.clientDoc.canReceiveNormalEvents(this)) {
            throw new ItsNatException("Attempt to register a listener for a remote control client with read only permission");
        }
    }

    public String getPreSendCode() {
        return this.preSendCode;
    }

    public String getBindToCustomFunc() {
        return this.bindToCustomFunc;
    }

    public boolean isEventTargetExpunged(EventTarget target) {
        return target == null && this.getEventTargetWeakRef() != null;
    }

    public WeakReference<EventTarget> getEventTargetWeakRef() {
        return this.currTargetWeakRef;
    }

    public EventTarget getCurrentTarget() {
        if (this.currTargetWeakRef == null) {
            return null;
        }
        return (EventTarget)this.currTargetWeakRef.get();
    }

    public String getCodeToSendParamTransports(ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.extraParams == null) {
            return null;
        }
        StringBuilder code = new StringBuilder();
        for (ParamTransport param : this.extraParams) {
            JSAndBSRenderParamTransport paramRender = JSAndBSRenderParamTransport.getSingleton(param);
            String paramCode = paramRender.getCodeToSend(param, clientDoc);
            if (paramCode == null) continue;
            code.append(paramCode);
        }
        return code.toString();
    }

    public EventListener getEventListenerOrProxy() {
        return this.listener;
    }

    public void processEvent(ClientItsNatNormalEventImpl event) {
        this.beforeAfterHandleEvent(true, event);
        this.handleEvent(event);
        this.beforeAfterHandleEvent(false, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAfterHandleEvent(boolean before, ClientItsNatNormalEventImpl event) {
        if (this.extraParams == null) {
            return;
        }
        RequestNormalEventImpl request = event.getRequestNormalEvent();
        ClientDocumentStfulImpl clientDoc = event.getClientDocumentStful();
        boolean wasEnabled = clientDoc.isSendCodeEnabled();
        if (wasEnabled) {
            clientDoc.disableSendCode();
        }
        try {
            for (int i = 0; i < this.extraParams.length; ++i) {
                ParamTransport param = this.extraParams[i];
                if (!param.isSync()) continue;
                ParamTransportUtil paramUtil = ParamTransportUtil.getSingleton(param);
                if (before) {
                    paramUtil.syncServerBeforeDispatch(param, request, event);
                    continue;
                }
                paramUtil.syncServerAfterDispatch(param, request, event);
            }
        }
        finally {
            if (wasEnabled) {
                clientDoc.enableSendCode();
            }
        }
    }

    public void handleEvent(ClientItsNatNormalEventImpl event) {
        EventListenerUtil.handleEventIncludingGlobalListeners(this.listener, event);
    }

    public static boolean canAddItsNatNormalEventListenerWrapper(EventListener listener, ItsNatStfulDocumentImpl itsNatDoc, ClientDocumentStfulImpl clientDoc) {
        if (clientDoc != null) {
            return clientDoc.canReceiveNormalEvents(listener);
        }
        return itsNatDoc.isEventsEnabled();
    }

    public abstract String getType();

    public abstract boolean getUseCapture();

    public abstract ClientItsNatNormalEventImpl createClientItsNatNormalEvent(RequestNormalEventImpl var1);
}

