/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.listener;

import java.util.LinkedList;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.event.ItsNatEventImpl;
import org.itsnat.impl.core.event.ItsNatEventListenerChainImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateImpl;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class EventListenerUtil {
    public static void handleEventListeners(Event evt, ItsNatEventListenerChainImpl<EventListener> chain) {
        if (chain.isStopped()) {
            return;
        }
        LinkedList<EventListener> listeners = chain.getListeners();
        while (!listeners.isEmpty()) {
            EventListener listener = listeners.removeFirst();
            listener.handleEvent(evt);
            if (!chain.isStopped()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEventListeners(final Event evt, LinkedList<EventListener> listeners) {
        ItsNatEventListenerChainImpl<EventListener> chain = new ItsNatEventListenerChainImpl<EventListener>(listeners){

            @Override
            public void continueChain() {
                super.continueChain();
                EventListenerUtil.handleEventListeners(evt, this);
            }
        };
        ItsNatEventImpl itsNatEvt = (ItsNatEventImpl)((Object)evt);
        itsNatEvt.setItsNatEventListenerChain(chain);
        try {
            EventListenerUtil.handleEventListeners(evt, chain);
        }
        finally {
            itsNatEvt.unsetEventListenerChain();
        }
    }

    private static void addGlobalEventListeners(Event evt, LinkedList<EventListener> listeners) {
        ItsNatEventImpl itsNatEvt = (ItsNatEventImpl)((Object)evt);
        ItsNatServletImpl servlet = itsNatEvt.getItsNatServletRequestImpl().getItsNatServletImpl();
        servlet.getGlobalEventListenerList(listeners);
        ItsNatStfulDocumentImpl itsNatDoc = itsNatEvt.getItsNatStfulDocument();
        if (itsNatDoc != null) {
            ItsNatDocumentTemplateImpl template = itsNatDoc.getItsNatDocumentTemplateImpl();
            template.getGlobalEventListenerList(listeners);
            itsNatDoc.getGlobalEventListenerList(listeners);
        }
        ClientDocumentImpl clientDoc = itsNatEvt.getClientDocumentImpl();
        clientDoc.getGlobalEventListenerList(listeners);
    }

    public static void handleEventIncludingGlobalListeners(EventListener listener, Event evt) {
        LinkedList<EventListener> listeners = new LinkedList<EventListener>();
        EventListenerUtil.addGlobalEventListeners(evt, listeners);
        if (listener != null) {
            listeners.add(listener);
        }
        EventListenerUtil.handleEventListeners(evt, listeners);
    }
}

