/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.listener;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.itsnat.impl.core.comet.CometNotifierImpl;
import org.itsnat.impl.core.listener.GenericTaskImpl;

public class CometTaskImpl
extends GenericTaskImpl {
    protected CometNotifierImpl notifier;
    protected transient Object monitor;

    public CometTaskImpl(CometNotifierImpl notifier) {
        this.notifier = notifier;
        this.monitor = notifier.getMonitor();
    }

    @Override
    public void dispose() {
        this.monitor = null;
        if (!this.notifier.isStopped()) {
            this.notifier.setPendingNotification(false);
            this.notifier.addCometTask();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.monitor = this.notifier.getMonitor();
    }

    @Override
    public boolean isDisposed() {
        return this.monitor == null;
    }

    public CometNotifierImpl getCometNotifier() {
        return this.notifier;
    }

    public long getEventTimeout() {
        return this.notifier.getEventTimeout();
    }

    @Override
    public boolean mustWait() {
        return !this.isDisposed() && !this.notifier.isStopped() && !this.notifier.hasPendingNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitToFinish() {
        Object monitor = this.monitor;
        if (monitor == null) {
            return;
        }
        try {
            long before = System.currentTimeMillis();
            long delay = this.notifier.getExpirationDelay();
            Object object = monitor;
            synchronized (object) {
                if (this.mustWait()) {
                    monitor.wait(delay);
                }
            }
            long after = System.currentTimeMillis();
            if (after - before > delay) {
                this.notifier.stop();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.monitor = null;
    }
}

