/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.event.server;

import java.util.ArrayList;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ItsNatNormalEvent;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.droid.ItsNatStfulDroidDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatStfulWebDocumentImpl;
import org.itsnat.impl.core.event.EventInternal;
import org.itsnat.impl.core.event.server.ServerItsNatEventStfulImpl;
import org.itsnat.impl.core.event.server.dom.domext.ServerItsNatContinueEventImpl;
import org.itsnat.impl.core.event.server.dom.domext.ServerItsNatDOMExtEventImpl;
import org.itsnat.impl.core.event.server.dom.domext.ServerItsNatUserEventImpl;
import org.itsnat.impl.core.event.server.dom.domstd.ServerItsNatDOMStdEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidEventImpl;
import org.itsnat.impl.core.listener.EventListenerUtil;
import org.itsnat.impl.core.registry.ItsNatNormalEventListenerRegistryImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ServerItsNatNormalEventImpl
extends ServerItsNatEventStfulImpl
implements ItsNatNormalEvent,
EventInternal {
    protected EventTarget currentTarget;
    protected EventTarget target;
    protected String type;
    protected boolean canBubble;
    protected boolean cancelable;
    protected long timeStamp = System.currentTimeMillis();
    protected boolean stopPropagation = false;
    protected boolean preventDefault = false;
    protected short phase;
    protected boolean initialized;

    public ServerItsNatNormalEventImpl(ItsNatStfulDocumentImpl itsNatDoc) {
        super(itsNatDoc);
    }

    public static ServerItsNatNormalEventImpl createServerNormalEvent(String eventGroup, ItsNatStfulDocumentImpl itsNatDoc) throws DOMException {
        if (eventGroup.startsWith("itsnat:")) {
            return ServerItsNatDOMExtEventImpl.createServerDOMExtEvent(eventGroup, itsNatDoc);
        }
        if (itsNatDoc instanceof ItsNatStfulWebDocumentImpl) {
            return ServerItsNatDOMStdEventImpl.createServerItsNatDOMStdEvent(eventGroup, itsNatDoc);
        }
        if (itsNatDoc instanceof ItsNatStfulDroidDocumentImpl) {
            return ServerItsNatDroidEventImpl.createServerItsNatDroidEvent(eventGroup, itsNatDoc);
        }
        return null;
    }

    @Override
    public EventTarget getCurrentTarget() {
        return this.currentTarget;
    }

    public void setCurrentTarget(EventTarget currentTarget) {
        this.currentTarget = currentTarget;
    }

    @Override
    public void initEvent(String eventTypeArg, boolean canBubbleArg, boolean cancelableArg) {
        this.type = eventTypeArg;
        this.canBubble = canBubbleArg;
        this.cancelable = cancelableArg;
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void checkInitializedEvent() {
        String type = this.getType();
        if (!this.initialized || type == null || type.equals("")) {
            throw new EventException(0, "Unspecified event type");
        }
    }

    @Override
    public EventTarget getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(EventTarget target) {
        this.target = target;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean getBubbles() {
        return this.canBubble;
    }

    @Override
    public boolean getCancelable() {
        return this.cancelable;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public short getEventPhase() {
        return this.phase;
    }

    public void setEventPhase(short phase) {
        this.phase = phase;
    }

    @Override
    public void stopPropagation() {
        this.stopPropagation = true;
    }

    @Override
    public boolean getStopPropagation() {
        return this.stopPropagation;
    }

    public void setStopPropagation(boolean value) {
        this.stopPropagation = value;
    }

    @Override
    public void preventDefault() {
        this.preventDefault = true;
    }

    @Override
    public boolean getPreventDefault() {
        return this.preventDefault;
    }

    public void setPreventDefault(boolean value) {
        this.preventDefault = value;
    }

    public static boolean dispatchEventLocally(EventTarget target, Event event) {
        if (event == null) {
            return false;
        }
        ServerItsNatNormalEventImpl evt = (ServerItsNatNormalEventImpl)event;
        evt.checkInitializedEvent();
        ItsNatStfulDocumentImpl itsNatDoc = evt.getItsNatStfulDocument();
        ClientDocumentStfulImpl clientDoc = evt.getClientDocumentStful();
        ItsNatNormalEventListenerRegistryImpl[] registries = new ItsNatNormalEventListenerRegistryImpl[2];
        if (evt instanceof ServerItsNatDOMStdEventImpl) {
            registries[0] = ((ItsNatStfulWebDocumentImpl)itsNatDoc).getDOMStdEventListenerRegistry();
            registries[1] = ((ClientDocumentStfulDelegateWebImpl)clientDoc.getClientDocumentStfulDelegate()).getDOMStdEventListenerRegistry();
        } else if (evt instanceof ServerItsNatDroidEventImpl) {
            registries[0] = ((ItsNatStfulDroidDocumentImpl)itsNatDoc).getDroidEventListenerRegistry();
            registries[1] = ((ClientDocumentStfulDelegateDroidImpl)clientDoc.getClientDocumentStfulDelegate()).getDroidEventListenerRegistry();
        } else if (evt instanceof ServerItsNatUserEventImpl) {
            registries[0] = itsNatDoc.getUserEventListenerRegistry();
            registries[1] = clientDoc.getUserEventListenerRegistry();
        } else if (evt instanceof ServerItsNatContinueEventImpl) {
            registries[0] = clientDoc.getContinueEventListenerRegistry();
            registries[1] = null;
        } else {
            throw new ItsNatException("Event type is not supported:" + event.getType(), (Object)event);
        }
        return ServerItsNatNormalEventImpl.dispatchEventLocally(target, evt, registries);
    }

    public static boolean dispatchEventLocally(EventTarget target, ServerItsNatNormalEventImpl evt, ItsNatNormalEventListenerRegistryImpl[] registries) {
        EventTarget currentTarget;
        Node targetNode = (Node)((Object)target);
        evt.setTarget(target);
        evt.setStopPropagation(false);
        evt.setPreventDefault(false);
        boolean someoneCaptures = false;
        for (int i = 0; i < registries.length; ++i) {
            if (registries[i] == null || registries[i].getCapturingCount() <= 0) continue;
            someoneCaptures = true;
            break;
        }
        ArrayList<Node> parentList = null;
        if (someoneCaptures || evt.getBubbles()) {
            parentList = new ArrayList<Node>();
            for (Node parent = targetNode.getParentNode(); parent != null; parent = parent.getParentNode()) {
                parentList.add(parent);
            }
        }
        if (someoneCaptures) {
            evt.setEventPhase((short)1);
            for (int i = parentList.size() - 1; i >= 0; --i) {
                currentTarget = (EventTarget)parentList.get(i);
                ServerItsNatNormalEventImpl.dispatchEventLocallyCurrentTarget(currentTarget, evt, true, registries);
                if (!evt.getStopPropagation()) continue;
                return evt.getPreventDefault();
            }
        }
        evt.setEventPhase((short)2);
        ServerItsNatNormalEventImpl.dispatchEventLocallyCurrentTarget(target, evt, false, registries);
        if (evt.getStopPropagation()) {
            return evt.getPreventDefault();
        }
        if (evt.getBubbles()) {
            evt.setEventPhase((short)3);
            for (int i = 0; i < parentList.size(); ++i) {
                currentTarget = (EventTarget)parentList.get(i);
                ServerItsNatNormalEventImpl.dispatchEventLocallyCurrentTarget(currentTarget, evt, false, registries);
                if (!evt.getStopPropagation()) continue;
                return evt.getPreventDefault();
            }
        }
        return evt.getPreventDefault();
    }

    public static void dispatchEventLocallyCurrentTarget(EventTarget currentTarget, ServerItsNatNormalEventImpl evt, boolean useCapture, ItsNatNormalEventListenerRegistryImpl[] registries) {
        evt.setCurrentTarget(currentTarget);
        for (int i = 0; i < registries.length; ++i) {
            if (registries[i] == null) continue;
            ServerItsNatNormalEventImpl.dispatchEventLocallyCurrentTarget(currentTarget, evt, useCapture, registries[i]);
        }
    }

    public static void dispatchEventLocallyCurrentTarget(EventTarget currentTarget, ServerItsNatNormalEventImpl evt, boolean useCapture, ItsNatNormalEventListenerRegistryImpl registry) {
        EventListener[] listeners = registry.getEventListenersArrayCopy(currentTarget, evt.getType(), useCapture);
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            EventListener listener = listeners[i];
            EventListenerUtil.handleEventIncludingGlobalListeners(listener, evt);
        }
    }
}

