/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.event.client.dom.domstd.w3c;

import java.util.HashMap;
import java.util.Map;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CKeyboardEventImpl;

public class W3CKeyboardEventSharedImpl {
    protected Map<String, Integer> keyCodes = new HashMap<String, Integer>();
    protected Map<Integer, String> keyIdentifiers = new HashMap<Integer, String>();

    public void addKeyCodeAndIdentifier(String keyIdentifier, int value) {
        Integer valueObj = new Integer(value);
        this.keyCodes.put(keyIdentifier, valueObj);
        this.keyIdentifiers.put(valueObj, keyIdentifier);
    }

    public String toKeyIdentifier(int keyCode) {
        return this.keyIdentifiers.get(new Integer(keyCode));
    }

    public int toKeyCode(String keyIdentifier) {
        Integer keyCode = this.keyCodes.get(keyIdentifier);
        if (keyCode != null) {
            keyCode.intValue();
        }
        if (!keyIdentifier.startsWith("U+")) {
            return 0;
        }
        keyIdentifier = keyIdentifier.substring(2);
        return Integer.parseInt(keyIdentifier, 16);
    }

    public int keyIdentifierToKeyCode(W3CKeyboardEventImpl event) {
        String keyIdentifier = this.getKeyIdentifier(event);
        return this.toKeyCode(keyIdentifier);
    }

    public int keyIdentifierToCharCode(W3CKeyboardEventImpl event) {
        char charCode = (char)this.keyIdentifierToKeyCode(event);
        if (!event.getShiftKey()) {
            charCode = Character.toLowerCase(charCode);
        }
        return charCode;
    }

    public int getCharCode(W3CKeyboardEventImpl event) {
        if (event.getType().equals("keypress")) {
            int charCode = event.getParameterInt("charCode");
            if (charCode == 0) {
                charCode = this.keyIdentifierToCharCode(event);
            }
            return charCode;
        }
        return 0;
    }

    public int getKeyCode(W3CKeyboardEventImpl event) {
        if (event.getType().equals("keypress")) {
            return 0;
        }
        int keyCode = event.getParameterInt("keyCode");
        if (keyCode == 0) {
            keyCode = this.keyIdentifierToKeyCode(event);
        }
        return keyCode;
    }

    public String getKeyIdentifier(W3CKeyboardEventImpl event) {
        return event.getParameter("keyIdentifier");
    }

    public int getKeyLocation(W3CKeyboardEventImpl event) {
        return event.getParameterInt("keyLocation");
    }

    public boolean getAltKey(W3CKeyboardEventImpl event) {
        return event.getParameterBoolean("altKey");
    }

    public boolean getCtrlKey(W3CKeyboardEventImpl event) {
        return event.getParameterBoolean("ctrlKey");
    }

    public boolean getMetaKey(W3CKeyboardEventImpl event) {
        return event.getParameterBoolean("metaKey");
    }

    public boolean getShiftKey(W3CKeyboardEventImpl event) {
        return event.getParameterBoolean("shiftKey");
    }
}

