/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.event.client.dom.domstd;

import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserAdobeSVG;
import org.itsnat.impl.core.browser.web.BrowserGecko;
import org.itsnat.impl.core.browser.web.opera.BrowserOperaOld;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.event.client.dom.domstd.ClientItsNatDOMStdEventFactory;
import org.itsnat.impl.core.event.client.dom.domstd.ClientItsNatDOMStdEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.GeckoKeyEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.OperaOldKeyEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CEventDefaultImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CHTMLEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CMouseEventImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CMutationEventAdobeSVGImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CMutationEventDefaultImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.W3CUIEventDefaultImpl;
import org.itsnat.impl.core.event.client.dom.domstd.w3c.WebKitKeyEventImpl;
import org.itsnat.impl.core.listener.dom.domstd.ItsNatDOMStdEventListenerWrapperImpl;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;

public class ClientW3CEventFactory
extends ClientItsNatDOMStdEventFactory {
    public ClientW3CEventFactory(RequestNormalEventImpl request) {
        super(request);
    }

    public static ClientW3CEventFactory createW3CEventFactory(RequestNormalEventImpl request) {
        return new ClientW3CEventFactory(request);
    }

    @Override
    public ClientItsNatDOMStdEventImpl createClientItsNatDOMStdEvent(int eventGroupCode, ItsNatDOMStdEventListenerWrapperImpl evtListener) {
        ClientDocumentImpl clientDoc = this.request.getClientDocument();
        Browser browser = clientDoc.getBrowser();
        W3CEventImpl event = null;
        switch (eventGroupCode) {
            case 0: {
                event = new W3CEventDefaultImpl(evtListener, this.request);
                break;
            }
            case 1: {
                event = new W3CUIEventDefaultImpl(evtListener, this.request);
                break;
            }
            case 2: {
                event = new W3CMouseEventImpl(evtListener, this.request);
                break;
            }
            case 3: {
                event = new W3CHTMLEventImpl(evtListener, this.request);
                break;
            }
            case 4: {
                if (browser instanceof BrowserAdobeSVG) {
                    event = new W3CMutationEventAdobeSVGImpl(evtListener, this.request);
                    break;
                }
                event = new W3CMutationEventDefaultImpl(evtListener, this.request);
                break;
            }
            case 5: {
                event = browser instanceof BrowserGecko ? new GeckoKeyEventImpl(evtListener, this.request) : (browser instanceof BrowserWebKit ? new WebKitKeyEventImpl(evtListener, this.request) : (browser instanceof BrowserOperaOld ? new OperaOldKeyEventImpl(evtListener, this.request) : new GeckoKeyEventImpl(evtListener, this.request)));
            }
        }
        return event;
    }
}

