/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.event;

import java.util.HashMap;
import java.util.Map;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.droid.DroidEvent;
import org.itsnat.core.event.droid.DroidFocusEvent;
import org.itsnat.core.event.droid.DroidKeyEvent;
import org.itsnat.core.event.droid.DroidMotionEvent;
import org.itsnat.core.event.droid.DroidTextChangeEvent;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.event.DroidOtherEvent;
import org.itsnat.impl.core.event.client.droid.ClientItsNatDroidEventImpl;
import org.itsnat.impl.core.event.client.droid.ClientItsNatDroidFocusEventImpl;
import org.itsnat.impl.core.event.client.droid.ClientItsNatDroidKeyEventImpl;
import org.itsnat.impl.core.event.client.droid.ClientItsNatDroidMotionEventImpl;
import org.itsnat.impl.core.event.client.droid.ClientItsNatDroidOtherEventImpl;
import org.itsnat.impl.core.event.client.droid.ClientItsNatDroidTextChangeEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidFocusEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidKeyEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidMotionEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidOtherEventImpl;
import org.itsnat.impl.core.event.server.droid.ServerItsNatDroidTextChangeEventImpl;
import org.itsnat.impl.core.listener.droid.ItsNatDroidEventListenerWrapperImpl;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.Event;

public class DroidEventGroupInfo {
    public static final int UNKNOWN_EVENT = 0;
    public static final int MOTION_EVENT = 1;
    public static final int KEY_EVENT = 2;
    public static final int FOCUS_EVENT = 3;
    public static final int TEXT_CHANGE_EVENT = 4;
    public static final int OTHER_EVENT = 5;
    protected static final Map<String, DroidEventGroupInfo> eventGroups = new HashMap<String, DroidEventGroupInfo>();
    protected static final DroidEventGroupInfo eventGroupUnknownDefault = new DroidEventGroupInfo(0);
    protected int eventGroupCode;

    public DroidEventGroupInfo(int eventGroupCode) {
        this.eventGroupCode = eventGroupCode;
    }

    public static DroidEventGroupInfo getEventGroupInfo(String type) {
        DroidEventGroupInfo info = eventGroups.get(type);
        if (info == null) {
            info = eventGroupUnknownDefault;
        }
        return info;
    }

    public static int getEventGroupCode(String type) {
        DroidEventGroupInfo info = eventGroups.get(type);
        if (info == null) {
            return 0;
        }
        return info.getEventGroupCode();
    }

    public int getEventGroupCode() {
        return this.eventGroupCode;
    }

    public static String getEventGroup(Event evt) {
        if (evt instanceof DroidEvent) {
            if (evt instanceof DroidMotionEvent) {
                return "MotionEvent";
            }
            if (evt instanceof DroidKeyEvent) {
                return "KeyEvent";
            }
            if (evt instanceof DroidFocusEvent) {
                return "FocusEvent";
            }
            if (evt instanceof DroidTextChangeEvent) {
                return "TextChangeEvent";
            }
            if (evt instanceof DroidOtherEvent) {
                return "OtherEvent";
            }
        }
        return null;
    }

    public static ClientItsNatDroidEventImpl createClientItsNatDroidEvent(String type, ItsNatDroidEventListenerWrapperImpl listener, RequestNormalEventImpl request) {
        if ("click".equals(type) || "touchstart".equals(type) || "touchend".equals(type) || "touchmove".equals(type) || "touchcancel".equals(type)) {
            return new ClientItsNatDroidMotionEventImpl(listener, request);
        }
        if ("keydown".equals(type) || "keyup".equals(type)) {
            return new ClientItsNatDroidKeyEventImpl(listener, request);
        }
        if ("focus".equals(type) || "blur".equals(type)) {
            return new ClientItsNatDroidFocusEventImpl(listener, request);
        }
        if ("change".equals(type)) {
            return new ClientItsNatDroidTextChangeEventImpl(listener, request);
        }
        if ("load".equals(type) || "unload".equals(type)) {
            return new ClientItsNatDroidOtherEventImpl(listener, request);
        }
        return null;
    }

    public static ServerItsNatDroidEventImpl createServerItsNatDroidEvent(String eventGroup, ItsNatStfulDocumentImpl itsNatDoc) throws DOMException {
        if ("MotionEvent".equals(eventGroup)) {
            return new ServerItsNatDroidMotionEventImpl(itsNatDoc);
        }
        if ("KeyEvent".equals(eventGroup)) {
            return new ServerItsNatDroidKeyEventImpl(itsNatDoc);
        }
        if ("FocusEvent".equals(eventGroup)) {
            return new ServerItsNatDroidFocusEventImpl(itsNatDoc);
        }
        if ("TextChangeEvent".equals(eventGroup)) {
            return new ServerItsNatDroidTextChangeEventImpl(itsNatDoc);
        }
        if ("OtherEvent".equals(eventGroup)) {
            return new ServerItsNatDroidOtherEventImpl(itsNatDoc);
        }
        throw new ItsNatException("Event name " + eventGroup + " is unknown");
    }

    static {
        eventGroups.put("click", new DroidEventGroupInfo(1));
        eventGroups.put("touchstart", new DroidEventGroupInfo(1));
        eventGroups.put("touchend", new DroidEventGroupInfo(1));
        eventGroups.put("touchmove", new DroidEventGroupInfo(1));
        eventGroups.put("touchcancel", new DroidEventGroupInfo(1));
        eventGroups.put("keydown", new DroidEventGroupInfo(2));
        eventGroups.put("keyup", new DroidEventGroupInfo(2));
        eventGroups.put("focus", new DroidEventGroupInfo(3));
        eventGroups.put("blur", new DroidEventGroupInfo(3));
        eventGroups.put("change", new DroidEventGroupInfo(4));
        eventGroups.put("load", new DroidEventGroupInfo(5));
        eventGroups.put("unload", new DroidEventGroupInfo(5));
    }
}

