/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.event;

import java.util.HashMap;
import java.util.Map;

public class DOMStdEventGroupInfo {
    public static final int UNKNOWN_EVENT = 0;
    public static final int UI_EVENT = 1;
    public static final int MOUSE_EVENT = 2;
    public static final int HTML_EVENT = 3;
    public static final int MUTATION_EVENT = 4;
    public static final int KEY_EVENT = 5;
    protected static final Map<String, DOMStdEventGroupInfo> eventGroups = new HashMap<String, DOMStdEventGroupInfo>();
    protected static final DOMStdEventGroupInfo eventGroupUnknownDefault = new DOMStdEventGroupInfo(0, true, true);
    protected int eventGroupCode;
    protected boolean bubbles;
    protected boolean cancelable;

    public DOMStdEventGroupInfo(int eventGroupCode, boolean bubbles, boolean cancelable) {
        this.eventGroupCode = eventGroupCode;
        this.bubbles = bubbles;
        this.cancelable = cancelable;
    }

    public static DOMStdEventGroupInfo getEventGroupInfo(String type) {
        DOMStdEventGroupInfo info = eventGroups.get(type);
        if (info == null) {
            info = eventGroupUnknownDefault;
        }
        return info;
    }

    public static int getEventGroupCode(String type) {
        DOMStdEventGroupInfo info = eventGroups.get(type);
        if (info == null) {
            return 0;
        }
        return info.getEventGroupCode();
    }

    public int getEventGroupCode() {
        return this.eventGroupCode;
    }

    public boolean getBubbles() {
        return this.bubbles;
    }

    public boolean getCancelable() {
        return this.cancelable;
    }

    static {
        eventGroups.put("click", new DOMStdEventGroupInfo(2, true, true));
        eventGroups.put("dblclick", new DOMStdEventGroupInfo(2, true, true));
        eventGroups.put("mousedown", new DOMStdEventGroupInfo(2, true, true));
        eventGroups.put("mouseup", new DOMStdEventGroupInfo(2, true, true));
        eventGroups.put("mouseover", new DOMStdEventGroupInfo(2, true, true));
        eventGroups.put("mousemove", new DOMStdEventGroupInfo(2, true, false));
        eventGroups.put("mouseout", new DOMStdEventGroupInfo(2, true, true));
        eventGroups.put("keypress", new DOMStdEventGroupInfo(5, true, true));
        eventGroups.put("keydown", new DOMStdEventGroupInfo(5, true, true));
        eventGroups.put("keyup", new DOMStdEventGroupInfo(5, true, true));
        eventGroups.put("load", new DOMStdEventGroupInfo(3, false, false));
        eventGroups.put("unload", new DOMStdEventGroupInfo(3, false, false));
        eventGroups.put("abort", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("error", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("resize", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("scroll", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("select", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("change", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("submit", new DOMStdEventGroupInfo(3, true, true));
        eventGroups.put("reset", new DOMStdEventGroupInfo(3, true, false));
        eventGroups.put("focus", new DOMStdEventGroupInfo(3, false, false));
        eventGroups.put("blur", new DOMStdEventGroupInfo(3, false, false));
        eventGroups.put("DOMFocusIn", new DOMStdEventGroupInfo(1, true, false));
        eventGroups.put("DOMFocusOut", new DOMStdEventGroupInfo(1, true, false));
        eventGroups.put("DOMActivate", new DOMStdEventGroupInfo(1, true, true));
        eventGroups.put("DOMSubtreeModified", new DOMStdEventGroupInfo(4, true, false));
        eventGroups.put("DOMNodeInserted", new DOMStdEventGroupInfo(4, true, false));
        eventGroups.put("DOMNodeRemoved", new DOMStdEventGroupInfo(4, true, false));
        eventGroups.put("DOMAttrModified", new DOMStdEventGroupInfo(4, true, false));
        eventGroups.put("DOMCharacterDataModified", new DOMStdEventGroupInfo(4, true, false));
        eventGroups.put("DOMNodeInsertedIntoDocument", new DOMStdEventGroupInfo(4, false, false));
        eventGroups.put("DOMNodeRemovedFromDocument", new DOMStdEventGroupInfo(4, false, false));
        eventGroups.put("beforeunload", new DOMStdEventGroupInfo(3, false, true));
        eventGroups.put("DOMContentLoaded", new DOMStdEventGroupInfo(0, false, false));
    }
}

