/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.event;

import java.io.Serializable;
import java.util.LinkedHashSet;
import org.itsnat.core.event.CodeToSendListener;
import org.itsnat.impl.core.event.CodeToSendEventImpl;

public class CodeToSendListenersImpl
implements Serializable {
    protected LinkedHashSet<CodeToSendListener> codeToSendListener = new LinkedHashSet();
    protected Object target;

    public CodeToSendListenersImpl(Object target) {
        this.target = target;
    }

    public boolean hasCodeToSendListeners() {
        return !this.codeToSendListener.isEmpty();
    }

    private LinkedHashSet<CodeToSendListener> getCodeToSendListeners() {
        return this.codeToSendListener;
    }

    public void addCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendListeners().add(listener);
    }

    public void removeCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendListeners().remove(listener);
    }

    public CodeToSendEventImpl preProcessCodeToSend(Object code) {
        LinkedHashSet<CodeToSendListener> listenerList = this.getCodeToSendListeners();
        CodeToSendEventImpl event = new CodeToSendEventImpl(code, this.target);
        for (CodeToSendListener listener : listenerList) {
            code = listener.preSendCode(event);
            event.setCode(code);
            if (code != null) continue;
            return event;
        }
        return event;
    }

    public void postProcessCodeToSend(CodeToSendEventImpl event) {
        LinkedHashSet<CodeToSendListener> listeners = this.getCodeToSendListeners();
        for (CodeToSendListener listener : listeners) {
            listener.postSendCode(event);
        }
    }
}

