/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.core.ItsNatException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class NamespaceUtil {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String XUL_NAMESPACE = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
    public static final String ITSNAT_NAMESPACE = "http://itsnat.org/itsnat";
    public static final String ANDROID_NAMESPACE = "http://schemas.android.com/apk/res/android";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_XHTML = "application/xhtml+xml";
    public static final String MIME_SVG = "image/svg+xml";
    public static final String MIME_XUL = "application/vnd.mozilla.xul+xml";
    public static final String MIME_XML = "text/xml";
    public static final String MIME_ANDROID_LAYOUT = "android/layout";
    public static final String MIME_JAVASCRIPT = "text/javascript";
    public static final String MIME_BEANSHELL = "text/beanshell";
    public static final int XML = 0;
    public static final int HTML = 1;
    public static final int XHTML = 2;
    public static final int SVG = 3;
    public static final int XUL = 4;
    public static final int ANDROID_LAYOUT = 5;

    public static boolean isXMLNamespace(String namespaceURI) {
        return XML_NAMESPACE.equals(namespaceURI);
    }

    public static boolean isXMLNSNamespace(String namespaceURI) {
        return XMLNS_NAMESPACE.equals(namespaceURI);
    }

    public static boolean isXMLNSDecAttribute(Attr attr) {
        String namespaceURI = attr.getNamespaceURI();
        return NamespaceUtil.isXMLNSNamespace(namespaceURI) && attr.getName().startsWith("xmlns");
    }

    public static boolean isXHTMLNamespace(String namespaceURI) {
        return XHTML_NAMESPACE.equals(namespaceURI);
    }

    public static boolean isSVGNode(Node node) {
        if (node instanceof Element) {
            return NamespaceUtil.isSVGElement((Element)node);
        }
        if (node instanceof CharacterData) {
            return NamespaceUtil.isSVGNode(node.getParentNode());
        }
        if (node instanceof ProcessingInstruction) {
            return NamespaceUtil.isSVGNode(node.getParentNode());
        }
        if (node instanceof Document) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        if (node instanceof Attr) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return false;
    }

    public static boolean isSVGElement(Element elem) {
        return NamespaceUtil.isSVGNamespace(elem.getNamespaceURI());
    }

    public static boolean isSVGNamespace(String namespace) {
        return SVG_NAMESPACE.equals(namespace);
    }

    public static Element getSVGRootElement(Node node) {
        Element rootElem;
        if (!NamespaceUtil.isSVGNode(node)) {
            return null;
        }
        Node parentNode = node.getParentNode();
        if (parentNode == null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        if (parentNode instanceof Element && (rootElem = NamespaceUtil.getSVGRootElement((Element)parentNode)) != null) {
            return rootElem;
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    public static boolean isSVGRootElement(Element elem) {
        Element rootElem = NamespaceUtil.getSVGRootElement(elem);
        return elem == rootElem;
    }

    public static boolean isXULNode(Node node) {
        if (node instanceof Element) {
            return NamespaceUtil.isXULElement((Element)node);
        }
        if (node instanceof CharacterData) {
            return NamespaceUtil.isXULNode(node.getParentNode());
        }
        throw new ItsNatException("INTERNAL ERROR");
    }

    public static boolean isXULElement(Element elem) {
        return NamespaceUtil.isXULNamespace(elem.getNamespaceURI());
    }

    public static boolean isXULNamespace(String namespace) {
        return XUL_NAMESPACE.equals(namespace);
    }

    public static boolean isItsNatNamespace(String namespace) {
        return ITSNAT_NAMESPACE.equals(namespace);
    }

    public static boolean isAndroidNamespace(String namespace) {
        return ANDROID_NAMESPACE.equals(namespace);
    }

    public static boolean isStatefulMime(String mime) {
        return NamespaceUtil.isHTMLorXHTMLMime(mime) || NamespaceUtil.isOtherNSMime(mime) || NamespaceUtil.isAndroidLayoutMime(mime);
    }

    public static boolean isHTMLorXHTMLMime(String mime) {
        return NamespaceUtil.isHTMLMime(mime) || NamespaceUtil.isXHTMLMime(mime);
    }

    public static boolean isOtherNSMime(String mime) {
        return NamespaceUtil.isSVGMime(mime) || NamespaceUtil.isXULMime(mime);
    }

    public static boolean isXHTMLMime(String mime) {
        return mime.equals(MIME_XHTML);
    }

    public static boolean isHTMLMime(String mime) {
        return mime.equals(MIME_HTML);
    }

    public static boolean isSVGMime(String mime) {
        return mime.equals(MIME_SVG);
    }

    public static boolean isXULMime(String mime) {
        return mime.equals(MIME_XUL);
    }

    public static boolean isAndroidLayoutMime(String mime) {
        return mime.equals(MIME_ANDROID_LAYOUT);
    }

    public static boolean isMIME_XHTML(int namespaceOfMIME) {
        return namespaceOfMIME == 2;
    }

    public static boolean isMIME_HTML(int namespaceOfMIME) {
        return namespaceOfMIME == 1;
    }

    public static boolean isMIME_HTML_or_XHTML(int namespaceOfMIME) {
        return NamespaceUtil.isMIME_HTML(namespaceOfMIME) || NamespaceUtil.isMIME_XHTML(namespaceOfMIME);
    }

    public static boolean isMIME_OTHERNS(int namespaceOfMIME) {
        return NamespaceUtil.isMIME_SVG(namespaceOfMIME) || NamespaceUtil.isMIME_XUL(namespaceOfMIME);
    }

    public static boolean isMIME_SVG(int namespaceOfMIME) {
        return namespaceOfMIME == 3;
    }

    public static boolean isMIME_XUL(int namespaceOfMIME) {
        return namespaceOfMIME == 4;
    }

    public static boolean isMIME_XML(int namespaceOfMIME) {
        return namespaceOfMIME == 0;
    }

    public static boolean isMIME_ANDROID_LAYOUT(int namespaceOfMIME) {
        return namespaceOfMIME == 5;
    }

    public static int getNamespaceCode(String mime) {
        if (NamespaceUtil.isHTMLorXHTMLMime(mime)) {
            if (NamespaceUtil.isHTMLMime(mime)) {
                return 1;
            }
            return 2;
        }
        if (NamespaceUtil.isSVGMime(mime)) {
            return 3;
        }
        if (NamespaceUtil.isXULMime(mime)) {
            return 4;
        }
        if (NamespaceUtil.isAndroidLayoutMime(mime)) {
            return 5;
        }
        return 0;
    }

    public static String getNamespace(int namespace) {
        switch (namespace) {
            case 1: {
                return XHTML_NAMESPACE;
            }
            case 2: {
                return XHTML_NAMESPACE;
            }
            case 3: {
                return SVG_NAMESPACE;
            }
            case 4: {
                return XUL_NAMESPACE;
            }
            case 5: {
                return ANDROID_NAMESPACE;
            }
        }
        return null;
    }
}

