/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.core.domutil.ElementListFree;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domutil.ElementGroupManagerImpl;
import org.itsnat.impl.core.domutil.HTMLCollectionAsElementListImpl;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLElementGroupManagerImpl
extends ElementGroupManagerImpl {
    public HTMLElementGroupManagerImpl(ItsNatStfulDocumentImpl itsNatDoc) {
        super(itsNatDoc);
    }

    @Override
    public ElementListFree createElementListFree(Element parentElement, boolean master) {
        if (master) {
            return super.createElementListFree(parentElement, master);
        }
        if (parentElement instanceof HTMLSelectElement) {
            HTMLSelectElement selectElem = (HTMLSelectElement)parentElement;
            return new HTMLCollectionAsElementListImpl(selectElem, selectElem.getOptions(), this.getItsNatDocumentImpl());
        }
        if (parentElement instanceof HTMLTableRowElement) {
            HTMLTableRowElement rowElem = (HTMLTableRowElement)parentElement;
            return new HTMLCollectionAsElementListImpl(rowElem, rowElem.getCells(), this.getItsNatDocumentImpl());
        }
        if (parentElement instanceof HTMLTableSectionElement) {
            HTMLTableSectionElement sectionElem = (HTMLTableSectionElement)parentElement;
            return new HTMLCollectionAsElementListImpl(sectionElem, sectionElem.getRows(), this.getItsNatDocumentImpl());
        }
        return super.createElementListFree(parentElement, false);
    }
}

