/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.ElementListFreeSlaveImpl;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;

public class HTMLCollectionAsElementListImpl
extends ElementListFreeSlaveImpl {
    protected HTMLCollection collection;

    public HTMLCollectionAsElementListImpl(HTMLElement parentElement, HTMLCollection collection, ItsNatDocumentImpl itsNatDoc) {
        super(parentElement, itsNatDoc);
        this.collection = collection;
    }

    @Override
    public int getLength() {
        return this.getHTMLCollection().getLength();
    }

    @Override
    public Element getElementAt(int index) {
        return (Element)this.getHTMLCollection().item(index);
    }

    @Override
    public boolean isEmpty() {
        return this.getHTMLCollection().getLength() == 0;
    }

    @Override
    public Element getFirstElement() {
        return (Element)this.getHTMLCollection().item(0);
    }

    @Override
    public Element getLastElement() {
        return (Element)this.getHTMLCollection().item(this.getLength() - 1);
    }

    @Override
    public int indexOfElement(Element node) {
        return HTMLCollectionAsElementListImpl.indexOfElement(node, this.getHTMLCollection());
    }

    @Override
    public int lastIndexOfElement(Element node) {
        return HTMLCollectionAsElementListImpl.lastIndexOfElement(node, this.getHTMLCollection());
    }

    public static int indexOfElement(Element node, HTMLCollection col) {
        if (node == null) {
            return -1;
        }
        int len = col.getLength();
        for (int i = 0; i < len; ++i) {
            Element child = (Element)col.item(i);
            if (child != node) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfElement(Element node, HTMLCollection col) {
        if (node == null) {
            return -1;
        }
        int len = col.getLength();
        for (int i = len - 1; i >= 0; --i) {
            Element child = (Element)col.item(i);
            if (child != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void fillElements(Element[] elemList) {
        for (int i = 0; i < elemList.length; ++i) {
            Element elem;
            elemList[i] = elem = this.getElementAt(i);
        }
    }

    @Override
    public Element getNextSiblingElement(int index, Element ref) {
        return this.getElementAt(index + 1);
    }

    @Override
    public Element getPreviousSiblingElement(int index, Element ref) {
        return this.getElementAt(index - 1);
    }

    public HTMLCollection getHTMLCollection() {
        return this.collection;
    }
}

