/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.io.Serializable;
import org.itsnat.core.domutil.ElementTreeNode;
import org.itsnat.core.domutil.ElementTreeNodeStructure;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class ElementTreeNodeStructureDefaultImpl
implements ElementTreeNodeStructure,
Serializable {
    public static final ElementTreeNodeStructureDefaultImpl SINGLETON = new ElementTreeNodeStructureDefaultImpl();

    private ElementTreeNodeStructureDefaultImpl() {
    }

    public static ElementTreeNodeStructureDefaultImpl newElementTreeNodeStructureDefault() {
        return SINGLETON;
    }

    public static Element getEffectiveParentElement(Element treeNodeParent) {
        if (treeNodeParent instanceof HTMLTableRowElement) {
            return ItsNatTreeWalker.getFirstChildElement(treeNodeParent);
        }
        return treeNodeParent;
    }

    public static Element getContentElement(boolean treeTable, Element treeNodeParent) {
        treeNodeParent = ElementTreeNodeStructureDefaultImpl.getEffectiveParentElement(treeNodeParent);
        if (!treeTable) {
            return ItsNatTreeWalker.getFirstChildElement(treeNodeParent);
        }
        return treeNodeParent;
    }

    @Override
    public Element getContentElement(ElementTreeNode treeNode, Element nodeParent) {
        return ElementTreeNodeStructureDefaultImpl.getContentElement(treeNode.isTreeTable(), nodeParent);
    }

    public static Element getHandleElement(Element contentParent) {
        if (contentParent instanceof HTMLTableElement) {
            HTMLTableSectionElement tbody = (HTMLTableSectionElement)ItsNatTreeWalker.getFirstChildElement(contentParent);
            HTMLTableRowElement row = (HTMLTableRowElement)ItsNatTreeWalker.getFirstChildElement(tbody);
            return ElementTreeNodeStructureDefaultImpl.getHandleElement(row);
        }
        Element handleElem = ItsNatTreeWalker.getFirstChildElement(contentParent);
        if (handleElem == null) {
            return null;
        }
        Element siblingElem = ItsNatTreeWalker.getNextSiblingElement(handleElem);
        if (siblingElem == null) {
            return null;
        }
        return handleElem;
    }

    public static Element getHandleElement(boolean treeTable, Element treeNodeParent) {
        Element contentParent = ElementTreeNodeStructureDefaultImpl.getContentElement(treeTable, treeNodeParent);
        return ElementTreeNodeStructureDefaultImpl.getHandleElement(contentParent);
    }

    public static Element getIconElement(boolean treeTable, Element treeNodeParent) {
        Element handleElem = ElementTreeNodeStructureDefaultImpl.getHandleElement(treeTable, treeNodeParent);
        if (handleElem != null) {
            return ItsNatTreeWalker.getNextSiblingElement(handleElem);
        }
        return null;
    }

    public static Element getLabelElement(boolean treeTable, Element treeNodeParent) {
        Element iconElem = ElementTreeNodeStructureDefaultImpl.getIconElement(treeTable, treeNodeParent);
        if (iconElem != null) {
            return ItsNatTreeWalker.getNextSiblingElement(iconElem);
        }
        return ElementTreeNodeStructureDefaultImpl.getContentElement(treeTable, treeNodeParent);
    }

    public static Element getChildListElement(boolean treeTable, Element treeNodeParent) {
        if (treeTable) {
            return null;
        }
        Element contentElem = ElementTreeNodeStructureDefaultImpl.getContentElement(treeTable, treeNodeParent);
        Element nextSiblingToContentElem = ItsNatTreeWalker.getNextSiblingElement(contentElem);
        if (nextSiblingToContentElem == null) {
            return null;
        }
        if (nextSiblingToContentElem instanceof HTMLTableElement) {
            return (HTMLTableSectionElement)ItsNatTreeWalker.getFirstChildElement(nextSiblingToContentElem);
        }
        return nextSiblingToContentElem;
    }

    @Override
    public Element getHandleElement(ElementTreeNode treeNode, Element nodeParent) {
        return ElementTreeNodeStructureDefaultImpl.getHandleElement(treeNode.isTreeTable(), nodeParent);
    }

    @Override
    public Element getIconElement(ElementTreeNode treeNode, Element nodeParent) {
        return ElementTreeNodeStructureDefaultImpl.getIconElement(treeNode.isTreeTable(), nodeParent);
    }

    @Override
    public Element getLabelElement(ElementTreeNode treeNode, Element nodeParent) {
        return ElementTreeNodeStructureDefaultImpl.getLabelElement(treeNode.isTreeTable(), nodeParent);
    }

    @Override
    public Element getChildListElement(ElementTreeNode treeNode, Element nodeParent) {
        return ElementTreeNodeStructureDefaultImpl.getChildListElement(treeNode.isTreeTable(), nodeParent);
    }
}

