/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.ArrayList;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementTreeNode;
import org.itsnat.core.domutil.ElementTreeNodeList;
import org.itsnat.core.domutil.ElementTreeNodeRenderer;
import org.itsnat.core.domutil.ElementTreeNodeStructure;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.ElementGroupImpl;
import org.itsnat.impl.core.domutil.ElementTreeNodeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementTreeNodeListImpl
extends ElementGroupImpl
implements ElementTreeNodeList {
    protected ElementTreeNodeStructure structure;
    protected ElementTreeNodeRenderer renderer;
    protected ElementTreeNodeImpl parentTreeNode;
    protected ArrayList<ElementTreeNodeImpl> childTreeNodes;
    protected boolean usePatternMarkupToRender;

    public ElementTreeNodeListImpl(ItsNatDocumentImpl itsNatDoc, ElementTreeNodeImpl parentTreeNode, ElementTreeNodeStructure structure, ElementTreeNodeRenderer renderer) {
        super(itsNatDoc);
        this.parentTreeNode = parentTreeNode;
        if (structure == null) {
            throw new ItsNatException("No tree node structure was registered", (Object)this);
        }
        this.structure = structure;
        this.renderer = renderer;
        this.usePatternMarkupToRender = parentTreeNode != null ? parentTreeNode.isUsePatternMarkupToRender() : itsNatDoc.isUsePatternMarkupToRender();
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    protected ArrayList<ElementTreeNodeImpl> getInternalTreeNodeList() {
        if (this.childTreeNodes == null) {
            this.childTreeNodes = new ArrayList();
        }
        return this.childTreeNodes;
    }

    public ElementTreeNodeImpl getElementTreeNodeParent() {
        return this.parentTreeNode;
    }

    @Override
    public ElementTreeNodeStructure getElementTreeNodeStructure() {
        return this.structure;
    }

    @Override
    public void setElementTreeNodeStructure(ElementTreeNodeStructure structure) {
        this.structure = structure;
    }

    @Override
    public ElementTreeNodeRenderer getElementTreeNodeRenderer() {
        return this.renderer;
    }

    @Override
    public void setElementTreeNodeRenderer(ElementTreeNodeRenderer renderer) {
        this.renderer = renderer;
    }

    public abstract ElementTreeNodeImpl createTreeNode(int var1, Element var2);

    public boolean isOutOfRange(int index) {
        return index < 0 || index >= this.getInternalTreeNodeList().size();
    }

    @Override
    public ElementTreeNode getTreeNodeAt(int index) {
        if (this.isOutOfRange(index)) {
            return null;
        }
        return this.getInternalTreeNodeList().get(index);
    }

    @Override
    public ElementTreeNode getFirstTreeNode() {
        return this.getTreeNodeAt(0);
    }

    @Override
    public ElementTreeNode getLastTreeNode() {
        return this.getTreeNodeAt(this.getLength() - 1);
    }

    protected abstract Element addTreeNodeDOMElementAt();

    @Override
    public ElementTreeNode addTreeNode() {
        Element newNode = this.addTreeNodeDOMElementAt();
        int index = this.getLength();
        ElementTreeNodeImpl treeNode = this.createTreeNode(index, newNode);
        this.getInternalTreeNodeList().add(treeNode);
        this.recalcForwardIndices(index + 1, 1);
        return treeNode;
    }

    @Override
    public ElementTreeNode addTreeNode(Object value) {
        ElementTreeNodeImpl childNode = (ElementTreeNodeImpl)this.addTreeNode();
        childNode.setValue(value, true);
        return childNode;
    }

    protected abstract Element insertTreeNodeDOMElementAt(int var1);

    @Override
    public ElementTreeNode insertTreeNodeAt(int index) {
        Element newNode = this.insertTreeNodeDOMElementAt(index);
        ElementTreeNodeImpl treeNode = this.createTreeNode(index, newNode);
        this.getInternalTreeNodeList().add(index, treeNode);
        this.recalcForwardIndices(index + 1, 1);
        return treeNode;
    }

    @Override
    public ElementTreeNode insertTreeNodeAt(int index, Object value) {
        ElementTreeNodeImpl treeNode = (ElementTreeNodeImpl)this.insertTreeNodeAt(index);
        treeNode.setValue(value, true);
        return treeNode;
    }

    protected abstract Element removeTreeNodeDOMElementAt(int var1);

    public void unrenderTreeNode(int index) {
        ElementTreeNodeListImpl childList;
        ElementTreeNodeImpl treeNode = (ElementTreeNodeImpl)this.getTreeNodeAt(index);
        if (treeNode == null) {
            return;
        }
        ElementTreeNodeRenderer renderer = treeNode.getElementTreeNodeRenderer();
        if (renderer != null) {
            Element labelElem = treeNode.getLabelElement();
            renderer.unrenderTreeNode(treeNode, labelElem);
        }
        if ((childList = treeNode.getElementTreeNodeList()) == null) {
            return;
        }
        int len = childList.getLength();
        for (int i = 0; i < len; ++i) {
            childList.unrenderTreeNode(i);
        }
    }

    @Override
    public ElementTreeNode removeTreeNodeAt(int index) {
        this.unrenderTreeNode(index);
        Element removedElem = this.removeTreeNodeDOMElementAt(index);
        if (removedElem == null) {
            return null;
        }
        ArrayList<ElementTreeNodeImpl> childTreeNodes = this.getInternalTreeNodeList();
        ElementTreeNodeImpl treeNodeRemoved = childTreeNodes.remove(index);
        this.recalcForwardIndices(index, -1);
        return treeNodeRemoved;
    }

    @Override
    public void removeTreeNodeRange(int fromIndex, int toIndex) {
        for (int i = toIndex; i >= fromIndex; --i) {
            this.removeTreeNodeAt(i);
        }
    }

    public void recalcForwardIndices(int fromChildIndex, int count) {
        ArrayList<ElementTreeNodeImpl> childTreeNodes = this.getInternalTreeNodeList();
        int newLen = childTreeNodes.size();
        for (int i = fromChildIndex; i < newLen; ++i) {
            ElementTreeNodeImpl nodeAfter = childTreeNodes.get(i);
            nodeAfter.setIndex(nodeAfter.getIndex() + count);
        }
        ElementTreeNodeImpl nodeAfter = null;
        if (fromChildIndex < newLen) {
            nodeAfter = childTreeNodes.get(fromChildIndex);
        } else {
            ElementTreeNodeImpl thisTreeNode = this.getElementTreeNodeParent();
            if (thisTreeNode != null) {
                nodeAfter = (ElementTreeNodeImpl)thisTreeNode.getNextSiblingTreeNode();
            }
        }
        while (nodeAfter != null) {
            nodeAfter.setRow(-1);
            nodeAfter = (ElementTreeNodeImpl)nodeAfter.getNextTreeNode();
        }
    }

    @Override
    public void removeAllTreeNodes() {
        int len = this.getLength();
        if (len == 0) {
            return;
        }
        this.removeTreeNodeRange(0, len - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalTreeNodeList().isEmpty();
    }

    @Override
    public int getLength() {
        return this.getInternalTreeNodeList().size();
    }

    @Override
    public void setLength(int len) {
        block4: {
            int diff;
            block3: {
                if (len < 0) {
                    throw new ItsNatException("Length can not be negative:" + len, (Object)this);
                }
                int currentSize = this.getLength();
                diff = len - currentSize;
                if (diff <= 0) break block3;
                for (int i = 0; i < diff; ++i) {
                    this.addTreeNode();
                }
                break block4;
            }
            if (diff >= 0) break block4;
            for (int i = currentSize - 1; i >= len; --i) {
                this.removeTreeNodeAt(i);
            }
        }
    }

    @Override
    public ElementTreeNode getElementTreeNodeFromNode(Node node) {
        return this.getElementTreeNodeFromNode(node, this.getTreeContainerElement());
    }

    public ElementTreeNode getElementTreeNodeFromNode(Node node, Element treeContainerElem) {
        Element parentElem = this.getParentElement();
        if (!DOMUtilInternal.isChildOrSame(node, parentElem, treeContainerElem)) {
            return null;
        }
        ArrayList<ElementTreeNodeImpl> childList = this.getInternalTreeNodeList();
        int len = childList.size();
        for (int i = 0; i < len; ++i) {
            ElementTreeNodeImpl childTreeNode = childList.get(i);
            ElementTreeNode result = childTreeNode.getElementTreeNodeFromNode(node, treeContainerElem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ElementTreeNodeImpl getElementTreeNodeFromRow(int row) {
        int[] currRow = ElementTreeNodeImpl.createRowIterator();
        return this.getElementTreeNodeFromRow(row, currRow);
    }

    public ElementTreeNodeImpl getElementTreeNodeFromRow(int row, int[] currRow) {
        ArrayList<ElementTreeNodeImpl> childList = this.getInternalTreeNodeList();
        int size = childList.size();
        for (int i = 0; i < size; ++i) {
            ElementTreeNodeImpl childTreeNode = childList.get(i);
            ElementTreeNodeImpl treeNodeRes = childTreeNode.getElementTreeNodeFromRow(row, currRow);
            if (treeNodeRes == null) continue;
            return treeNodeRes;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        ArrayList<ElementTreeNodeImpl> childList = this.getInternalTreeNodeList();
        int size = childList.size();
        for (int i = 0; i < size; ++i) {
            ElementTreeNodeImpl childTreeNode = childList.get(i);
            count += childTreeNode.getRowCount();
        }
        return count;
    }

    public abstract Element getTreeContainerElement();

    @Override
    public ElementTreeNode[] getTreeNodes() {
        ArrayList<ElementTreeNodeImpl> childList = this.getInternalTreeNodeList();
        return childList.toArray(new ElementTreeNode[childList.size()]);
    }
}

