/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementTreeNode;
import org.itsnat.core.domutil.ElementTreeNodeList;
import org.itsnat.core.domutil.ElementTreeNodeRenderer;
import org.itsnat.core.domutil.ElementTreeNodeStructure;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.ElementGroupImpl;
import org.itsnat.impl.core.domutil.ElementTreeNodeListImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementTreeNodeImpl
extends ElementGroupImpl
implements ElementTreeNode {
    protected final ElementTreeNodeStructure structure;
    protected ElementTreeNodeRenderer renderer;
    protected ElementTreeNodeListImpl parentList;
    protected ElementTreeNodeListImpl childElemList;
    protected Element parentElement;
    protected int index;
    protected int row = -1;
    protected Object auxObject;
    protected boolean usePatternMarkupToRender;
    protected DocumentFragment labelContentPatternFragment;

    public ElementTreeNodeImpl(ItsNatDocumentImpl itsNatDoc, ElementTreeNodeListImpl parentList, int index, Element parentElement, ElementTreeNodeStructure structure, ElementTreeNodeRenderer renderer) {
        super(itsNatDoc);
        this.parentList = parentList;
        this.index = index;
        this.parentElement = parentElement;
        if (structure == null) {
            throw new ItsNatException("No tree node structure was registered", (Object)this);
        }
        this.structure = structure;
        this.renderer = renderer;
        this.usePatternMarkupToRender = parentList != null ? parentList.isUsePatternMarkupToRender() : itsNatDoc.isUsePatternMarkupToRender();
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    public Object getAuxObject() {
        return this.auxObject;
    }

    public void setAuxObject(Object auxObject) {
        this.auxObject = auxObject;
    }

    public ElementTreeNodeListImpl getParentList() {
        return this.parentList;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Element getParentElement() {
        return this.parentElement;
    }

    public Element getTreeContainerElement() {
        if (this.parentList != null) {
            return this.parentList.getTreeContainerElement();
        }
        return this.getParentElement();
    }

    @Override
    public ElementTreeNodeStructure getElementTreeNodeStructure() {
        return this.structure;
    }

    @Override
    public ElementTreeNode getElementTreeNodeParent() {
        if (this.parentList == null) {
            return null;
        }
        return this.parentList.getElementTreeNodeParent();
    }

    @Override
    public ElementTreeNode getPreviousSiblingTreeNode() {
        ElementTreeNodeListImpl parentList = this.getParentList();
        if (parentList == null) {
            return null;
        }
        return parentList.getTreeNodeAt(this.getIndex() - 1);
    }

    @Override
    public ElementTreeNode getPreviousTreeNode() {
        ElementTreeNodeImpl prevSibling = (ElementTreeNodeImpl)this.getPreviousSiblingTreeNode();
        if (prevSibling == null) {
            return this.getElementTreeNodeParent();
        }
        return prevSibling.getDeepMostLastTreeNode();
    }

    public ElementTreeNodeImpl getDeepMostLastTreeNode() {
        ElementTreeNode prevChild;
        ElementTreeNode lastChild = this.getChildTreeNodeList().getLastTreeNode();
        if (lastChild == null) {
            return this;
        }
        do {
            prevChild = lastChild;
        } while ((lastChild = lastChild.getChildTreeNodeList().getLastTreeNode()) != null);
        return (ElementTreeNodeImpl)prevChild;
    }

    @Override
    public ElementTreeNode getNextSiblingTreeNode() {
        ElementTreeNodeListImpl parentList = this.getParentList();
        if (parentList == null) {
            return null;
        }
        return parentList.getTreeNodeAt(this.getIndex() + 1);
    }

    @Override
    public ElementTreeNode getNextTreeNode() {
        ElementTreeNode result = this.getChildTreeNodeList().getFirstTreeNode();
        if (result != null) {
            return result;
        }
        result = this.getNextSiblingTreeNode();
        if (result != null) {
            return result;
        }
        for (ElementTreeNode parent = this.getElementTreeNodeParent(); parent != null; parent = parent.getElementTreeNodeParent()) {
            result = parent.getNextSiblingTreeNode();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static int[] createRowIterator() {
        int[] currRow = new int[]{-1};
        return currRow;
    }

    public ElementTreeNodeImpl getElementTreeNodeFromRow(int row) {
        int[] currRow = ElementTreeNodeImpl.createRowIterator();
        return this.getElementTreeNodeFromRow(row, currRow);
    }

    public ElementTreeNodeImpl getElementTreeNodeFromRow(int row, int[] currRow) {
        currRow[0] = currRow[0] + 1;
        if (row == currRow[0]) {
            return this;
        }
        ElementTreeNodeListImpl childList = (ElementTreeNodeListImpl)this.getChildTreeNodeList();
        return childList.getElementTreeNodeFromRow(row, currRow);
    }

    @Override
    public int getRowCount() {
        int count = 1;
        ElementTreeNodeListImpl childList = (ElementTreeNodeListImpl)this.getChildTreeNodeList();
        return count += childList.getRowCount();
    }

    @Override
    public ElementTreeNodeRenderer getElementTreeNodeRenderer() {
        return this.renderer;
    }

    @Override
    public void setElementTreeNodeRenderer(ElementTreeNodeRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Element getContentElement() {
        return this.getElementTreeNodeStructure().getContentElement(this, this.getParentElement());
    }

    @Override
    public Element getHandleElement() {
        return this.getElementTreeNodeStructure().getHandleElement(this, this.getParentElement());
    }

    @Override
    public Element getIconElement() {
        return this.getElementTreeNodeStructure().getIconElement(this, this.getParentElement());
    }

    @Override
    public Element getLabelElement() {
        return this.getElementTreeNodeStructure().getLabelElement(this, this.getParentElement());
    }

    @Override
    public Element getChildListElement() {
        return this.getElementTreeNodeStructure().getChildListElement(this, this.getParentElement());
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, boolean isNew) {
        Element labelElem = this.getLabelElement();
        this.prepareRendering(labelElem, isNew);
        ElementTreeNodeRenderer renderer = this.getElementTreeNodeRenderer();
        if (renderer != null) {
            renderer.renderTreeNode(this, value, labelElem, isNew);
        }
    }

    public void prepareRendering(Element labelElem, boolean isNew) {
        if (!isNew && this.isUsePatternMarkupToRender()) {
            ElementTreeNodeImpl.restorePatternMarkupWhenRendering(labelElem, this.getLabelContentPatternFragment());
        }
    }

    @Override
    public ElementTreeNode getElementTreeNodeFromNode(Node node) {
        return this.getElementTreeNodeFromNode(node, this.getTreeContainerElement());
    }

    public ElementTreeNode getElementTreeNodeFromNode(Node node, Element treeContainerElem) {
        ElementTreeNodeListImpl childElemList;
        if (this.getParentElement() == node) {
            return this;
        }
        Element contentElem = this.getContentElement();
        if (contentElem != null) {
            if (DOMUtilInternal.isChildOrSame(node, contentElem, treeContainerElem)) {
                return this;
            }
        } else {
            Element handleElem = this.getHandleElement();
            if (handleElem != null && DOMUtilInternal.isChildOrSame(node, handleElem, treeContainerElem)) {
                return this;
            }
            Element iconElem = this.getIconElement();
            if (iconElem != null && DOMUtilInternal.isChildOrSame(node, iconElem, treeContainerElem)) {
                return this;
            }
            Element labelElem = this.getIconElement();
            if (labelElem != null && DOMUtilInternal.isChildOrSame(node, labelElem, treeContainerElem)) {
                return this;
            }
        }
        if ((childElemList = this.getElementTreeNodeList()) != null) {
            return childElemList.getElementTreeNodeFromNode(node, treeContainerElem);
        }
        return null;
    }

    public static String toString(int[] path) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (i > 0) {
                res.append(",");
            }
            res.append(path[i]);
        }
        return res.toString();
    }

    public ElementTreeNode getElementTreeNodeFromPath(int[] path) {
        return this.getElementTreeNodeFromPath(path, 0);
    }

    public ElementTreeNode getElementTreeNodeFromPath(int[] path, int fromIndex) {
        if (fromIndex == path.length) {
            return this;
        }
        int childIndex = path[fromIndex];
        if (childIndex == -1) {
            return null;
        }
        ElementTreeNodeImpl childNode = (ElementTreeNodeImpl)this.getChildTreeNodeList().getTreeNodeAt(childIndex);
        if (childNode == null) {
            throw new ItsNatException("Tree node not found: " + ElementTreeNodeImpl.toString(path), (Object)this);
        }
        return childNode.getElementTreeNodeFromPath(path, fromIndex + 1);
    }

    @Override
    public ElementTreeNodeList getChildTreeNodeList() {
        return this.getElementTreeNodeList();
    }

    public abstract ElementTreeNodeListImpl getElementTreeNodeList();

    @Override
    public int getRow() {
        if (this.row != -1) {
            return this.row;
        }
        ElementTreeNode prevTreeNode = this.getPreviousTreeNode();
        this.row = prevTreeNode == null ? 0 : prevTreeNode.getRow() + 1;
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int getDeepLevel() {
        ElementTreeNode parentNode = this.getElementTreeNodeParent();
        if (parentNode == null) {
            return 0;
        }
        return parentNode.getDeepLevel() + 1;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildTreeNodeList().isEmpty();
    }

    @Override
    public DocumentFragment getLabelContentPatternFragment() {
        if (this.labelContentPatternFragment == null) {
            Element labelElem;
            ElementTreeNodeListImpl parentList = this.getParentList();
            if (parentList == null) {
                labelElem = this.structure.getLabelElement(this, this.getParentElement());
            } else {
                Element treeNodePattern = parentList.getChildPatternElement();
                ElementTreeNodeStructure structure = this.getElementTreeNodeStructure();
                labelElem = structure.getLabelElement(this, treeNodePattern);
            }
            if (labelElem != null) {
                Element clonedLabelElem = (Element)labelElem.cloneNode(true);
                this.labelContentPatternFragment = DOMUtilInternal.extractChildrenToDocFragment(clonedLabelElem);
            }
        }
        return this.labelContentPatternFragment;
    }
}

