/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.io.Serializable;
import org.itsnat.core.ItsNatDocument;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementTree;
import org.itsnat.core.domutil.ElementTreeNode;
import org.itsnat.core.domutil.ElementTreeNodeRenderer;
import org.itsnat.core.domutil.ElementTreeNodeStructure;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.ElementGroupManagerImpl;
import org.itsnat.impl.core.domutil.ElementTreeNodeImpl;
import org.itsnat.impl.core.domutil.ElementTreeNodeListImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementTreeImpl
implements ElementTree,
Serializable {
    protected ElementTreeNodeListImpl rootContainerList;
    protected boolean usePatternMarkupToRender;

    public ElementTreeImpl(ItsNatDocumentImpl itsNatDoc, boolean treeTable, Element parentElement, boolean removePattern, ElementTreeNodeStructure structure, ElementTreeNodeRenderer renderer) {
        ElementGroupManagerImpl factory = itsNatDoc.getElementGroupManagerImpl();
        this.rootContainerList = factory.createElementTreeNodeListInternal(treeTable, parentElement, removePattern, structure, renderer);
        if (!removePattern && this.rootContainerList.getLength() > 1) {
            throw new ItsNatException("A tree only can have a root node", (Object)this);
        }
        this.usePatternMarkupToRender = itsNatDoc.isUsePatternMarkupToRender();
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    public Element getTreeContainerElement() {
        return this.rootContainerList.getTreeContainerElement();
    }

    @Override
    public ItsNatDocument getItsNatDocument() {
        return this.rootContainerList.getItsNatDocument();
    }

    @Override
    public Element getParentElement() {
        return this.rootContainerList.getParentElement();
    }

    @Override
    public int getRowCount() {
        return this.rootContainerList.getRowCount();
    }

    @Override
    public boolean hasTreeNodeRoot() {
        return !this.rootContainerList.isEmpty();
    }

    @Override
    public ElementTreeNode getRootNode() {
        if (this.hasTreeNodeRoot()) {
            return this.rootContainerList.getFirstTreeNode();
        }
        return null;
    }

    @Override
    public ElementTreeNode addRootNode() {
        if (this.hasTreeNodeRoot()) {
            throw new ItsNatException("Already has a root node", (Object)this);
        }
        return this.rootContainerList.addTreeNode();
    }

    @Override
    public ElementTreeNode addRootNode(Object value) {
        if (this.hasTreeNodeRoot()) {
            throw new ItsNatException("Already has a root node", (Object)this);
        }
        return this.rootContainerList.addTreeNode(value);
    }

    @Override
    public void removeRootNode() {
        if (!this.hasTreeNodeRoot()) {
            return;
        }
        this.rootContainerList.removeAllTreeNodes();
    }

    @Override
    public Element getRootPatternElement() {
        return this.rootContainerList.getChildPatternElement();
    }

    @Override
    public ElementTreeNode getElementTreeNodeFromNode(Node node) {
        return this.getElementTreeNodeFromNode(node, this.getTreeContainerElement());
    }

    public ElementTreeNode getElementTreeNodeFromNode(Node node, Element treeContainerElem) {
        ElementTreeNodeImpl rootNode = (ElementTreeNodeImpl)this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        return rootNode.getElementTreeNodeFromNode(node, treeContainerElem);
    }

    public ElementTreeNode getElementTreeNodeFromPath(int[] path) {
        ElementTreeNodeImpl rootNode = (ElementTreeNodeImpl)this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        return rootNode.getElementTreeNodeFromPath(path);
    }

    public ElementTreeNode getElementTreeNodeFromPath(int[] path, int fromIndex) {
        ElementTreeNodeImpl rootNode = (ElementTreeNodeImpl)this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        return rootNode.getElementTreeNodeFromPath(path, fromIndex);
    }

    @Override
    public ElementTreeNode getElementTreeNodeFromRow(int row) {
        ElementTreeNodeImpl rootNode = (ElementTreeNodeImpl)this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        if (row == 0) {
            return rootNode;
        }
        return rootNode.getElementTreeNodeFromRow(row);
    }

    @Override
    public ElementTreeNodeRenderer getElementTreeNodeRenderer() {
        return this.rootContainerList.getElementTreeNodeRenderer();
    }

    @Override
    public void setElementTreeNodeRenderer(ElementTreeNodeRenderer renderer) {
        this.rootContainerList.setElementTreeNodeRenderer(renderer);
    }

    @Override
    public ElementTreeNodeStructure getElementTreeNodeStructure() {
        return this.rootContainerList.getElementTreeNodeStructure();
    }

    @Override
    public void setElementTreeNodeStructure(ElementTreeNodeStructure structure) {
        this.rootContainerList.setElementTreeNodeStructure(structure);
    }

    @Override
    public boolean containsUserValueName(String name) {
        return this.rootContainerList.containsUserValueName(name);
    }

    @Override
    public Object removeUserValue(String name) {
        return this.rootContainerList.removeUserValue(name);
    }

    @Override
    public Object getUserValue(String name) {
        return this.rootContainerList.getUserValue(name);
    }

    @Override
    public Object setUserValue(String name, Object value) {
        return this.rootContainerList.setUserValue(name, value);
    }

    @Override
    public String[] getUserValueNames() {
        return this.rootContainerList.getUserValueNames();
    }
}

