/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.ArrayList;
import java.util.List;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementTable;
import org.itsnat.core.domutil.ElementTableRenderer;
import org.itsnat.core.domutil.ElementTableStructure;
import org.itsnat.core.domutil.ListElementInfo;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.ElementGroupManagerImpl;
import org.itsnat.impl.core.domutil.ElementListBaseImpl;
import org.itsnat.impl.core.domutil.ElementListFreeImpl;
import org.itsnat.impl.core.domutil.ElementListImpl;
import org.itsnat.impl.core.domutil.ElementTableBaseImpl;
import org.itsnat.impl.core.domutil.ListElementInfoMasterImpl;
import org.itsnat.impl.core.domutil.TableCellElementInfoImpl;
import org.itsnat.impl.core.domutil.TableCellElementInfoMasterImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class ElementTableImpl
extends ElementTableBaseImpl
implements ElementTable {
    protected ElementTableRenderer renderer;
    protected ElementTableStructure structure;
    protected ElementListImpl columnListPattern;
    protected DocumentFragment cellContentPatternFragment;
    protected boolean usePatternMarkupToRender;

    public ElementTableImpl(ItsNatDocumentImpl itsNatDoc, Element parentElement, boolean removePattern, ElementTableStructure structure, ElementTableRenderer renderer) {
        super(itsNatDoc, parentElement);
        this.structure = structure;
        this.renderer = renderer;
        this.usePatternMarkupToRender = itsNatDoc.isUsePatternMarkupToRender();
        this.columnListOfRow = new ArrayList();
        ElementGroupManagerImpl factory = this.getItsNatDocumentImpl().getElementGroupManagerImpl();
        this.rows = factory.createElementListNoRenderInternal(parentElement, null, !removePattern, false);
        Element rowContentParentPattern = structure.getRowContentElement(this, 0, this.getRowPatternElement());
        this.columnListPattern = factory.createElementListNoRenderInternal(rowContentParentPattern, null, !removePattern, false);
        if (removePattern) {
            this.rows.removeAllElements();
        } else {
            this.createAndSyncColumnArrayList();
        }
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    @Override
    public ElementListFreeImpl getRowsAsElementListFree() {
        return this.getRowElementList().getInternalElementListFree();
    }

    public ElementListImpl getRowElementList() {
        return (ElementListImpl)this.rows;
    }

    @Override
    public ElementTableRenderer getElementTableRenderer() {
        return this.renderer;
    }

    @Override
    public void setElementTableRenderer(ElementTableRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public ElementTableStructure getElementTableStructure() {
        return this.structure;
    }

    @Override
    public void setElementTableStructure(ElementTableStructure structure) {
        this.structure = structure;
    }

    @Override
    public Element getRowPatternElement() {
        return this.getRowElementList().getChildPatternElement();
    }

    @Override
    public Element getCellPatternElement() {
        return this.columnListPattern.getChildPatternElement();
    }

    @Override
    public DocumentFragment getCellContentPatternFragment() {
        Element cellPatternContentElem;
        if (this.cellContentPatternFragment == null && (cellPatternContentElem = this.structure.getCellContentElement(this, 0, 0, this.getCellPatternElement())) != null) {
            Element clonedItemContentElem = (Element)cellPatternContentElem.cloneNode(true);
            this.cellContentPatternFragment = DOMUtilInternal.extractChildrenToDocFragment(clonedItemContentElem);
        }
        return this.cellContentPatternFragment;
    }

    protected void setRowContent(int row, Element rowElem, Object[] rowData, boolean isNew) {
        if (rowData != null && rowData.length > 0) {
            ElementListImpl columns = (ElementListImpl)this.getColumnsOfRowElementList(row, rowElem);
            int col = 0;
            for (Element columElem : columns.getInternalElementListFree()) {
                Object value = rowData[col];
                this.setCellValueAt(row, col, value, columElem, isNew);
                ++col;
            }
        }
    }

    @Override
    public Element addRow() {
        return this.addRow((Object[])null);
    }

    @Override
    public Element addRow(List<Object> rowData) {
        return this.addRow(ElementTableImpl.toObjectArray(rowData));
    }

    @Override
    public Element addRow(Object[] rowData) {
        int row = this.rows.getLength();
        Element rowElem = this.getRowElementList().addElement();
        this.insertColumnListOfRow(row, rowElem);
        this.setRowContent(row, rowElem, rowData, true);
        return rowElem;
    }

    @Override
    public Element insertRowAt(int row) {
        return this.insertRowAt(row, (Object[])null);
    }

    @Override
    public Element insertRowAt(int row, List<Object> rowData) {
        return this.insertRowAt(row, ElementTableImpl.toObjectArray(rowData));
    }

    @Override
    public Element insertRowAt(int row, Object[] rowData) {
        Element rowElem = this.getRowElementList().insertElementAt(row);
        if (rowElem == null) {
            return null;
        }
        this.insertColumnListOfRow(row, rowElem);
        this.setRowContent(row, rowElem, rowData, true);
        return rowElem;
    }

    @Override
    public void setRowValuesAt(int row, List<Object> rowData) {
        this.setRowValuesAt(row, ElementTableImpl.toObjectArray(rowData));
    }

    @Override
    public void setRowValuesAt(int row, Object[] rowData) {
        Element rowElem = this.getRowElementAt(row);
        this.setRowContent(row, rowElem, rowData, false);
    }

    @Override
    public ElementListBaseImpl getColumnsOfRowElementList(int row, Element rowElem) {
        return (ElementListImpl)this.columnListOfRow.get(row);
    }

    @Override
    public ElementListBaseImpl newColumnsOfRowElementList(int row, Element rowElem) {
        Element rowContentElem = this.getRowContentElementAt(row, rowElem);
        Element cellPattern = this.getCellPatternElement();
        DocumentFragment cellContentPattern = this.getCellContentPatternFragment();
        ElementGroupManagerImpl factory = this.getItsNatDocumentImpl().getElementGroupManagerImpl();
        return factory.createElementListInternal(true, rowContentElem, cellPattern, false, cellContentPattern, false, null, null);
    }

    public Element[] addOrInsertColumn(int column, Object[] columnData, boolean add) {
        if (add) {
            this.columnListPattern.addElement();
        } else {
            this.columnListPattern.insertElementAt(column);
        }
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return new Element[0];
        }
        Element[] newCells = new Element[rows.getLength()];
        int row = 0;
        for (Element rowElem : rows) {
            ElementListImpl columns = (ElementListImpl)this.getColumnsOfRowElementList(row, rowElem);
            Element columnElem = null;
            columnElem = add ? columns.addElement() : columns.insertElementAt(column);
            newCells[row] = columnElem;
            if (columnData != null) {
                this.setCellValueAt(row, column, columnData[row], columnElem, true);
            }
            ++row;
        }
        return newCells;
    }

    @Override
    public Element[] addColumn() {
        return this.addColumn((Object[])null);
    }

    @Override
    public Element[] addColumn(List<Object> columnData) {
        return this.addColumn(ElementTableImpl.toObjectArray(columnData));
    }

    @Override
    public Element[] addColumn(Object[] columnData) {
        int column = this.getColumnCount();
        return this.addOrInsertColumn(column, columnData, true);
    }

    @Override
    public Element[] insertColumnAt(int column) {
        return this.insertColumnAt(column, (Object[])null);
    }

    @Override
    public Element[] insertColumnAt(int column, List<Object> columnData) {
        return this.insertColumnAt(column, ElementTableImpl.toObjectArray(columnData));
    }

    @Override
    public Element[] insertColumnAt(int column, Object[] columnData) {
        return this.addOrInsertColumn(column, columnData, false);
    }

    @Override
    public void setColumnValuesAt(int column, List<Object> columnData) {
        this.setColumnValuesAt(column, ElementTableImpl.toObjectArray(columnData));
    }

    @Override
    public void setColumnValuesAt(int column, Object[] columnData) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return;
        }
        int row = 0;
        for (Element rowElem : rows) {
            ElementListImpl columns = (ElementListImpl)this.getColumnsOfRowElementList(row, rowElem);
            Element columnElem = columns.getElementAt(column);
            this.setCellValueAt(row, column, columnData[row], columnElem, false);
            ++row;
        }
    }

    @Override
    public void removeColumnAt(int column) {
        ElementTableRenderer renderer = this.getElementTableRenderer();
        if (renderer != null) {
            int rowCount = this.getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                this.unrenderCell(row, column);
            }
        }
        this.columnListPattern.removeElementAt(column);
        super.removeColumnAt(column);
    }

    @Override
    public void removeAllColumns() {
        this.unrenderAllCells();
        this.columnListPattern.removeAllElements();
        super.removeAllColumns();
    }

    @Override
    public int getColumnCount() {
        return this.columnListPattern.getLength();
    }

    @Override
    public Element getCellContentElementAt(int row, int column) {
        Element cellElem = this.getCellElementAt(row, column);
        if (cellElem == null) {
            return null;
        }
        return this.getCellContentElementAt(row, column, cellElem);
    }

    public Element getCellContentElementAt(int row, int column, Element cellElem) {
        return this.getElementTableStructure().getCellContentElement(this, row, column, cellElem);
    }

    @Override
    public Element getRowContentElementAt(int row) {
        Element rowElem = this.getRowElementAt(row);
        if (rowElem == null) {
            return null;
        }
        return this.getRowContentElementAt(row, rowElem);
    }

    public Element getRowContentElementAt(int row, Element rowElem) {
        return this.getElementTableStructure().getRowContentElement(this, row, rowElem);
    }

    @Override
    public void setCellValueAt(int row, int column, Object value) {
        Element cellElem = this.getCellElementAt(row, column);
        if (cellElem == null) {
            throw new ItsNatException("Out of range", (Object)this);
        }
        this.setCellValueAt(row, column, value, cellElem, false);
    }

    public void setCellValueAt(int row, int column, Object value, Element cellElem, boolean isNew) {
        Element cellContentElem = this.getCellContentElementAt(row, column, cellElem);
        this.prepareRendering(cellContentElem, isNew);
        ElementTableRenderer renderer = this.getElementTableRenderer();
        if (renderer != null) {
            renderer.renderTable(this, row, column, value, cellContentElem, isNew);
        }
    }

    public void prepareRendering(Element cellContentElem, boolean isNew) {
        if (!isNew && this.isUsePatternMarkupToRender()) {
            ElementTableImpl.restorePatternMarkupWhenRendering(cellContentElem, this.getCellContentPatternFragment());
        }
    }

    @Override
    public Element removeRowAt(int row) {
        ElementTableRenderer renderer = this.getElementTableRenderer();
        if (renderer != null) {
            int columnCount = this.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                this.unrenderCell(row, col);
            }
        }
        return super.removeRowAt(row);
    }

    @Override
    public void removeRowRange(int fromIndex, int toIndex) {
        ElementTableRenderer renderer = this.getElementTableRenderer();
        if (renderer != null) {
            int columnCount = this.getColumnCount();
            for (int row = fromIndex; row <= toIndex; ++row) {
                for (int col = 0; col < columnCount; ++col) {
                    this.unrenderCell(row, col);
                }
            }
        }
        super.removeRowRange(fromIndex, toIndex);
    }

    @Override
    public void removeAllRows() {
        this.unrenderAllCells();
        super.removeAllRows();
    }

    public void unrenderCell(int row, int column) {
        ElementTableRenderer renderer = this.getElementTableRenderer();
        if (renderer == null) {
            return;
        }
        Element cellElem = this.getCellElementAt(row, column);
        if (cellElem == null) {
            return;
        }
        Element cellContentElem = this.getCellContentElementAt(row, column, cellElem);
        renderer.unrenderTable(this, row, column, cellContentElem);
    }

    public void unrenderAllCells() {
        ElementTableRenderer renderer = this.getElementTableRenderer();
        if (renderer == null) {
            return;
        }
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                this.unrenderCell(row, col);
            }
        }
    }

    @Override
    public void setRowCount(int rowCount) {
        block4: {
            int diff;
            block3: {
                if (rowCount < 0) {
                    throw new ItsNatException("Negative row count: " + rowCount, (Object)this);
                }
                int currentRowCount = this.getRowCount();
                diff = rowCount - currentRowCount;
                if (diff <= 0) break block3;
                for (int i = 0; i < diff; ++i) {
                    this.addRow();
                }
                break block4;
            }
            if (diff >= 0) break block4;
            for (int i = currentRowCount - 1; i >= rowCount; --i) {
                this.removeRowAt(i);
            }
        }
    }

    @Override
    public void setColumnCount(int columnCount) {
        block4: {
            int diff;
            block3: {
                if (columnCount < 0) {
                    throw new ItsNatException("Negative column count: " + columnCount, (Object)this);
                }
                int currentColumnCount = this.getColumnCount();
                diff = columnCount - currentColumnCount;
                if (diff <= 0) break block3;
                for (int i = 0; i < diff; ++i) {
                    this.addColumn();
                }
                break block4;
            }
            if (diff >= 0) break block4;
            for (int i = currentColumnCount - 1; i >= columnCount; --i) {
                this.removeColumnAt(i);
            }
        }
    }

    @Override
    public void setTableValues(List<List<Object>> values) {
        for (int i = 0; i < values.size(); ++i) {
            List<Object> rowValues = values.get(i);
            for (int j = 0; j < rowValues.size(); ++j) {
                Object cellValue = rowValues.get(j);
                this.setCellValueAt(i, j, cellValue);
            }
        }
    }

    @Override
    public void setTableValues(Object[][] values) {
        for (int i = 0; i < values.length; ++i) {
            Object[] rowValues = values[i];
            for (int j = 0; j < rowValues.length; ++j) {
                Object cellValue = rowValues[j];
                this.setCellValueAt(i, j, cellValue);
            }
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex == newIndex) {
            return;
        }
        this.columnListPattern.moveElement(columnIndex, columnIndex, newIndex);
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return;
        }
        int row = 0;
        for (Element rowElem : rows) {
            ElementListImpl columns = (ElementListImpl)this.getColumnsOfRowElementList(row, rowElem);
            columns.moveElement(columnIndex, columnIndex, newIndex);
            ++row;
        }
    }

    @Override
    public TableCellElementInfoImpl getTableCellElementInfo(ListElementInfo rowInfo, ListElementInfo cellInfo) {
        return TableCellElementInfoMasterImpl.getTableCellElementInfoMaster((ListElementInfoMasterImpl)rowInfo, (ListElementInfoMasterImpl)cellInfo, this);
    }

    public static Object[] toObjectArray(List<Object> data) {
        if (data == null) {
            return null;
        }
        Object[] dataArray = new Object[data.size()];
        dataArray = data.toArray(dataArray);
        return dataArray;
    }
}

