/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementListFree;
import org.itsnat.core.domutil.ElementTableFree;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.ElementListBaseImpl;
import org.itsnat.impl.core.domutil.ElementListFreeImpl;
import org.itsnat.impl.core.domutil.ElementListFreeInternal;
import org.itsnat.impl.core.domutil.ElementListFreeUtil;
import org.itsnat.impl.core.domutil.ElementPair;
import org.itsnat.impl.core.domutil.ElementTableBaseImpl;
import org.w3c.dom.Element;

public abstract class ElementTableFreeImpl
extends ElementTableBaseImpl
implements ElementTableFree,
ElementListFreeInternal {
    public ElementTableFreeImpl(ItsNatDocumentImpl itsNatDoc, boolean master, Element parentElement) {
        super(itsNatDoc, parentElement);
        this.rows = (ElementListFreeImpl)itsNatDoc.getElementGroupManagerImpl().createElementListFree(parentElement, master);
    }

    @Override
    public ElementListFreeImpl getRowsAsElementListFree() {
        return (ElementListFreeImpl)this.rows;
    }

    public ElementListFreeImpl getRows() {
        return (ElementListFreeImpl)this.rows;
    }

    @Override
    public void addRow(Element rowElem) {
        this.addRow2(rowElem);
    }

    public Element addRow2(Element rowElem) {
        rowElem = this.getRowsAsElementListFree().addElement2(rowElem);
        return rowElem;
    }

    @Override
    public void insertRowAt(int row, Element rowElem) {
        this.insertRowAt2(row, rowElem);
    }

    public Element insertRowAt2(int row, Element rowElem) {
        rowElem = this.getRowsAsElementListFree().insertElementAt2(row, rowElem);
        return rowElem;
    }

    @Override
    public Element setRowAt(int row, Element rowElem) {
        return this.setRowAt2(row, rowElem).getOldElem();
    }

    public ElementPair setRowAt2(int row, Element rowElem) {
        ElementPair res = this.getRowsAsElementListFree().setElementAt2(row, rowElem);
        return res;
    }

    @Override
    public Element[] setCellElementsOfRow(int row, Element[] cells) {
        Element rowElem = this.getRowElementAt(row);
        if (rowElem == null) {
            throw new ItsNatException("Row is out of range: " + row, (Object)this);
        }
        ElementListFreeImpl columns = (ElementListFreeImpl)this.getColumnsOfRowElementList(row, rowElem);
        return columns.setElements(cells);
    }

    @Override
    public ElementListBaseImpl newColumnsOfRowElementList(int row, Element rowElem) {
        return (ElementListFreeImpl)this.getItsNatDocumentImpl().getElementGroupManagerImpl().createElementListFree(rowElem, this.isMaster());
    }

    @Override
    public void addColumn(Element[] cells) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return;
        }
        int row = 0;
        for (Element rowElem : rows) {
            ElementListFreeImpl columns = (ElementListFreeImpl)this.getColumnsOfRowElementList(row, rowElem);
            cells[row] = columns.addElement2(cells[row]);
            ++row;
        }
    }

    @Override
    public void insertColumnAt(int column, Element[] cells) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return;
        }
        int row = 0;
        for (Element rowElem : rows) {
            ElementListFreeImpl columns = (ElementListFreeImpl)this.getColumnsOfRowElementList(row, rowElem);
            cells[row] = columns.insertElementAt2(column, cells[row]);
            ++row;
        }
    }

    @Override
    public Element[] setCellElementsOfColumn(int column, Element[] cells) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return new Element[0];
        }
        Element[] replaced = new Element[cells.length];
        int row = 0;
        for (Element rowElem : rows) {
            ElementListFreeImpl columns = (ElementListFreeImpl)this.getColumnsOfRowElementList(row, rowElem);
            ElementPair res = columns.setElementAt2(column, cells[row]);
            cells[row] = res.getNewElem();
            replaced[row] = res.getOldElem();
            ++row;
        }
        return replaced;
    }

    @Override
    public Element setCellElementAt(int row, int column, Element elem) {
        Element rowElem = this.getRowElementAt(row);
        if (rowElem == null) {
            throw new ItsNatException("Row is out of range: " + row, (Object)this);
        }
        ElementListFreeImpl columns = (ElementListFreeImpl)this.getColumnsOfRowElementList(row, rowElem);
        ElementPair res = columns.setElementAt2(column, elem);
        return res.getOldElem();
    }

    @Override
    public ElementListFree getCellElementListOfRow(int row) {
        Element rowElem = this.getRowElementAt(row);
        if (rowElem == null) {
            throw new ItsNatException("Row is out of range: " + row, (Object)this);
        }
        ElementListFreeImpl columns = (ElementListFreeImpl)this.getColumnsOfRowElementList(row, rowElem);
        return columns;
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex == newIndex) {
            return;
        }
        Element[] elements = this.getCellElementsOfColumn(columnIndex);
        this.removeColumnAt(columnIndex);
        this.insertColumnAt(newIndex, elements);
    }

    @Override
    public int indexOf(Object o) {
        return ElementListFreeUtil.indexOf(this, o);
    }

    @Override
    public boolean contains(Object o) {
        return ElementListFreeUtil.contains(this, o);
    }

    @Override
    public boolean add(Element o) {
        return ElementListFreeUtil.add(this, o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ElementListFreeUtil.lastIndexOf(this, o);
    }

    @Override
    public boolean remove(Object o) {
        return ElementListFreeUtil.remove((ElementListFreeInternal)this, o);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ElementListFreeUtil.toArray(this, a);
    }

    @Override
    public Element get(int index) {
        return ElementListFreeUtil.get(this, index);
    }

    @Override
    public Iterator<Element> iterator() {
        return ElementListFreeUtil.iterator(this);
    }

    @Override
    public ListIterator<Element> listIterator(int index) {
        return ElementListFreeUtil.listIterator(this, index);
    }

    @Override
    public ListIterator<Element> listIterator() {
        return ElementListFreeUtil.listIterator(this);
    }

    @Override
    public Element remove(int index) {
        return ElementListFreeUtil.remove((ElementListFreeInternal)this, index);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Element> c) {
        return ElementListFreeUtil.addAll(this, index, c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ElementListFreeUtil.containsAll(this, c);
    }

    @Override
    public boolean addAll(Collection<? extends Element> c) {
        return ElementListFreeUtil.addAll(this, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ElementListFreeUtil.removeAll(this, c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ElementListFreeUtil.retainAll(this, c);
    }

    @Override
    public void add(int index, Element element) {
        ElementListFreeUtil.add(this, index, element);
    }

    @Override
    public Element set(int index, Element element) {
        return ElementListFreeUtil.set(this, index, element);
    }

    public Element[] toArray() {
        return ElementListFreeUtil.toArray(this);
    }

    @Override
    public List<Element> subList(int fromIndex, int toIndex) {
        return ElementListFreeUtil.subList(this, fromIndex, toIndex);
    }

    @Override
    public int size() {
        return ElementListFreeUtil.size(this);
    }

    @Override
    public void clear() {
        ElementListFreeUtil.clear(this);
    }

    @Override
    public void removeElement(int index, Element node) {
        this.removeRowAt(index);
    }

    @Override
    public Element insertBeforeElement(int index, Element newNode, Element refNode) {
        return this.insertElementAt2(index, newNode);
    }

    @Override
    public Element getPreviousSiblingElement(int index, Element ref) {
        return this.getRowsAsElementListFree().getPreviousSiblingElement(index, ref);
    }

    @Override
    public Element getNextSiblingElement(int index, Element ref) {
        return this.getRowsAsElementListFree().getNextSiblingElement(index, ref);
    }

    @Override
    public void addElement(Element elem) {
        this.addRow(elem);
    }

    @Override
    public Element addElement2(Element elem) {
        return this.addRow2(elem);
    }

    @Override
    public Element setElementAt(int index, Element elem) {
        return this.setRowAt(index, elem);
    }

    @Override
    public ElementPair setElementAt2(int index, Element elem) {
        return this.setRowAt2(index, elem);
    }

    @Override
    public void insertElementAt(int index, Element elem) {
        this.insertRowAt(index, elem);
    }

    @Override
    public Element insertElementAt2(int index, Element elem) {
        return this.insertRowAt2(index, elem);
    }

    @Override
    public boolean isMaster() {
        return this.getRowsAsElementListFree().isMaster();
    }

    @Override
    public Element[] setElements(Element[] newElems) {
        return this.getRowsAsElementListFree().setElements(newElems);
    }
}

