/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.ArrayList;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementTableBase;
import org.itsnat.core.domutil.ListElementInfo;
import org.itsnat.core.domutil.TableCellElementInfo;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.ElementGroupImpl;
import org.itsnat.impl.core.domutil.ElementListBaseImpl;
import org.itsnat.impl.core.domutil.ElementListFreeImpl;
import org.itsnat.impl.core.domutil.TableCellElementInfoImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public abstract class ElementTableBaseImpl
extends ElementGroupImpl
implements ElementTableBase {
    protected ArrayList<ElementListBaseImpl> columnListOfRow;
    protected ElementListBaseImpl rows;
    protected boolean isHTMLTable;

    public ElementTableBaseImpl(ItsNatDocumentImpl itsNatDoc, Element parentElement) {
        super(itsNatDoc);
        this.isHTMLTable = parentElement instanceof HTMLTableSectionElement;
    }

    public ElementListBaseImpl getRowsAsElementListBase() {
        return this.rows;
    }

    public ArrayList<ElementListBaseImpl> getColumnListOfRowArrayList() {
        return this.columnListOfRow;
    }

    public abstract ElementListBaseImpl getColumnsOfRowElementList(int var1, Element var2);

    public abstract ElementListBaseImpl newColumnsOfRowElementList(int var1, Element var2);

    public abstract ElementListFreeImpl getRowsAsElementListFree();

    public void createAndSyncColumnArrayList() {
        int len = this.rows.getLength();
        for (int i = 0; i < len; ++i) {
            Element rowElem = this.rows.getElementAt(i);
            ElementListBaseImpl columsOfRow = this.newColumnsOfRowElementList(i, rowElem);
            this.columnListOfRow.add(columsOfRow);
        }
    }

    public void addColumnListOfRow(Element rowElem) {
        if (this.columnListOfRow != null) {
            int row = this.columnListOfRow.size();
            ElementListBaseImpl columsOfRow = this.newColumnsOfRowElementList(row, rowElem);
            this.columnListOfRow.add(columsOfRow);
        }
    }

    public void insertColumnListOfRow(int row, Element rowElem) {
        if (this.columnListOfRow != null) {
            ElementListBaseImpl columsOfRow = this.newColumnsOfRowElementList(row, rowElem);
            this.columnListOfRow.add(row, columsOfRow);
        }
    }

    public void removeColumnListOfRow(int row) {
        if (this.columnListOfRow != null) {
            this.columnListOfRow.remove(row);
        }
    }

    public void removeColumnListOfRowRange(int fromIndex, int toIndex) {
        if (this.columnListOfRow != null) {
            int count = toIndex - fromIndex + 1;
            for (int i = 1; i <= count; ++i) {
                this.columnListOfRow.remove(fromIndex);
            }
        }
    }

    public void removeAllColumnListOfRow() {
        if (this.columnListOfRow != null) {
            this.columnListOfRow.clear();
        }
    }

    @Override
    public Element removeRowAt(int row) {
        Element rowElem = this.rows.removeElementAt(row);
        if (rowElem == null) {
            return null;
        }
        this.removeColumnListOfRow(row);
        return rowElem;
    }

    @Override
    public void removeRowRange(int fromIndex, int toIndex) {
        this.rows.removeElementRange(fromIndex, toIndex);
        this.removeColumnListOfRowRange(fromIndex, toIndex);
    }

    @Override
    public void removeAllRows() {
        this.rows.removeAllElements();
        this.removeAllColumnListOfRow();
    }

    @Override
    public void moveRow(int start, int end, int to) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            throw new ItsNatException("Table is empty", (Object)this);
        }
        Element rowCurrentElem = this.getRowElementAt(start);
        int count = end - start + 1;
        ArrayList<Element> rowsMoved = new ArrayList<Element>(count);
        for (int i = start; i <= end; ++i) {
            rowsMoved.add(rowCurrentElem);
            Element elemTmp = rowCurrentElem;
            rowCurrentElem = rows.getNextSiblingElement(start, rowCurrentElem);
            rows.removeElement(start, elemTmp);
            this.removeColumnListOfRow(start);
        }
        Element refElem = this.getRowElementAt(to);
        for (int i = 0; i < count; ++i) {
            rowCurrentElem = (Element)rowsMoved.get(i);
            int row = to + i;
            rowCurrentElem = rows.insertBeforeElement(row, rowCurrentElem, refElem);
            this.insertColumnListOfRow(row, rowCurrentElem);
        }
    }

    @Override
    public void removeColumnAt(int column) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return;
        }
        int row = 0;
        for (Element rowElem : rows) {
            ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem);
            columns.removeElementAt(column);
            ++row;
        }
    }

    @Override
    public void removeAllColumns() {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return;
        }
        int row = 0;
        for (Element rowElem : rows) {
            ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem);
            columns.removeAllElements();
            ++row;
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.getLength();
    }

    @Override
    public Element getRowElementAt(int row) {
        return this.rows.getElementAt(row);
    }

    @Override
    public Element getCellElementAt(int row, int column) {
        Element rowElem = this.getRowElementAt(row);
        if (rowElem == null) {
            return null;
        }
        ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem);
        return columns.getElementAt(column);
    }

    @Override
    public Element[] getElementRows() {
        return this.rows.getElements();
    }

    @Override
    public Element[] getCellElementsOfRow(int row) {
        Element rowElem = this.getRowElementAt(row);
        if (rowElem == null) {
            return null;
        }
        ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem);
        return columns.getElements();
    }

    @Override
    public Element[] getCellElementsOfColumn(int column) {
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        int rowCount = this.getRowCount();
        Element[] columnElems = this.createCellElementArray(rowCount);
        if (rowCount == 0) {
            return columnElems;
        }
        int row = 0;
        for (Element rowElem : rows) {
            Element colElem;
            ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem);
            columnElems[row] = colElem = columns.getElementAt(column);
            ++row;
        }
        return columnElems;
    }

    @Override
    public Element getRowElementFromNode(Node node) {
        return this.rows.getElementFromNode(node);
    }

    @Override
    public ListElementInfo getRowListElementInfoFromNode(Node node) {
        return this.rows.getListElementInfoFromNode(node);
    }

    @Override
    public ListElementInfo getRowListElementInfoAt(int index) {
        return this.rows.getListElementInfoAt(index);
    }

    public abstract TableCellElementInfoImpl getTableCellElementInfo(ListElementInfo var1, ListElementInfo var2);

    @Override
    public TableCellElementInfo getTableCellElementInfoFromNode(Node node) {
        Element rowElem;
        if (node == null) {
            return null;
        }
        ElementListFreeImpl rows = this.getRowsAsElementListFree();
        if (rows.isEmpty()) {
            return null;
        }
        ListElementInfo rowInfo = this.getRowListElementInfoFromNode(node);
        if (rowInfo == null) {
            return null;
        }
        int row = rowInfo.getIndex();
        ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem = rowInfo.getElement());
        ListElementInfo cellInfo = columns.getListElementInfoFromNode(node);
        if (cellInfo == null) {
            return null;
        }
        return this.getTableCellElementInfo(rowInfo, cellInfo);
    }

    @Override
    public TableCellElementInfo getTableCellElementInfoAt(int row, int column) {
        ListElementInfo rowInfo = this.getRowListElementInfoAt(row);
        if (rowInfo == null) {
            return null;
        }
        Element rowElem = rowInfo.getElement();
        ElementListBaseImpl columns = this.getColumnsOfRowElementList(row, rowElem);
        ListElementInfo cellInfo = columns.getListElementInfoAt(column);
        if (cellInfo == null) {
            return null;
        }
        return this.getTableCellElementInfo(rowInfo, cellInfo);
    }

    @Override
    public Element getFirstRowElement() {
        return this.rows.getFirstElement();
    }

    @Override
    public Element getLastRowElement() {
        return this.rows.getLastElement();
    }

    @Override
    public int indexOfRowElement(Element elem) {
        return this.rows.indexOfElement(elem);
    }

    @Override
    public int lastIndexOfRowElement(Element elem) {
        return this.rows.lastIndexOfElement(elem);
    }

    @Override
    public Node item(int index) {
        return this.getElementAt(index);
    }

    @Override
    public int getLength() {
        return this.getRowCount();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Element getElementFromNode(Node node) {
        return this.getRowElementFromNode(node);
    }

    @Override
    public ListElementInfo getListElementInfoFromNode(Node node) {
        return this.getRowListElementInfoFromNode(node);
    }

    @Override
    public ListElementInfo getListElementInfoAt(int index) {
        return this.getRowListElementInfoAt(index);
    }

    @Override
    public Element getElementAt(int index) {
        return this.getRowElementAt(index);
    }

    @Override
    public Element removeElementAt(int index) {
        return this.removeRowAt(index);
    }

    @Override
    public int indexOfElement(Element elem) {
        return this.indexOfRowElement(elem);
    }

    @Override
    public int lastIndexOfElement(Element elem) {
        return this.lastIndexOfRowElement(elem);
    }

    @Override
    public Element[] getElements() {
        return this.getElementRows();
    }

    @Override
    public Element getFirstElement() {
        return this.getFirstRowElement();
    }

    @Override
    public Element getLastElement() {
        return this.getLastRowElement();
    }

    @Override
    public Element getParentElement() {
        return this.rows.getParentElement();
    }

    @Override
    public void removeAllElements() {
        this.removeAllRows();
    }

    @Override
    public void removeElementRange(int fromIndex, int toIndex) {
        this.removeRowRange(fromIndex, toIndex);
    }

    @Override
    public void moveElement(int start, int end, int to) {
        this.moveRow(start, end, to);
    }

    protected Element[] createCellElementArray(int size) {
        if (this.isHTMLTable) {
            return new HTMLTableCellElement[size];
        }
        return new Element[size];
    }
}

