/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.itsnat.core.domutil.ElementRenderer;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;

public class ElementRendererDefaultImpl
implements ElementRenderer,
Serializable {
    protected static final ElementRendererDefaultImpl SINGLETON = new ElementRendererDefaultImpl();
    public static final Set<String> htmlTagNamesWithoutTextNode = new HashSet<String>();

    private ElementRendererDefaultImpl() {
    }

    public static ElementRendererDefaultImpl newElementRendererDefault() {
        return SINGLETON;
    }

    @Override
    public void render(Object userObj, Object value, Element labelElem, boolean isNew) {
        if (value instanceof Node) {
            DOMUtilInternal.replaceContent(labelElem, (Node)value);
        } else {
            String text = DOMUtilInternal.toString(value);
            ElementRendererDefaultImpl.setTextDeepestFirstTextNode(labelElem, text);
        }
    }

    @Override
    public void unrender(Object userObj, Element elem) {
    }

    public static void setTextDeepestFirstTextNode(Element elem, String value) {
        Text textNode = ElementRendererDefaultImpl.getFirstSignificativeTextNode(elem);
        if (textNode != null) {
            DOMUtilInternal.setCharacterDataContent(textNode, value);
        } else {
            Element deepestElem = ElementRendererDefaultImpl.getDeepestFirstElementCapableOfChildTextNode(elem);
            if (deepestElem != null) {
                textNode = DOMUtilInternal.getFirstTextNode(deepestElem);
                if (textNode != null) {
                    DOMUtilInternal.setCharacterDataContent(textNode, value);
                } else if (value != null && !value.equals("")) {
                    textNode = deepestElem.getOwnerDocument().createTextNode(value);
                    deepestElem.appendChild(textNode);
                }
            } else if (value != null && !value.equals("")) {
                textNode = elem.getOwnerDocument().createTextNode(value);
                elem.appendChild(textNode);
            }
        }
    }

    public static boolean isElementCapableOfChildTextNode(Element parent) {
        return !(parent instanceof HTMLElement) || !htmlTagNamesWithoutTextNode.contains(parent.getLocalName());
    }

    public static Element getDeepestFirstElementCapableOfChildTextNode(Element parent) {
        Element child = ItsNatTreeWalker.getFirstChildElement(parent);
        while (child != null) {
            Element deepest = ElementRendererDefaultImpl.getDeepestFirstElementCapableOfChildTextNode(child);
            if (deepest != null) {
                return deepest;
            }
            child = ItsNatTreeWalker.getNextSiblingElement(child);
        }
        if (ElementRendererDefaultImpl.isElementCapableOfChildTextNode(parent)) {
            return parent;
        }
        return null;
    }

    public static Element getFirstDeepestElement(Element parent) {
        Element child = ItsNatTreeWalker.getFirstChildElement(parent);
        while (child != null) {
            parent = child;
            child = ItsNatTreeWalker.getFirstChildElement(parent);
        }
        return parent;
    }

    public static Text getFirstSignificativeTextNode(Node parent) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                Text text = (Text)child;
                if (DOMUtilInternal.isSeparator(text)) continue;
                return text;
            }
            Text textNode = ElementRendererDefaultImpl.getFirstSignificativeTextNode(child);
            if (textNode == null) continue;
            return textNode;
        }
        return null;
    }

    static {
        htmlTagNamesWithoutTextNode.add("table");
        htmlTagNamesWithoutTextNode.add("tbody");
        htmlTagNamesWithoutTextNode.add("tfoot");
        htmlTagNamesWithoutTextNode.add("thead");
        htmlTagNamesWithoutTextNode.add("tr");
        htmlTagNamesWithoutTextNode.add("col");
        htmlTagNamesWithoutTextNode.add("colgroup");
        htmlTagNamesWithoutTextNode.add("frameset");
        htmlTagNamesWithoutTextNode.add("html");
        htmlTagNamesWithoutTextNode.add("select");
        htmlTagNamesWithoutTextNode.add("iframe");
        htmlTagNamesWithoutTextNode.add("img");
        htmlTagNamesWithoutTextNode.add("input");
        htmlTagNamesWithoutTextNode.add("br");
    }
}

