/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementList;
import org.itsnat.core.domutil.ElementListRenderer;
import org.itsnat.core.domutil.ElementListStructure;
import org.itsnat.core.domutil.ListElementInfo;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.ElementListBaseImpl;
import org.itsnat.impl.core.domutil.ElementListFreeImpl;
import org.itsnat.impl.core.domutil.ListElementInfoImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementListImpl
extends ElementListBaseImpl
implements ElementList {
    protected ElementListRenderer renderer;
    protected ElementListStructure structure;
    protected Element childPatternElement;
    protected ElementListFreeImpl elementList;
    protected DocumentFragment childContentPatternFragment;
    protected boolean usePatternMarkupToRender;

    public ElementListImpl(ItsNatDocumentImpl itsNatDoc, boolean master, Element parentElement, Element childPatternElement, boolean clonePattern, DocumentFragment childContentPatternFragment, boolean removePattern, ElementListRenderer renderer, ElementListStructure structure) {
        super(itsNatDoc);
        this.renderer = renderer;
        this.structure = structure;
        this.usePatternMarkupToRender = itsNatDoc.isUsePatternMarkupToRender();
        this.elementList = (ElementListFreeImpl)itsNatDoc.getElementGroupManagerImpl().createElementListFree(parentElement, master);
        if (childPatternElement == null) {
            childPatternElement = this.getElementAt(0);
            if (childPatternElement == null) {
                throw new ItsNatDOMException("The list must have at least one cell (used as pattern)", (Node)this.elementList.getParentElement());
            }
            clonePattern = !removePattern;
        }
        this.setChildPatternElement(childPatternElement, clonePattern);
        this.childContentPatternFragment = childContentPatternFragment;
        if (removePattern) {
            this.removeAllElements();
        }
    }

    public ElementListFreeImpl getInternalElementListFree() {
        return this.elementList;
    }

    @Override
    public ElementListRenderer getElementListRenderer() {
        return this.renderer;
    }

    @Override
    public void setElementListRenderer(ElementListRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public ElementListStructure getElementListStructure() {
        return this.structure;
    }

    @Override
    public void setElementListStructure(ElementListStructure structure) {
        this.structure = structure;
    }

    @Override
    public Element getContentElementAt(int index) {
        Element elem = this.getElementAt(index);
        if (elem == null) {
            return null;
        }
        return this.getContentElementAt(index, elem);
    }

    public Element getContentElementAt(int index, Element elem) {
        return this.getElementListStructure().getContentElement(this, index, elem);
    }

    public boolean isMaster() {
        return this.elementList.isMaster();
    }

    @Override
    public Element getParentElement() {
        return this.elementList.getParentElement();
    }

    @Override
    public Element getChildPatternElement() {
        return this.childPatternElement;
    }

    public void setChildPatternElement(Element childPatternElement, boolean clone) {
        this.childPatternElement = clone ? (Element)childPatternElement.cloneNode(true) : childPatternElement;
        if (this.childPatternElement.getAttribute("id").length() > 0) {
            this.childPatternElement.removeAttribute("id");
        }
    }

    @Override
    public DocumentFragment getChildContentPatternFragment() {
        if (this.childContentPatternFragment == null) {
            ElementListStructure structure = this.getElementListStructure();
            if (structure == null) {
                throw new ItsNatException("INTERNAL ERROR");
            }
            Element itemContentElem = structure.getContentElement(this, 0, this.getChildPatternElement());
            if (itemContentElem != null) {
                Element clonedItemContentElem = (Element)itemContentElem.cloneNode(true);
                this.childContentPatternFragment = DOMUtilInternal.extractChildrenToDocFragment(clonedItemContentElem);
            }
        }
        return this.childContentPatternFragment;
    }

    @Override
    public boolean isEmpty() {
        return this.elementList.isEmpty();
    }

    @Override
    public int getLength() {
        return this.elementList.getLength();
    }

    @Override
    public void setLength(int len) {
        block4: {
            int diff;
            block3: {
                if (len < 0) {
                    throw new ItsNatException("Length can not be negative:" + len, (Object)this);
                }
                int currentSize = this.getLength();
                diff = len - currentSize;
                if (diff <= 0) break block3;
                for (int i = 0; i < diff; ++i) {
                    this.addElement();
                }
                break block4;
            }
            if (diff >= 0) break block4;
            for (int i = currentSize - 1; i >= len; --i) {
                this.removeElementAt(i);
            }
        }
    }

    @Override
    public Element getElementAt(int index) {
        return this.elementList.getElementAt(index);
    }

    public Element createNewElement() {
        return (Element)this.childPatternElement.cloneNode(true);
    }

    @Override
    public Element addElement() {
        Element newNode = this.createNewElement();
        newNode = this.elementList.addElement2(newNode);
        return newNode;
    }

    @Override
    public Element addElement(Object value) {
        Element newNode = this.addElement();
        this.setElementValueAt(this.getLength() - 1, newNode, value, true);
        return newNode;
    }

    @Override
    public Element insertElementAt(int index) {
        Element newNode = this.createNewElement();
        newNode = this.elementList.insertElementAt2(index, newNode);
        return newNode;
    }

    @Override
    public Element insertElementAt(int index, Object value) {
        Element newNode = this.insertElementAt(index);
        this.setElementValueAt(index, newNode, value, true);
        return newNode;
    }

    public void unrenderElementAt(int index) {
        ElementListRenderer renderer = this.getElementListRenderer();
        if (renderer == null) {
            return;
        }
        Element elem = this.getElementAt(index);
        if (elem == null) {
            return;
        }
        Element contentElem = this.getContentElementAt(index, elem);
        renderer.unrenderList(this, index, contentElem);
    }

    @Override
    public Element removeElementAt(int index) {
        this.unrenderElementAt(index);
        return this.elementList.removeElementAt(index);
    }

    @Override
    public void removeElementRange(int fromIndex, int toIndex) {
        if (this.getElementListRenderer() != null) {
            for (int i = fromIndex; i <= toIndex; ++i) {
                this.unrenderElementAt(i);
            }
        }
        this.elementList.removeElementRange(fromIndex, toIndex);
    }

    @Override
    public void removeAllElements() {
        if (this.getElementListRenderer() != null) {
            int size = this.getLength();
            for (int i = 0; i < size; ++i) {
                this.unrenderElementAt(i);
            }
        }
        this.elementList.removeAllElements();
    }

    public void removeChildPatternElement() {
        Node parent = this.childPatternElement.getParentNode();
        if (parent != null) {
            parent.removeChild(this.childPatternElement);
        }
    }

    @Override
    public void setElementValueAt(int index, Object value) {
        Element elem = this.getElementAt(index);
        if (elem == null) {
            throw new ItsNatException("Out of range", (Object)this);
        }
        this.setElementValueAt(index, elem, value, false);
    }

    public void setElementValueAt(int index, Element elem, Object value, boolean isNew) {
        Element contentElem = this.getContentElementAt(index, elem);
        this.prepareRendering(contentElem, isNew);
        ElementListRenderer renderer = this.getElementListRenderer();
        if (renderer != null) {
            renderer.renderList(this, index, value, contentElem, isNew);
        }
    }

    public void prepareRendering(Element contentElem, boolean isNew) {
        if (!isNew && this.isUsePatternMarkupToRender()) {
            ElementListImpl.restorePatternMarkupWhenRendering(contentElem, this.getChildContentPatternFragment());
        }
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    @Override
    public Element getElementFromNode(Node node) {
        return this.elementList.getElementFromNode(node);
    }

    @Override
    public ListElementInfo getListElementInfoAt(int index) {
        return this.elementList.getListElementInfoAt(index);
    }

    @Override
    public ListElementInfo getListElementInfoFromNode(Node node) {
        return this.elementList.getListElementInfoFromNode(node);
    }

    @Override
    public ListElementInfoImpl getListElementInfoFromNode(Node node, Element limitElem) {
        return this.elementList.getListElementInfoFromNode(node, limitElem);
    }

    @Override
    public Element getFirstElement() {
        return this.elementList.getFirstElement();
    }

    @Override
    public Element getLastElement() {
        return this.elementList.getLastElement();
    }

    @Override
    public int indexOfElement(Element node) {
        return this.elementList.indexOfElement(node);
    }

    @Override
    public int lastIndexOfElement(Element node) {
        return this.elementList.lastIndexOfElement(node);
    }

    @Override
    public Element[] getElements() {
        return this.elementList.getElements();
    }

    @Override
    public void moveElement(int start, int end, int to) {
        this.elementList.moveElement(start, end, to);
    }
}

