/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.domutil.ElementListFreeInternal;
import org.itsnat.impl.core.domutil.ElementListFreeIteratorImpl;
import org.itsnat.impl.core.domutil.ElementListFreeListIteratorImpl;
import org.w3c.dom.Element;

public class ElementListFreeUtil {
    public static int indexOf(ElementListFreeInternal list, Object o) {
        return list.indexOfElement((Element)o);
    }

    public static boolean contains(ElementListFreeInternal list, Object o) {
        return ElementListFreeUtil.indexOf(list, o) != -1;
    }

    public static boolean add(ElementListFreeInternal list, Object o) {
        list.addElement((Element)o);
        return true;
    }

    public static int lastIndexOf(ElementListFreeInternal list, Object o) {
        return list.lastIndexOfElement((Element)o);
    }

    public static boolean remove(ElementListFreeInternal list, Object o) {
        Element elem = (Element)o;
        int index = list.indexOfElement(elem);
        list.removeElement(index, elem);
        return true;
    }

    public static <T> T[] toArray(ElementListFreeInternal list, T[] a) {
        Element[] elems = list.getElements();
        if (a.length < elems.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), elems.length);
        }
        System.arraycopy(elems, 0, a, 0, elems.length);
        return a;
    }

    public static Element get(ElementListFreeInternal list, int index) {
        return list.getElementAt(index);
    }

    public static Iterator<Element> iterator(ElementListFreeInternal list) {
        return new ElementListFreeIteratorImpl(list);
    }

    public static ListIterator<Element> listIterator(ElementListFreeInternal list, int index) {
        return new ElementListFreeListIteratorImpl(list, index);
    }

    public static ListIterator<Element> listIterator(ElementListFreeInternal list) {
        return new ElementListFreeListIteratorImpl(list, 0);
    }

    public static Element remove(ElementListFreeInternal list, int index) {
        return list.removeElementAt(index);
    }

    public static boolean addAll(ElementListFreeInternal list, int index, Collection<? extends Element> c) {
        for (Element element : c) {
            list.insertElementAt(index, element);
            ++index;
        }
        return true;
    }

    public static boolean containsAll(ElementListFreeInternal list, Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (list.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(ElementListFreeInternal list, Collection<? extends Element> c) {
        for (Element element : c) {
            list.addElement(element);
        }
        return true;
    }

    public static boolean removeAll(ElementListFreeInternal list, Collection<?> c) {
        boolean modified = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public static boolean retainAll(ElementListFreeInternal list, Collection<?> c) {
        boolean modified = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public static void add(ElementListFreeInternal list, int index, Object element) {
        list.insertElementAt(index, (Element)element);
    }

    public static Element set(ElementListFreeInternal list, int index, Element element) {
        return list.setElementAt(index, element);
    }

    public static Element[] toArray(ElementListFreeInternal list) {
        return list.getElements();
    }

    public static List<Element> subList(ElementListFreeInternal list, int fromIndex, int toIndex) {
        throw new ItsNatException("Not implemented", (Object)list);
    }

    public static int size(ElementListFreeInternal list) {
        return list.getLength();
    }

    public static void clear(ElementListFreeInternal list) {
        list.removeAllElements();
    }
}

