/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.ArrayList;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.ElementListFreeImpl;
import org.itsnat.impl.core.domutil.ListElementInfoImpl;
import org.itsnat.impl.core.domutil.ListElementInfoMasterImpl;
import org.w3c.dom.Element;

public class ElementListFreeMasterImpl
extends ElementListFreeImpl {
    protected ArrayList<ListElementInfoMasterImpl> elements = new ArrayList();

    public ElementListFreeMasterImpl(Element parentElement, ItsNatDocumentImpl itsNatDoc) {
        super(parentElement, itsNatDoc);
        this.initialSync();
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    public void initialSync() {
        this.elements.clear();
        Element child = ItsNatTreeWalker.getFirstChildElement(this.parentElement);
        while (child != null) {
            this.addListElementInfo(child);
            child = ItsNatTreeWalker.getNextSiblingElement(child);
        }
    }

    @Override
    public ListElementInfoImpl getListElementInfo(int index, Element elem) {
        return this.getListElementInfo(index);
    }

    @Override
    public ListElementInfoImpl getListElementInfo(int index) {
        return this.elements.get(index);
    }

    public ListElementInfoImpl addListElementInfo(Element elem) {
        ListElementInfoMasterImpl elemInfo = new ListElementInfoMasterImpl(this.elements.size(), elem, this);
        this.elements.add(elemInfo);
        return elemInfo;
    }

    public ListElementInfoImpl insertListElementInfo(int index, Element elem) {
        ListElementInfoMasterImpl elemInfo = new ListElementInfoMasterImpl(index, elem, this);
        this.elements.add(index, elemInfo);
        for (int i = index + 1; i < this.elements.size(); ++i) {
            ListElementInfoMasterImpl currElemInfo = this.elements.get(i);
            currElemInfo.setIndex(currElemInfo.getIndex() + 1);
        }
        return elemInfo;
    }

    public void removeListElementInfo(int index) {
        this.elements.remove(index);
        for (int i = index; i < this.elements.size(); ++i) {
            ListElementInfoMasterImpl currElemInfo = this.elements.get(i);
            currElemInfo.setIndex(currElemInfo.getIndex() - 1);
        }
    }

    public void removeListElementInfoRange(int fromIndex, int toIndex) {
        int i;
        int count = toIndex - fromIndex + 1;
        for (i = 1; i <= count; ++i) {
            this.elements.remove(fromIndex);
        }
        for (i = fromIndex; i < this.elements.size(); ++i) {
            ListElementInfoMasterImpl currElemInfo = this.elements.get(i);
            currElemInfo.setIndex(currElemInfo.getIndex() - count);
        }
    }

    @Override
    public ListElementInfoImpl getListElementInfo(Element elem) {
        if (elem == null) {
            return null;
        }
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            ListElementInfoImpl elemInfo = this.getListElementInfo(i);
            Element currElem = elemInfo.getElement();
            if (currElem != elem) continue;
            return elemInfo;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public int getLength() {
        return this.elements.size();
    }

    public boolean isOutOfRange(int index) {
        return index < 0 || index >= this.elements.size();
    }

    @Override
    public Element getElementAt(int index) {
        if (this.isOutOfRange(index)) {
            return null;
        }
        ListElementInfoImpl elemInfo = this.getListElementInfo(index);
        return elemInfo.getElement();
    }

    @Override
    public Element getFirstElement() {
        return this.getElementAt(0);
    }

    @Override
    public Element getLastElement() {
        return this.getElementAt(this.getLength() - 1);
    }

    @Override
    public int indexOfElement(Element node) {
        if (node == null) {
            return -1;
        }
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            Element child = this.getElementAt(i);
            if (child != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfElement(Element node) {
        if (node == null) {
            return -1;
        }
        int len = this.getLength();
        for (int i = len - 1; i >= 0; --i) {
            Element child = this.getElementAt(i);
            if (child != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void fillElements(Element[] elemList) {
        for (int i = 0; i < elemList.length; ++i) {
            Element elem;
            elemList[i] = elem = this.getElementAt(i);
        }
    }

    @Override
    protected void addElementInternal(Element newNode) {
        super.addElementInternal(newNode);
        this.addListElementInfo(newNode);
    }

    @Override
    protected void insertBeforeElementInternal(int index, Element newNode, Element refNode) {
        super.insertBeforeElementInternal(index, newNode, refNode);
        this.insertListElementInfo(index, newNode);
    }

    @Override
    protected void insertElementAtInternal(int index, Element newNode) {
        super.insertElementAtInternal(index, newNode);
        this.insertListElementInfo(index, newNode);
    }

    @Override
    protected Element setElementAtInternal(int index, Element currNode, Element newNode) {
        Element res = super.setElementAtInternal(index, currNode, newNode);
        this.updateListElementInfo(index, newNode);
        return res;
    }

    public ListElementInfoImpl updateListElementInfo(int index, Element elem) {
        ListElementInfoMasterImpl elemInfo = (ListElementInfoMasterImpl)this.getListElementInfo(index);
        elemInfo.setElement(elem);
        return elemInfo;
    }

    @Override
    public void removeElement(int index, Element node) {
        super.removeElement(index, node);
        this.removeListElementInfo(index);
    }

    @Override
    public Element removeElementAt(int index) {
        Element child = super.removeElementAt(index);
        if (child == null) {
            return null;
        }
        this.removeListElementInfo(index);
        return child;
    }

    @Override
    public void removeElementRange(int fromIndex, int toIndex) {
        super.removeElementRange(fromIndex, toIndex);
        this.removeListElementInfoRange(fromIndex, toIndex);
    }

    @Override
    public Element getNextSiblingElement(int index, Element ref) {
        return this.getElementAt(index + 1);
    }

    @Override
    public Element getPreviousSiblingElement(int index, Element ref) {
        return this.getElementAt(index - 1);
    }
}

