/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.itsnat.impl.core.domutil.ElementListFreeInternal;
import org.itsnat.impl.core.domutil.ElementListFreeIteratorImpl;
import org.itsnat.impl.core.domutil.ElementPair;
import org.w3c.dom.Element;

public class ElementListFreeListIteratorImpl
extends ElementListFreeIteratorImpl
implements ListIterator<Element> {
    protected Element prevElem;

    public ElementListFreeListIteratorImpl(ElementListFreeInternal list, int nextIndex) {
        super(list, nextIndex);
        this.prevElem = list.getElementAt(nextIndex - 1);
    }

    @Override
    public boolean hasPrevious() {
        return this.prevElem != null;
    }

    @Override
    public Element previous() {
        if (this.prevElem == null) {
            throw new NoSuchElementException();
        }
        --this.nextIndex;
        this.currIndex = this.nextIndex;
        this.nextElem = this.currElem;
        this.currElem = this.prevElem;
        this.prevElem = this.list.getPreviousSiblingElement(this.currIndex, this.currElem);
        return this.currElem;
    }

    @Override
    public Element next() {
        Element res = super.next();
        this.prevElem = this.currElem;
        return res;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void set(Element o) {
        if (this.currIndex == -1) {
            throw new IllegalStateException();
        }
        ElementPair res = this.list.setElementAt2(this.currIndex, o);
        this.currElem = res.getNewElem();
    }

    @Override
    public void add(Element o) {
        Element currElem = o;
        this.prevElem = this.currElem = this.list.insertBeforeElement(this.nextIndex, currElem, this.nextElem);
        ++this.nextIndex;
        ++this.currIndex;
    }
}

