/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.itsnat.impl.core.domutil.ElementListFreeInternal;
import org.w3c.dom.Element;

public class ElementListFreeIteratorImpl
implements Iterator<Element> {
    protected ElementListFreeInternal list;
    protected Element currElem;
    protected Element nextElem;
    protected int nextIndex;
    protected int currIndex;

    public ElementListFreeIteratorImpl(ElementListFreeInternal list, int nextIndex) {
        this.list = list;
        this.currElem = null;
        this.nextElem = list.getElementAt(nextIndex);
        this.nextIndex = nextIndex;
        this.currIndex = -1;
    }

    public ElementListFreeIteratorImpl(ElementListFreeInternal list) {
        this(list, 0);
    }

    @Override
    public boolean hasNext() {
        return this.nextElem != null;
    }

    @Override
    public Element next() {
        if (this.nextElem == null) {
            throw new NoSuchElementException();
        }
        ++this.nextIndex;
        this.currIndex = this.nextIndex - 1;
        this.currElem = this.nextElem;
        this.nextElem = this.list.getNextSiblingElement(this.currIndex, this.currElem);
        return this.currElem;
    }

    @Override
    public void remove() {
        if (this.currIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.removeElement(this.currIndex, this.currElem);
        this.currElem = this.nextElem;
        --this.nextIndex;
        this.currIndex = -1;
    }
}

