/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.core.domutil.ListElementInfo;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.ElementListBaseImpl;
import org.itsnat.impl.core.domutil.ElementListFreeInternal;
import org.itsnat.impl.core.domutil.ElementListFreeUtil;
import org.itsnat.impl.core.domutil.ElementPair;
import org.itsnat.impl.core.domutil.ListElementInfoImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public abstract class ElementListFreeImpl
extends ElementListBaseImpl
implements ElementListFreeInternal {
    protected Element parentElement;

    public ElementListFreeImpl(Element parentElement, ItsNatDocumentImpl itsNatDoc) {
        super(itsNatDoc);
        this.parentElement = parentElement;
    }

    @Override
    public Element getParentElement() {
        return this.parentElement;
    }

    public Element getNextSiblingElement(Element ref) {
        return ItsNatTreeWalker.getNextSiblingElement(ref);
    }

    public Element getPreviousSiblingElement(Element ref) {
        return ItsNatTreeWalker.getPreviousSiblingElement(ref);
    }

    protected Element cloneNewElementIfNeeded(Element newNode) {
        if (newNode.getParentNode() == this.getParentElement()) {
            return (Element)newNode.cloneNode(true);
        }
        return newNode;
    }

    @Override
    public void addElement(Element newNode) {
        this.addElement2(newNode);
    }

    @Override
    public Element addElement2(Element newNode) {
        newNode = this.cloneNewElementIfNeeded(newNode);
        this.addElementInternal(newNode);
        return newNode;
    }

    protected void addElementInternal(Element newNode) {
        this.parentElement.appendChild(newNode);
    }

    @Override
    public void insertElementAt(int index, Element newNode) {
        this.insertElementAt2(index, newNode);
    }

    @Override
    public Element insertElementAt2(int index, Element newNode) {
        newNode = this.cloneNewElementIfNeeded(newNode);
        this.insertElementAtInternal(index, newNode);
        return newNode;
    }

    protected void insertElementAtInternal(int index, Element newNode) {
        Element childRef = this.getElementAt(index);
        this.parentElement.insertBefore(newNode, childRef);
    }

    @Override
    public Element setElementAt(int index, Element newNode) {
        ElementPair res = this.setElementAt2(index, newNode);
        return res.getOldElem();
    }

    @Override
    public ElementPair setElementAt2(int index, Element newNode) {
        Element currNode = this.getElementAt(index);
        if (currNode == null) {
            throw new ItsNatException("No Element found at " + index, (Object)this);
        }
        if (currNode == newNode) {
            return new ElementPair(currNode, newNode);
        }
        newNode = this.cloneNewElementIfNeeded(newNode);
        Element oldNode = this.setElementAtInternal(index, currNode, newNode);
        return new ElementPair(oldNode, newNode);
    }

    protected Element setElementAtInternal(int index, Element currNode, Element newNode) {
        this.parentElement.insertBefore(newNode, currNode);
        this.parentElement.removeChild(currNode);
        return currNode;
    }

    @Override
    public Element insertBeforeElement(int index, Element newNode, Element refNode) {
        newNode = this.cloneNewElementIfNeeded(newNode);
        this.insertBeforeElementInternal(index, newNode, refNode);
        return newNode;
    }

    protected void insertBeforeElementInternal(int index, Element newNode, Element refNode) {
        this.parentElement.insertBefore(newNode, refNode);
    }

    @Override
    public void removeElement(int index, Element node) {
        this.parentElement.removeChild(node);
    }

    @Override
    public Element removeElementAt(int index) {
        Element child = this.getElementAt(index);
        if (child == null) {
            return null;
        }
        this.parentElement.removeChild(child);
        return child;
    }

    @Override
    public void removeElementRange(int fromIndex, int toIndex) {
        int i;
        int count = toIndex - fromIndex + 1;
        if (count <= 0) {
            return;
        }
        Element last = null;
        for (i = toIndex; i >= fromIndex && (last = this.getElementAt(i)) == null; --i) {
        }
        if (last == null) {
            return;
        }
        toIndex = i;
        count = toIndex - fromIndex + 1;
        if (count <= 0) {
            return;
        }
        for (i = 1; i <= count; ++i) {
            Element prev = last;
            last = this.getPreviousSiblingElement(last);
            this.parentElement.removeChild(prev);
        }
    }

    @Override
    public void removeAllElements() {
        while (!this.isEmpty()) {
            this.removeElementAt(0);
        }
    }

    @Override
    public Element getElementFromNode(Node node) {
        return this.getChildElementFromNode(node, null);
    }

    public Element getChildElementFromNode(Node node, Element limitElem) {
        Node child = DOMUtilInternal.getChildTopMostContainingNode(node, this.getParentElement(), limitElem);
        return (Element)child;
    }

    @Override
    public Element[] getElements() {
        Element[] elemList = this.createElementArray(this.getLength());
        this.fillElements(elemList);
        return elemList;
    }

    @Override
    public ListElementInfo getListElementInfoFromNode(Node node) {
        return this.getListElementInfoFromNode(node, null);
    }

    @Override
    public ListElementInfo getListElementInfoAt(int index) {
        return this.getListElementInfo(index);
    }

    @Override
    public ListElementInfoImpl getListElementInfoFromNode(Node node, Element limitElem) {
        Element elem = this.getChildElementFromNode(node, limitElem);
        if (elem == null) {
            return null;
        }
        return this.getListElementInfo(elem);
    }

    @Override
    public void moveElement(int start, int end, int to) {
        Element elemCurrent = this.getElementAt(start);
        int count = end - start + 1;
        ArrayList<Element> movedElems = new ArrayList<Element>(count);
        for (int i = start; i <= end; ++i) {
            movedElems.add(elemCurrent);
            Element elemTmp = elemCurrent;
            elemCurrent = this.getNextSiblingElement(start, elemCurrent);
            this.removeElement(start, elemTmp);
        }
        Element refElem = this.getElementAt(to);
        for (int i = 0; i < count; ++i) {
            elemCurrent = (Element)movedElems.get(i);
            int pos = to + i;
            this.insertBeforeElement(pos, elemCurrent, refElem);
        }
    }

    @Override
    public Element[] setElements(Element[] newElems) {
        Element[] replaced = this.getElements();
        this.removeAllElements();
        for (int i = 0; i < newElems.length; ++i) {
            this.addElement(newElems[i]);
        }
        return replaced;
    }

    public abstract void fillElements(Element[] var1);

    public Element[] createElementArray(int len) {
        Element parentElement = this.getParentElement();
        if (parentElement instanceof HTMLTableSectionElement) {
            return new HTMLTableRowElement[len];
        }
        if (parentElement instanceof HTMLTableRowElement) {
            return new HTMLTableCellElement[len];
        }
        return new Element[len];
    }

    public abstract ListElementInfoImpl getListElementInfo(int var1, Element var2);

    public abstract ListElementInfoImpl getListElementInfo(Element var1);

    public abstract ListElementInfoImpl getListElementInfo(int var1);

    @Override
    public int indexOf(Object o) {
        return ElementListFreeUtil.indexOf(this, o);
    }

    @Override
    public boolean contains(Object o) {
        return ElementListFreeUtil.contains(this, o);
    }

    @Override
    public boolean add(Element o) {
        return ElementListFreeUtil.add(this, o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ElementListFreeUtil.lastIndexOf(this, o);
    }

    @Override
    public boolean remove(Object o) {
        return ElementListFreeUtil.remove((ElementListFreeInternal)this, o);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ElementListFreeUtil.toArray(this, a);
    }

    @Override
    public Element get(int index) {
        return ElementListFreeUtil.get(this, index);
    }

    @Override
    public Iterator<Element> iterator() {
        return ElementListFreeUtil.iterator(this);
    }

    @Override
    public ListIterator<Element> listIterator(int index) {
        return ElementListFreeUtil.listIterator(this, index);
    }

    @Override
    public ListIterator<Element> listIterator() {
        return ElementListFreeUtil.listIterator(this);
    }

    @Override
    public Element remove(int index) {
        return ElementListFreeUtil.remove((ElementListFreeInternal)this, index);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Element> c) {
        return ElementListFreeUtil.addAll(this, index, c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ElementListFreeUtil.containsAll(this, c);
    }

    @Override
    public boolean addAll(Collection<? extends Element> c) {
        return ElementListFreeUtil.addAll(this, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ElementListFreeUtil.removeAll(this, c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ElementListFreeUtil.retainAll(this, c);
    }

    @Override
    public void add(int index, Element element) {
        ElementListFreeUtil.add(this, index, element);
    }

    @Override
    public Element set(int index, Element element) {
        return ElementListFreeUtil.set(this, index, element);
    }

    @Override
    public Object[] toArray() {
        return ElementListFreeUtil.toArray(this);
    }

    @Override
    public List<Element> subList(int fromIndex, int toIndex) {
        return ElementListFreeUtil.subList(this, fromIndex, toIndex);
    }

    @Override
    public int size() {
        return ElementListFreeUtil.size(this);
    }

    @Override
    public void clear() {
        ElementListFreeUtil.clear(this);
    }
}

