/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementLabel;
import org.itsnat.core.domutil.ElementLabelRenderer;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.ElementGroupImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class ElementLabelImpl
extends ElementGroupImpl
implements ElementLabel {
    protected Element parentElement;
    protected ElementLabelRenderer renderer;
    protected DocumentFragment contentPatternFragment;
    protected boolean usePatternMarkupToRender;
    protected boolean hasLabel = false;

    public ElementLabelImpl(ItsNatDocumentImpl itsNatDoc, Element parentElement, boolean removePattern, ElementLabelRenderer renderer) {
        super(itsNatDoc);
        this.parentElement = parentElement;
        this.renderer = renderer;
        this.usePatternMarkupToRender = itsNatDoc.isUsePatternMarkupToRender();
        if (removePattern) {
            this.contentPatternFragment = DOMUtilInternal.extractChildrenToDocFragment(parentElement);
        } else {
            Element clonedParentElem = (Element)parentElement.cloneNode(true);
            this.contentPatternFragment = DOMUtilInternal.extractChildrenToDocFragment(clonedParentElem);
            this.hasLabel = true;
        }
    }

    @Override
    public Element getParentElement() {
        return this.parentElement;
    }

    @Override
    public ElementLabelRenderer getElementLabelRenderer() {
        return this.renderer;
    }

    @Override
    public void setElementLabelRenderer(ElementLabelRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public DocumentFragment getContentPatternFragment() {
        return this.contentPatternFragment;
    }

    @Override
    public boolean hasLabelMarkup() {
        return this.hasLabel;
    }

    @Override
    public void setLabelValue(Object value) {
        if (!this.hasLabel) {
            this.addLabelMarkup(value);
        } else {
            this.setElementValue(value, false);
        }
    }

    public void setElementValue(Object value, boolean isNew) {
        this.prepareRendering(isNew);
        Element parent = this.getParentElement();
        ElementLabelRenderer renderer = this.getElementLabelRenderer();
        if (renderer != null) {
            renderer.renderLabel(this, value, parent, isNew);
        }
    }

    @Override
    public void addLabelMarkup() {
        if (this.hasLabel) {
            throw new ItsNatException("Label already has markup", (Object)this);
        }
        Element parent = this.getParentElement();
        parent.appendChild(this.contentPatternFragment.cloneNode(true));
        this.hasLabel = true;
    }

    @Override
    public void addLabelMarkup(Object value) {
        this.addLabelMarkup();
        this.setElementValue(value, true);
    }

    @Override
    public void removeLabelMarkup() {
        Element parent = this.getParentElement();
        ElementLabelRenderer renderer = this.getElementLabelRenderer();
        if (renderer != null) {
            renderer.unrenderLabel(this, parent);
        }
        DOMUtilInternal.removeAllChildren(parent);
        this.hasLabel = false;
    }

    public void prepareRendering(boolean isNew) {
        if (!isNew && this.isUsePatternMarkupToRender()) {
            Element parent = this.getParentElement();
            ElementLabelImpl.restorePatternMarkupWhenRendering(parent, this.getContentPatternFragment());
        }
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }
}

