/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import java.util.LinkedList;
import org.itsnat.impl.core.domutil.NodeConstraints;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMUtilInternal {
    public static String getLocalName(Element elem) {
        String localName = elem.getLocalName();
        if (localName != null) {
            return localName;
        }
        return elem.getNodeName();
    }

    public static Element getElementById(String id, Node container) {
        Element elem;
        if (container.getNodeType() == 1 && id.equals((elem = (Element)container).getAttribute("id"))) {
            return elem;
        }
        for (Node child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element matchElem;
            if (child.getNodeType() != 1 || (matchElem = DOMUtilInternal.getElementById(id, child)) == null) continue;
            return matchElem;
        }
        return null;
    }

    public static Element createElement(String tagName, String text, Document doc) {
        Element elem = doc.createElement(tagName);
        if (text != null && !text.equals("")) {
            elem.appendChild(doc.createTextNode(text));
        }
        return elem;
    }

    public static Element createElementNS(String namespaceURI, String qualifiedName, String text, Document doc) {
        if (namespaceURI == null) {
            return DOMUtilInternal.createElement(qualifiedName, text, doc);
        }
        Element elem = doc.createElementNS(namespaceURI, qualifiedName);
        if (text != null && !text.equals("")) {
            elem.appendChild(doc.createTextNode(text));
        }
        return elem;
    }

    public static String getTextContent(Element elem) {
        return DOMUtilInternal.getTextContent(elem, true);
    }

    public static String getTextContent(Element elem, boolean onlyFirstChild) {
        Text textNode = (Text)elem.getFirstChild();
        if (textNode == null) {
            return "";
        }
        String res = textNode.getData();
        if (onlyFirstChild) {
            return res;
        }
        if (textNode == elem.getLastChild()) {
            return res;
        }
        StringBuilder resBuff = new StringBuilder();
        resBuff.append(res);
        for (textNode = (Text)textNode.getNextSibling(); textNode != null; textNode = (Text)textNode.getNextSibling()) {
            resBuff.append(textNode.getData());
        }
        return resBuff.toString();
    }

    public static void setTextContent(Element elem, String value) {
        Text textNode;
        if (value == null) {
            value = "";
        }
        if ((textNode = (Text)elem.getFirstChild()) == null) {
            if (!value.equals("")) {
                textNode = elem.getOwnerDocument().createTextNode(value);
                elem.appendChild(textNode);
            }
        } else if (value.equals("")) {
            elem.removeChild(textNode);
        } else {
            textNode.setData(value);
        }
    }

    public static Node extractChildren(Node parentNode) {
        return DOMUtilInternal.extractChildren(parentNode, false);
    }

    public static Node extractChildren(Node parentNode, boolean removeLastChildFirst) {
        Node child = parentNode.getFirstChild();
        if (child == null) {
            return null;
        }
        if (child.getNextSibling() == null) {
            parentNode.removeChild(child);
            return child;
        }
        return DOMUtilInternal.extractChildrenToDocFragment(parentNode, removeLastChildFirst);
    }

    public static void removeAllChildren(Node parentNode) {
        Node child = parentNode.getLastChild();
        while (child != null) {
            parentNode.removeChild(child);
            child = parentNode.getLastChild();
        }
    }

    public static boolean isNodeInsideDocument(Node node) {
        Document parentNode = node.getOwnerDocument();
        Node currParent = node.getParentNode();
        while (currParent != parentNode && currParent != null) {
            node = node.getParentNode();
            currParent = node.getParentNode();
        }
        return currParent == parentNode;
    }

    public static boolean isNodeInside(Node node, Node parentNode) {
        if (parentNode == null) {
            parentNode = node.getOwnerDocument();
        }
        Node currParent = node.getParentNode();
        while (currParent != parentNode && currParent != null) {
            node = node.getParentNode();
            currParent = node.getParentNode();
        }
        return currParent == parentNode;
    }

    public static boolean isTheOnlyChildNode(Node childNode) {
        Node parentNode = childNode.getParentNode();
        return parentNode.getFirstChild() == childNode && parentNode.getLastChild() == childNode;
    }

    public static void setAttribute(Element elem, String name, String value) {
        String oldValue = elem.getAttribute(name);
        if (value.equals(oldValue)) {
            return;
        }
        elem.setAttribute(name, value);
    }

    public static void setBooleanAttribute(Element elem, String name, boolean value) {
        if (value) {
            DOMUtilInternal.setAttribute(elem, name, name);
        } else {
            elem.removeAttribute(name);
        }
    }

    public static String toString(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public static boolean isChildOrSame(Node node, Element parentElement) {
        return DOMUtilInternal.isChildOrSame(node, parentElement, null);
    }

    public static boolean isChildOrSame(Node node, Element parentElement, Element topLimitParent) {
        if (node == null) {
            return false;
        }
        if (node == parentElement) {
            return true;
        }
        return DOMUtilInternal.isChild(node, parentElement, topLimitParent);
    }

    public static boolean isChild(Node node, Element parentElement) {
        return DOMUtilInternal.isChild(node, parentElement, null);
    }

    public static boolean isChild(Node node, Element parentElement, Element topLimitParent) {
        if (node == null) {
            return false;
        }
        if (node == parentElement) {
            return false;
        }
        Node nodeParent = DOMUtilInternal.getChildTopMostContainingNode(node, parentElement, topLimitParent);
        return nodeParent != null;
    }

    public static Node getChildTopMostContainingNode(Node node, Element parentElement) {
        return DOMUtilInternal.getChildTopMostContainingNode(node, parentElement, null);
    }

    public static Node getChildTopMostContainingNode(Node node, Element parentElement, Element topLimitParent) {
        if (node == null) {
            return null;
        }
        Node parent = node.getParentNode();
        while (parent != null && parent != parentElement && parent != topLimitParent) {
            node = parent;
            parent = node.getParentNode();
        }
        if (parent == parentElement) {
            return node;
        }
        return null;
    }

    public static Element getChildElementWithTagName(Node parent, final String tagName, final int index) {
        NodeConstraints rules = new NodeConstraints(){
            protected int elemCount = 0;

            @Override
            public boolean match(Node node, Object context) {
                if (!(node instanceof Element)) {
                    return false;
                }
                Element elem = (Element)node;
                if (tagName.equals(elem.getTagName()) && this.elemCount == index) {
                    return true;
                }
                ++this.elemCount;
                return false;
            }
        };
        return (Element)DOMUtilInternal.getFirstContainedNodeMatching(parent, rules, null);
    }

    public static Element getChildElementWithTagNameNS(Node parent, final String namespaceURI, final String localName, final int index) {
        if (namespaceURI == null) {
            return DOMUtilInternal.getChildElementWithTagName(parent, localName, index);
        }
        NodeConstraints rules = new NodeConstraints(){
            protected int elemCount = 0;

            @Override
            public boolean match(Node node, Object context) {
                if (!(node instanceof Element)) {
                    return false;
                }
                Element elem = (Element)node;
                if (namespaceURI.equals(elem.getNamespaceURI()) && localName.equals(elem.getLocalName()) && this.elemCount == index) {
                    return true;
                }
                ++this.elemCount;
                return false;
            }
        };
        return (Element)DOMUtilInternal.getFirstContainedNodeMatching(parent, rules, null);
    }

    public static boolean hasContainedElementWithTagName(Node parent, String tagName) {
        return DOMUtilInternal.getChildElementWithTagName(parent, tagName, 0) != null;
    }

    public static boolean hasContainedElementWithTagNameNS(Node parent, String namespaceURI, String localName) {
        return DOMUtilInternal.getChildElementWithTagNameNS(parent, namespaceURI, localName, 0) != null;
    }

    public static boolean hasContainedNodeMatching(Node parent, NodeConstraints rules, Object context) {
        return DOMUtilInternal.getFirstContainedNodeMatching(parent, rules, context) != null;
    }

    public static Node getFirstContainedNodeMatching(Node parent, NodeConstraints rules, Object context) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (rules.match(child, context)) {
                return child;
            }
            Node result = DOMUtilInternal.getFirstContainedNodeMatching(child, rules, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isNodeOrSomeContainedNodeMatching(Node parent, NodeConstraints rules, Object context) {
        return DOMUtilInternal.getNodeOrFirstContainedNodeMatching(parent, rules, context) != null;
    }

    public static Node getNodeOrFirstContainedNodeMatching(Node parent, NodeConstraints rules, Object context) {
        if (rules.match(parent, context)) {
            return parent;
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            Node result = DOMUtilInternal.getNodeOrFirstContainedNodeMatching(child, rules, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static LinkedList<Node> getElementListWithTagName(Node node, final String tagName, boolean recursive) {
        NodeConstraints rules = new NodeConstraints(){

            @Override
            public boolean match(Node node, Object context) {
                if (!(node instanceof Element)) {
                    return false;
                }
                Element elem = (Element)node;
                return elem.getTagName().equals(tagName);
            }
        };
        return DOMUtilInternal.getNodeListMatching(node, rules, recursive, null);
    }

    public static LinkedList<Node> getChildElementListWithTagName(Node parent, final String tagName, boolean recursive) {
        NodeConstraints rules = new NodeConstraints(){

            @Override
            public boolean match(Node node, Object context) {
                if (!(node instanceof Element)) {
                    return false;
                }
                Element elem = (Element)node;
                return elem.getTagName().equals(tagName);
            }
        };
        return DOMUtilInternal.getChildNodeListMatching(parent, rules, recursive, null);
    }

    public static LinkedList<Node> getChildElementListWithTagNameNS(Node parent, final String namespaceURI, final String localName, boolean recursive) {
        if (namespaceURI == null) {
            return DOMUtilInternal.getChildElementListWithTagName(parent, localName, recursive);
        }
        NodeConstraints rules = new NodeConstraints(){

            @Override
            public boolean match(Node node, Object context) {
                if (!(node instanceof Element)) {
                    return false;
                }
                Element elem = (Element)node;
                return namespaceURI.equals(elem.getNamespaceURI()) && localName.equals(elem.getLocalName());
            }
        };
        return DOMUtilInternal.getChildNodeListMatching(parent, rules, recursive, null);
    }

    private static LinkedList<Node> getNodeListMatching(Node parent, NodeConstraints rules, boolean recursive, Object context) {
        LinkedList<Node> nodeList = null;
        if (rules.match(parent, context)) {
            if (nodeList == null) {
                nodeList = new LinkedList<Node>();
            }
            nodeList.add(parent);
        }
        return DOMUtilInternal.getChildNodeListMatching(parent, rules, recursive, nodeList, context);
    }

    public static LinkedList<Node> getChildNodeListMatching(Node parent, NodeConstraints rules, boolean recursive, Object context) {
        return DOMUtilInternal.getChildNodeListMatching(parent, rules, recursive, null, context);
    }

    private static LinkedList<Node> getChildNodeListMatching(Node parent, NodeConstraints rules, boolean recursive, LinkedList<Node> nodeList, Object context) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (rules.match(child, context)) {
                if (nodeList == null) {
                    nodeList = new LinkedList();
                }
                nodeList.add(child);
            }
            if (!recursive) continue;
            nodeList = DOMUtilInternal.getChildNodeListMatching(child, rules, recursive, nodeList, context);
        }
        return nodeList;
    }

    public static void replaceContent(Element parentElem, Node newChild) {
        Node child;
        DocumentFragment docFrag;
        if (newChild instanceof DocumentFragment ? DOMUtilInternal.isSameContent(parentElem, docFrag = (DocumentFragment)newChild) : (child = parentElem.getFirstChild()).getNextSibling() == null && DOMUtilInternal.isSameContent(newChild, child)) {
            return;
        }
        DOMUtilInternal.removeAllChildren(parentElem);
        parentElem.appendChild(newChild);
    }

    public static void removeAllChildrenNotElement(Element parentElem) {
        Node node = parentElem.getFirstChild();
        while (node != null) {
            if (node.getNodeType() != 1) {
                Node next = node.getNextSibling();
                parentElem.removeChild(node);
                node = next;
                continue;
            }
            node = node.getNextSibling();
        }
    }

    public static boolean isSeparator(Text textNode) {
        String text = textNode.getData();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') continue;
            return false;
        }
        return true;
    }

    public static void removeAllUnusefulChildTextNodes(Element parentElem) {
        Node node = parentElem.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                Text text = (Text)node;
                if (DOMUtilInternal.isSeparator(text)) {
                    Node next = node.getNextSibling();
                    parentElem.removeChild(node);
                    node = next;
                    continue;
                }
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
    }

    public static void removeAllDirectChildComments(Element parentElem) {
        Node node = parentElem.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 8) {
                Node next = node.getNextSibling();
                parentElem.removeChild(node);
                node = next;
                continue;
            }
            node = node.getNextSibling();
        }
    }

    public static Text getFirstTextNode(Element elem) {
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            return (Text)child;
        }
        return null;
    }

    public static void setCharacterDataContent(CharacterData node, String value) {
        if (value == null) {
            value = "";
        }
        if (!value.equals(node.getData())) {
            node.setData(value);
        }
    }

    public static boolean isSameContent(Element parentElem, DocumentFragment docFrag) {
        if (!parentElem.hasChildNodes() && !docFrag.hasChildNodes()) {
            return true;
        }
        Node childNode1 = parentElem.getFirstChild();
        for (Node childNode2 = docFrag.getFirstChild(); childNode1 != null || childNode2 != null; childNode1 = childNode1.getNextSibling(), childNode2 = childNode2.getNextSibling()) {
            if (DOMUtilInternal.isSameContent(childNode1, childNode2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameContent(Attr attr1, Attr attr2) {
        if (!attr1.getName().equals(attr2.getName())) {
            return false;
        }
        if (!attr1.getValue().equals(attr2.getValue())) {
            return false;
        }
        return attr1.getNamespaceURI() == null || !attr1.getNamespaceURI().equals(attr2.getNamespaceURI());
    }

    public static boolean isSameContent(Node node1, Node node2) {
        if (node1 == node2) {
            return true;
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        short type = node1.getNodeType();
        if (type == 1) {
            if (!((Element)node1).getTagName().equals(((Element)node2).getTagName())) {
                return false;
            }
            if (node1.getNamespaceURI() != null && node1.getNamespaceURI().equals(node2.getNamespaceURI())) {
                return false;
            }
            if (node1.hasAttributes() != node2.hasAttributes()) {
                return false;
            }
            if (node1.hasAttributes()) {
                NamedNodeMap attribs1 = node1.getAttributes();
                NamedNodeMap attribs2 = node2.getAttributes();
                if (attribs1.getLength() != attribs2.getLength()) {
                    return false;
                }
                int len = attribs1.getLength();
                for (int i = 0; i < len; ++i) {
                    Attr attr2;
                    Attr attr1 = (Attr)attribs1.item(i);
                    if (DOMUtilInternal.isSameContent(attr1, attr2 = (Attr)attribs2.item(i))) continue;
                    return false;
                }
            }
        }
        if (!node1.hasChildNodes() && !node2.hasChildNodes()) {
            return true;
        }
        if (node1.hasChildNodes()) {
            Node childNode1 = node1.getFirstChild();
            for (Node childNode2 = node2.getFirstChild(); childNode1 != null || childNode2 != null; childNode1 = childNode1.getNextSibling(), childNode2 = childNode2.getNextSibling()) {
                if (DOMUtilInternal.isSameContent(childNode1, childNode2)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNodeBoundToDocumentTree(Node node) {
        if (node == null) {
            return false;
        }
        Node parent = node;
        while ((parent = (node = parent).getParentNode()) != null) {
        }
        return node.getNodeType() == 9;
    }

    public static DocumentFragment extractChildrenToDocFragment(Node parentNode) {
        return DOMUtilInternal.extractChildrenToDocFragment(parentNode, false);
    }

    public static DocumentFragment extractChildrenToDocFragment(Node parentNode, boolean removeLastChildFirst) {
        Document doc = parentNode.getOwnerDocument();
        DocumentFragment docFrag = doc.createDocumentFragment();
        if (removeLastChildFirst) {
            Node child = parentNode.getLastChild();
            while (child != null) {
                parentNode.removeChild(child);
                docFrag.insertBefore(child, docFrag.getFirstChild());
                child = parentNode.getLastChild();
            }
        } else {
            Node child = parentNode.getFirstChild();
            while (child != null) {
                parentNode.removeChild(child);
                docFrag.appendChild(child);
                child = parentNode.getFirstChild();
            }
        }
        return docFrag;
    }
}

