/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domutil;

import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLHtmlElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTextAreaElement;

public class DOMUtilHTML {
    public static HTMLHeadElement getHTMLHead(HTMLDocument doc) {
        Node head;
        HTMLHtmlElement html = (HTMLHtmlElement)doc.getDocumentElement();
        if (html == null) {
            return null;
        }
        for (head = html.getFirstChild(); head != null && !(head instanceof HTMLHeadElement); head = head.getNextSibling()) {
        }
        return (HTMLHeadElement)head;
    }

    public static boolean isChildOfHTMLHead(Element elem) {
        Node parent = elem.getParentNode();
        if (parent == null) {
            return false;
        }
        Document doc = elem.getOwnerDocument();
        if (!(doc instanceof HTMLDocument)) {
            return false;
        }
        HTMLDocument htmDoc = (HTMLDocument)doc;
        HTMLHeadElement head = DOMUtilHTML.getHTMLHead(htmDoc);
        while (parent != null) {
            if (parent == head) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    public static boolean isHTMLNode(Node node) {
        if (node == null) {
            return false;
        }
        if (node instanceof Element) {
            return DOMUtilHTML.isHTMLElement((Element)node);
        }
        if (node instanceof CharacterData) {
            return DOMUtilHTML.isHTMLCharacterData((CharacterData)node);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMUtilHTML.isHTMLNode(node.getParentNode());
        }
        if (node instanceof Document) {
            return DOMUtilHTML.isHTMLDocument((Document)node);
        }
        if (node instanceof Attr) {
            return DOMUtilHTML.isHTMLAttribute(node.getNamespaceURI(), ((Attr)node).getOwnerElement());
        }
        return false;
    }

    public static boolean isHTMLElement(Element elem) {
        return elem instanceof HTMLElement;
    }

    public static boolean isHTMLCharacterData(CharacterData node) {
        return DOMUtilHTML.isHTMLNode(node.getParentNode());
    }

    public static boolean isHTMLDocument(Document doc) {
        return doc instanceof HTMLDocument;
    }

    public static boolean isHTMLAttribute(String attrNamespaceURI, Element elem) {
        return DOMUtilHTML.isHTMLElement(elem) && (attrNamespaceURI == null || NamespaceUtil.isXHTMLNamespace(attrNamespaceURI));
    }

    private static boolean isHTMLInputType(Node node, String typeLowerCase) {
        if (node instanceof HTMLInputElement) {
            Element elem = (Element)node;
            String type = elem.getAttribute("type").toLowerCase();
            return type.equals(typeLowerCase);
        }
        return false;
    }

    public static boolean isHTMLInputTextBased(Node node) {
        if (node instanceof HTMLInputElement) {
            Element elem = (Element)node;
            String type = elem.getAttribute("type").toLowerCase();
            return type.equals("text") || type.equals("password") || type.equals("file");
        }
        return false;
    }

    public static boolean isHTMLInputCheckBox(Node node) {
        return DOMUtilHTML.isHTMLInputType(node, "checkbox");
    }

    public static boolean isHTMLInputImage(Node node) {
        return DOMUtilHTML.isHTMLInputType(node, "image");
    }

    public static boolean isHTMLInputFile(Node node) {
        return DOMUtilHTML.isHTMLInputType(node, "file");
    }

    public static boolean isHTMLInputFileWithValueAttr(Node node) {
        if (!DOMUtilHTML.isHTMLInputFile(node)) {
            return false;
        }
        Element elem = (Element)node;
        return elem.hasAttribute("value");
    }

    public static boolean isHTMLInputFileValueAttr(Node node, String attrName) {
        if (!DOMUtilHTML.isHTMLInputFile(node)) {
            return false;
        }
        return attrName.toLowerCase().equals("value");
    }

    public static boolean isHTMLInputCheckBoxOrRadio(Node node) {
        if (!(node instanceof HTMLInputElement)) {
            return false;
        }
        Element elem = (Element)node;
        String type = elem.getAttribute("type").toLowerCase();
        return type.equals("checkbox") || type.equals("radio");
    }

    public static boolean isHTMLTextAreaOrInputTextBox(Node node) {
        if (node instanceof HTMLTextAreaElement) {
            return true;
        }
        return DOMUtilHTML.isHTMLInputTextBox(node);
    }

    public static boolean isHTMLInputTextBox(Node node) {
        if (node instanceof HTMLInputElement) {
            Element elem = (Element)node;
            String type = elem.getAttribute("type").toLowerCase();
            return type.equals("text") || type.equals("password") || type.equals("file");
        }
        return false;
    }

    public static boolean isHTMLOptionOfSelectMultipleOrWithSize(Node option) {
        if (!(option instanceof HTMLOptionElement)) {
            return false;
        }
        Node parent = option.getParentNode();
        return DOMUtilHTML.isHTMLSelectMultipleOrWithSize(parent);
    }

    public static boolean isHTMLOptionOfSelectMultiple(Node option) {
        if (!(option instanceof HTMLOptionElement)) {
            return false;
        }
        Node parent = option.getParentNode();
        return DOMUtilHTML.isHTMLSelectMultiple(parent);
    }

    public static boolean isHTMLSelectMultipleOrWithSize(Node node) {
        if (!(node instanceof HTMLSelectElement)) {
            return false;
        }
        Element elem = (Element)node;
        return elem.hasAttribute("multiple") || elem.hasAttribute("size");
    }

    public static boolean isHTMLSelectComboBox(Node node) {
        if (!(node instanceof HTMLSelectElement)) {
            return false;
        }
        Element elem = (Element)node;
        return !elem.hasAttribute("multiple") && !elem.hasAttribute("size");
    }

    public static boolean isHTMLSelectMultiple(Node node) {
        if (!(node instanceof HTMLSelectElement)) {
            return false;
        }
        Element elem = (Element)node;
        return elem.hasAttribute("multiple");
    }

    public static boolean hasHTMLFocusOrBlurMethod(Node node) {
        if (!(node instanceof HTMLElement)) {
            return false;
        }
        return node instanceof HTMLTextAreaElement || node instanceof HTMLInputElement || node instanceof HTMLSelectElement || node instanceof HTMLAnchorElement;
    }
}

