/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.dompath;

import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleElementPathResolver {
    public static String getMethodNameGetElementFromPath() {
        return "itsNatGetElementFromPath";
    }

    public static String bindGetElementFromPath(String docVarName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        String method = SimpleElementPathResolver.getMethodNameGetElementFromPath();
        StringBuilder code = new StringBuilder();
        code.append("var func = function(path)");
        code.append("{");
        code.append("  var node = this;");
        code.append("  for(var i = 0; i < path.length; i++)");
        code.append("  {");
        code.append("    var pos = path[i];");
        code.append("    var childNode = null;");
        code.append("    var childList = node.childNodes;");
        code.append("    var currPos = 0;");
        code.append("    for(var j = 0; j < childList.length; j++)");
        code.append("    {");
        code.append("      var currNode = childList.item(j);");
        code.append("      if (currNode.nodeType != 1) continue;");
        code.append("      if (currPos == pos) { childNode = currNode; break; }");
        code.append("      currPos++;");
        code.append("    }");
        code.append("    node = childNode;");
        code.append("  }");
        code.append("  return node;");
        code.append("};");
        code.append(docVarName + "." + method + " = func;\n");
        code.append(docVarName + "." + method + "_src = func.toString();\n");
        clientDoc.bindClientMethod(method);
        return code.toString();
    }

    public static String callGetElementFromPath(String resElemVarName, String docVarName, String pathParam, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        String method = SimpleElementPathResolver.getMethodNameGetElementFromPath();
        if (!clientDoc.isClientMethodBounded(method)) {
            code.append(SimpleElementPathResolver.bindGetElementFromPath(docVarName, clientDoc));
        } else {
            code.append("eval(\"var func = \" + " + docVarName + "." + method + "_src);\n");
            code.append(docVarName + "." + method + " = func;\n");
        }
        code.append(resElemVarName + " = " + docVarName + "." + method + "(" + pathParam + ");\n");
        return code.toString();
    }

    public static Element getElementFromPath(Document doc, int[] path) {
        Document node = doc;
        for (int i = 0; i < path.length; ++i) {
            int pos = path[i];
            Element childNode = null;
            NodeList childList = node.getChildNodes();
            int currPos = 0;
            int len = childList.getLength();
            int j = 0;
            while (j < len) {
                Node currNode = childList.item(j);
                if (currNode.getNodeType() == 1) {
                    if (currPos == pos) {
                        childNode = (Element)currNode;
                        break;
                    }
                    ++currPos;
                }
                ++i;
            }
            node = childNode;
        }
        return (Element)((Object)node);
    }

    private static int getElementDeep(Element elem) {
        Document topParent = elem.getOwnerDocument();
        int i = 0;
        for (Node node = elem; node != topParent; node = node.getParentNode()) {
            ++i;
        }
        return i;
    }

    private static int getElementChildPosition(Element elem) {
        Node parent = elem.getParentNode();
        if (parent.hasChildNodes()) {
            int pos = 0;
            for (Node nodeItem = parent.getFirstChild(); nodeItem != null; nodeItem = nodeItem.getNextSibling()) {
                if (nodeItem.getNodeType() != 1) continue;
                if (nodeItem == elem) {
                    return pos;
                }
                ++pos;
            }
        }
        return -1;
    }

    private static int[] getPathFromElement(Element elem) {
        int len = SimpleElementPathResolver.getElementDeep(elem);
        int[] path = new int[len];
        Node node = elem;
        for (int i = len - 1; i >= 0; --i) {
            int pos;
            path[i] = pos = SimpleElementPathResolver.getElementChildPosition(node);
            node = node.getParentNode();
        }
        return path;
    }

    public static String getPathFromElementAsScript(Element elem) {
        int[] path = SimpleElementPathResolver.getPathFromElement(elem);
        StringBuilder code = new StringBuilder();
        code.append("[");
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                code.append(",");
            }
            code.append(path[i]);
        }
        code.append("]");
        return code.toString();
    }
}

