/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.dompath;

import java.util.ArrayList;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.NodeCacheRegistryImpl;
import org.itsnat.impl.core.dompath.NodeLocationAlreadyCachedNotParentImpl;
import org.itsnat.impl.core.dompath.NodeLocationImpl;
import org.itsnat.impl.core.dompath.NodeLocationPathBasedNotParentImpl;
import org.w3c.dom.Node;

public class NodeLocationWithParentImpl
extends NodeLocationImpl {
    protected NodeLocationImpl nodeLocationDeleg;
    protected Node cachedParent;
    protected String cachedParentId;
    protected ArrayList<String> newCachedParentIds;

    private NodeLocationWithParentImpl(Node node, String id, String path, Node cachedParent, String cachedParentId, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        super(clientDoc);
        if (node == null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        this.nodeLocationDeleg = NodeLocationWithParentImpl.getNodeLocationNotParent(node, id, path, clientDoc);
        this.cachedParent = cachedParent;
        this.cachedParentId = cachedParentId;
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        if (nodeCache != null && cacheIfPossible) {
            int maxParents = 3;
            Node currParent = node.getParentNode();
            for (int i = 0; currParent != null && currParent != cachedParent && i < maxParents; ++i) {
                String parentId = nodeCache.getId(currParent);
                if (parentId == null) {
                    parentId = nodeCache.addNode(currParent);
                    if (parentId != null) {
                        if (this.newCachedParentIds == null) {
                            this.newCachedParentIds = new ArrayList(maxParents);
                        }
                        this.newCachedParentIds.add(parentId);
                        currParent = currParent.getParentNode();
                        ++i;
                        continue;
                    }
                    currParent = null;
                    continue;
                }
                currParent = null;
            }
        }
        if (this.nodeLocationDeleg instanceof NodeLocationAlreadyCachedNotParentImpl && !NodeLocationWithParentImpl.isNull(cachedParentId)) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    public NodeLocationWithParentImpl(Node node, String id, String path, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        this(node, id, path, null, null, cacheIfPossible, clientDoc);
    }

    @Override
    public Node getNode() {
        return this.nodeLocationDeleg.getNode();
    }

    @Override
    public boolean isJustCached() {
        return this.nodeLocationDeleg.isJustCached();
    }

    private String getCachedParentId() {
        return this.cachedParentId;
    }

    protected String getCachedParentIdAsScript() {
        return NodeLocationWithParentImpl.toLiteralStringScript(this.getCachedParentId());
    }

    @Override
    public String toScriptNodeLocation(boolean errIfNull) {
        this.used = true;
        this.nodeLocationDeleg.setUsed();
        if (this.nodeLocationDeleg instanceof NodeLocationAlreadyCachedNotParentImpl) {
            NodeLocationAlreadyCachedNotParentImpl nodeLocDeleg = (NodeLocationAlreadyCachedNotParentImpl)this.nodeLocationDeleg;
            if (this.newCachedParentIds == null) {
                return this.toScriptArray(nodeLocDeleg.getIdAsScript());
            }
            return this.toScriptArray(nodeLocDeleg.getIdAsScript() + "," + this.toScriptArrayCachedParents());
        }
        if (this.nodeLocationDeleg instanceof NodeLocationPathBasedNotParentImpl) {
            NodeLocationPathBasedNotParentImpl nodeLocDeleg = (NodeLocationPathBasedNotParentImpl)this.nodeLocationDeleg;
            StringBuilder code = new StringBuilder();
            code.append(this.getCachedParentIdAsScript() + "," + nodeLocDeleg.getIdAsScript() + "," + nodeLocDeleg.getPathAsScript());
            if (this.newCachedParentIds != null) {
                code.append("," + this.toScriptArrayCachedParents());
            }
            return this.toScriptArray(code.toString());
        }
        throw new ItsNatException("INTERNAL ERROR");
    }

    protected String toScriptArrayCachedParents() {
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < this.newCachedParentIds.size(); ++i) {
            String parentId = this.newCachedParentIds.get(i);
            String parentIdScript = NodeLocationWithParentImpl.toLiteralStringScript(parentId);
            if (i != 0) {
                code.append(",");
            }
            code.append(parentIdScript);
        }
        return this.toScriptArray(code.toString());
    }

    public static NodeLocationWithParentImpl getNodeLocationWithParentUsingCache(Node node, String id, boolean cacheIfPossible, NodeCacheRegistryImpl nodeCache) {
        String parentId = null;
        Node parent = node;
        while ((parentId = nodeCache.getId(parent = parent.getParentNode())) == null && parent != null) {
        }
        ClientDocumentStfulDelegateImpl clientDoc = nodeCache.getClientDocumentStfulDelegate();
        String path = clientDoc.getStringPathFromNode(node, parent);
        return new NodeLocationWithParentImpl(node, id, path, parent, parentId, cacheIfPossible, clientDoc);
    }

    public static NodeLocationWithParentImpl getNodeLocationWithParent(Node node, String id, String path, Node parent, String parentId, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        return new NodeLocationWithParentImpl(node, id, path, parent, parentId, cacheIfPossible, clientDoc);
    }

    public static NodeLocationWithParentImpl getNodeLocationWithParent(Node node, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        if (nodeCache != null) {
            String id = nodeCache.getId(node);
            if (id != null) {
                return new NodeLocationWithParentImpl(node, id, null, cacheIfPossible, clientDoc);
            }
            if (cacheIfPossible) {
                id = nodeCache.addNode(node);
                return NodeLocationWithParentImpl.getNodeLocationWithParentUsingCache(node, id, true, nodeCache);
            }
            String path = clientDoc.getStringPathFromNode(node);
            return new NodeLocationWithParentImpl(node, null, path, false, clientDoc);
        }
        String path = clientDoc.getStringPathFromNode(node);
        return new NodeLocationWithParentImpl(node, null, path, cacheIfPossible, clientDoc);
    }
}

