/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.dompath;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.NodeCacheRegistryImpl;
import org.itsnat.impl.core.dompath.DOMPathResolver;
import org.itsnat.impl.core.dompath.NodeLocationAlreadyCachedNotParentImpl;
import org.itsnat.impl.core.dompath.NodeLocationNullImpl;
import org.itsnat.impl.core.dompath.NodeLocationPathBasedNotParentImpl;
import org.itsnat.impl.core.dompath.NodeLocationWithParentImpl;
import org.itsnat.impl.core.scriptren.shared.JSAndBSRenderImpl;
import org.w3c.dom.Node;

public abstract class NodeLocationImpl {
    protected ClientDocumentStfulDelegateImpl clientDoc;
    protected boolean used = false;

    public NodeLocationImpl(ClientDocumentStfulDelegateImpl clientDoc) {
        this.clientDoc = clientDoc;
    }

    public boolean isScriptJS() {
        return this.clientDoc.getClientDocumentStful().getBrowser() instanceof BrowserWeb;
    }

    public boolean isScriptBeanshell() {
        return !this.isScriptJS();
    }

    public abstract Node getNode();

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegate() {
        return this.clientDoc;
    }

    protected void setUsed() {
        this.used = true;
    }

    protected String toScriptArray(String content) {
        StringBuilder code = new StringBuilder();
        boolean isJS = this.isScriptJS();
        if (isJS) {
            code.append("[");
        } else {
            code.append("arr(");
        }
        code.append(content);
        if (isJS) {
            code.append("]");
        } else {
            code.append(")");
        }
        return code.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.used) {
            throw new ItsNatException("Some nodes have been cached in server but not in client, generated JavaScript code was not sent to the client.");
        }
    }

    protected static boolean isNull(String str) {
        return str == null || str.equals("null");
    }

    public abstract boolean isJustCached();

    public abstract String toScriptNodeLocation(boolean var1);

    public static String toLiteralStringScript(String value) {
        return JSAndBSRenderImpl.toLiteralStringScript(value);
    }

    public static NodeLocationImpl getNodeLocation(ClientDocumentStfulDelegateImpl clientDoc, Node node, boolean cacheIfPossible) {
        if (node == null) {
            return new NodeLocationNullImpl(clientDoc);
        }
        return NodeLocationWithParentImpl.getNodeLocationWithParent(node, cacheIfPossible, clientDoc);
    }

    public static NodeLocationImpl getRefNodeLocationInsertBefore(ClientDocumentStfulDelegateImpl clientDoc, Node newNode, Node nextSibling) {
        if (nextSibling == null) {
            return new NodeLocationNullImpl(clientDoc);
        }
        String idRefChild = null;
        String refChildPathRel = null;
        boolean needRefNodePath = false;
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        if (nodeCache != null) {
            idRefChild = nodeCache.getId(nextSibling);
            if (idRefChild != null) {
                needRefNodePath = false;
            } else {
                needRefNodePath = true;
                idRefChild = nodeCache.addNode(nextSibling);
            }
        } else {
            needRefNodePath = true;
        }
        if (needRefNodePath) {
            refChildPathRel = clientDoc.getRelativeStringPathFromNodeParent(newNode);
            refChildPathRel = DOMPathResolver.removeTextNodeSuffix(refChildPathRel);
            if (nextSibling.getNodeType() == 3) {
                refChildPathRel = refChildPathRel + DOMPathResolver.getTextNodeSuffix();
            }
            return new NodeLocationPathBasedNotParentImpl(nextSibling, idRefChild, refChildPathRel, clientDoc);
        }
        return new NodeLocationAlreadyCachedNotParentImpl(nextSibling, idRefChild, clientDoc);
    }

    public static NodeLocationImpl getNodeLocationRelativeToParent(ClientDocumentStfulDelegateImpl clientDoc, Node node) {
        if (node == null) {
            return new NodeLocationNullImpl(clientDoc);
        }
        String idNode = null;
        String nodePathRel = null;
        boolean needNodePath = false;
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        if (nodeCache != null) {
            idNode = nodeCache.getId(node);
            if (idNode != null) {
                needNodePath = false;
            } else {
                needNodePath = true;
                idNode = nodeCache.addNode(node);
            }
        } else {
            needNodePath = true;
        }
        if (needNodePath) {
            nodePathRel = clientDoc.getRelativeStringPathFromNodeParent(node);
            return new NodeLocationPathBasedNotParentImpl(node, idNode, nodePathRel, clientDoc);
        }
        return new NodeLocationAlreadyCachedNotParentImpl(node, idNode, clientDoc);
    }

    public static NodeLocationImpl getNodeLocationNotParent(Node node, String id, String path, ClientDocumentStfulDelegateImpl clientDoc) {
        if (node == null) {
            return new NodeLocationNullImpl(clientDoc);
        }
        if (path != null) {
            return new NodeLocationPathBasedNotParentImpl(node, id, path, clientDoc);
        }
        return new NodeLocationAlreadyCachedNotParentImpl(node, id, clientDoc);
    }
}

