/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.dompath;

import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.dompath.DOMPathResolver;
import org.itsnat.impl.core.dompath.DOMPathResolverHTMLDoc;
import org.itsnat.impl.core.dompath.DOMPathResolverOtherNSDoc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMPathResolverWeb
extends DOMPathResolver {
    public DOMPathResolverWeb(ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(clientDoc);
    }

    public static DOMPathResolverWeb createDOMPathResolverWeb(ClientDocumentStfulDelegateWebImpl clientDoc) {
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        if (itsNatDoc instanceof ItsNatHTMLDocumentImpl) {
            return new DOMPathResolverHTMLDoc(clientDoc);
        }
        return new DOMPathResolverOtherNSDoc(clientDoc);
    }

    @Override
    public boolean isFilteredInClient(Node node) {
        return false;
    }

    @Override
    protected Node getChildNodeFromPos(Node parentNode, int pos, boolean isTextNode) {
        if (!parentNode.hasChildNodes()) {
            return null;
        }
        int currPos = 0;
        for (Node currNode = parentNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (this.isFilteredInClient(currNode)) continue;
            short type = currNode.getNodeType();
            if (currPos == pos) {
                if (!isTextNode && type == 3) continue;
                return currNode;
            }
            if (type == 3) continue;
            ++currPos;
        }
        return null;
    }

    @Override
    protected Node getChildNodeFromStrPos(Node parentNode, String posStr) {
        if (posStr.equals("de")) {
            Document doc = this.getItsNatStfulDocument().getDocument();
            return doc.getDocumentElement();
        }
        int posBracket = posStr.indexOf(91);
        if (posBracket == -1) {
            int pos = Integer.parseInt(posStr);
            return this.getChildNodeFromPos(parentNode, pos, false);
        }
        int pos = Integer.parseInt(posStr.substring(0, posBracket));
        if (posStr.charAt(posBracket + 1) == '@') {
            String attrName = posStr.substring(posBracket + 2, posStr.length() - 1);
            Node child = this.getChildNodeFromPos(parentNode, pos, false);
            return ((Element)child).getAttributeNode(attrName);
        }
        return this.getChildNodeFromPos(parentNode, pos, true);
    }
}

