/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.dompath;

import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.dompath.DOMPathResolverWeb;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;

public class DOMPathResolverHTMLDoc
extends DOMPathResolverWeb {
    public DOMPathResolverHTMLDoc(ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(clientDoc);
    }

    public ItsNatHTMLDocumentImpl getItsNatHTMLDocument() {
        return (ItsNatHTMLDocumentImpl)this.clientDoc.getItsNatStfulDocument();
    }

    public ClientDocumentStfulDelegateWebImpl getClientDocumentStfulDelegateWeb() {
        return (ClientDocumentStfulDelegateWebImpl)this.clientDoc;
    }

    @Override
    protected Node getChildNodeFromStrPos(Node parentNode, String posStr) {
        ItsNatHTMLDocumentImpl itsNatDoc = this.getItsNatHTMLDocument();
        HTMLDocument doc = itsNatDoc.getHTMLDocument();
        if (parentNode == doc.getDocumentElement()) {
            if (posStr.equals("bo")) {
                return doc.getBody();
            }
            if (posStr.equals("he")) {
                return DOMUtilHTML.getHTMLHead(doc);
            }
        }
        return super.getChildNodeFromStrPos(parentNode, posStr);
    }

    @Override
    protected String getNodeChildPosition(Node node) {
        HTMLDocument doc = this.getItsNatHTMLDocument().getHTMLDocument();
        if (node.getParentNode() == doc.getDocumentElement()) {
            if (node == doc.getBody()) {
                return "bo";
            }
            if (node == DOMUtilHTML.getHTMLHead(doc)) {
                return "he";
            }
        }
        return super.getNodeChildPosition(node);
    }

    @Override
    public boolean isFilteredInClient(Node node) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        SVGWebInfoImpl svgWebInfo = clientDoc.getSVGWebInfo();
        if (svgWebInfo == null) {
            return false;
        }
        if (node instanceof Comment) {
            return svgWebInfo.isSVGNodeProcessedBySVGWebFlash(node);
        }
        return false;
    }
}

