/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.dompath;

import java.io.Serializable;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.dompath.DOMPathResolverDroid;
import org.itsnat.impl.core.dompath.DOMPathResolverWeb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public abstract class DOMPathResolver
implements Serializable {
    protected ClientDocumentStfulDelegateImpl clientDoc;

    public DOMPathResolver(ClientDocumentStfulDelegateImpl clientDoc) {
        this.clientDoc = clientDoc;
    }

    public static DOMPathResolver createDOMPathResolver(ClientDocumentStfulDelegateImpl clientDoc) {
        Browser browser = clientDoc.getClientDocumentStful().getBrowser();
        if (browser instanceof BrowserWeb) {
            return DOMPathResolverWeb.createDOMPathResolverWeb((ClientDocumentStfulDelegateWebImpl)clientDoc);
        }
        if (browser instanceof BrowserDroid) {
            return new DOMPathResolverDroid((ClientDocumentStfulDelegateDroidImpl)clientDoc);
        }
        return null;
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.clientDoc.getItsNatStfulDocument();
    }

    public abstract boolean isFilteredInClient(Node var1);

    private static String[] getArrayPathFromString(String pathStr) {
        if (pathStr == null) {
            return null;
        }
        String[] path = pathStr.split(",");
        return path;
    }

    protected abstract Node getChildNodeFromPos(Node var1, int var2, boolean var3);

    protected abstract Node getChildNodeFromStrPos(Node var1, String var2);

    private Node getNodeFromArrayPath(String[] arrayPath, Node topParent) {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        Document doc = itsNatDoc.getDocument();
        AbstractView view = ((DocumentView)((Object)doc)).getDefaultView();
        if (arrayPath.length == 1) {
            String firstPos = arrayPath[0];
            if (firstPos.equals("window")) {
                return (Node)((Object)view);
            }
            if (firstPos.equals("document")) {
                return doc;
            }
            if (firstPos.equals("doctype")) {
                return doc.getDoctype();
            }
        }
        if (topParent == null) {
            topParent = doc;
        }
        Node node = topParent;
        for (int i = 0; i < arrayPath.length; ++i) {
            String posStr = arrayPath[i];
            if ((node = this.getChildNodeFromStrPos(node, posStr)) != null) continue;
            return null;
        }
        return node;
    }

    public Node getNodeFromPath(String pathStr, Node topParent) {
        String[] path = DOMPathResolver.getArrayPathFromString(pathStr);
        if (path == null) {
            return null;
        }
        return this.getNodeFromArrayPath(path, topParent);
    }

    protected String getNodeChildPosition(Node node) {
        Document doc = this.getItsNatStfulDocument().getDocument();
        if (node == doc.getDocumentElement()) {
            return "de";
        }
        Node parentNode = node.getParentNode();
        if (parentNode == null) {
            throw new ItsNatException("Unexpected error");
        }
        int pos = 0;
        for (Node currNode = parentNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (this.isFilteredInClient(currNode)) continue;
            if (currNode == node) {
                return Integer.toString(pos);
            }
            if (currNode.getNodeType() == 3) continue;
            ++pos;
        }
        throw new ItsNatException("Node not found in document to calculate paths", (Object)node);
    }

    private static String getStringPathFromArray(String[] path) {
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                code.append(",");
            }
            code.append(path[i]);
        }
        return code.toString();
    }

    private static int getNodeDeep(Node node, Node topParent) {
        int i = 0;
        while (node != topParent) {
            ++i;
            if ((node = node.getParentNode()) != null) continue;
            return -1;
        }
        return i;
    }

    private String[] getNodePathArray(Node nodeLeaf, Node topParent) {
        int len;
        String id;
        Element elem;
        String locbyid;
        if (nodeLeaf == null) {
            return null;
        }
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        Document doc = itsNatDoc.getDocument();
        if (topParent == null) {
            topParent = doc;
        }
        if (nodeLeaf.equals(((DocumentView)((Object)doc)).getDefaultView())) {
            return new String[]{"window"};
        }
        if (nodeLeaf.equals(doc)) {
            return new String[]{"document"};
        }
        if (nodeLeaf.equals(doc.getDoctype())) {
            return new String[]{"doctype"};
        }
        if (nodeLeaf.getNodeType() == 1 && "true".equals(locbyid = (elem = (Element)nodeLeaf).getAttributeNS("http://itsnat.org/itsnat", "locById")) && !(id = elem.getAttribute("id")).equals("")) {
            return new String[]{"eid:" + id};
        }
        Node node = nodeLeaf;
        if (node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        }
        if ((len = DOMPathResolver.getNodeDeep(node, topParent)) < 0) {
            return null;
        }
        String[] path = new String[len];
        for (int i = len - 1; i >= 0; --i) {
            String pos;
            path[i] = pos = this.getNodeChildPosition(node);
            node = node.getParentNode();
        }
        int n = len - 1;
        path[n] = path[n] + DOMPathResolver.getSuffix(nodeLeaf);
        return path;
    }

    private static String getSuffix(Node nodeLeaf) {
        short type = nodeLeaf.getNodeType();
        if (type == 3) {
            return DOMPathResolver.getTextNodeSuffix();
        }
        if (type == 2) {
            return "[@" + ((Attr)nodeLeaf).getName() + "]";
        }
        return "";
    }

    public static String getTextNodeSuffix() {
        return "[t]";
    }

    public String getStringPathFromNode(Node node) {
        return this.getStringPathFromNode(node, null);
    }

    public String getStringPathFromNode(Node node, Node topParent) {
        if (node == null) {
            return null;
        }
        String[] path = this.getNodePathArray(node, topParent);
        if (path == null) {
            return null;
        }
        return DOMPathResolver.getStringPathFromArray(path);
    }

    public String getRelativeStringPathFromNodeParent(Node child) {
        if (child == null) {
            return null;
        }
        return this.getStringPathFromNode(child, child.getParentNode());
    }

    public static String removeTextNodeSuffix(String path) {
        int len = path.length();
        if (path.charAt(len - 1) != ']') {
            return path;
        }
        path = path.substring(0, len - DOMPathResolver.getTextNodeSuffix().length());
        return path;
    }

    public Node getPreviousSiblingInClientDOM(Node node) {
        Node prevSibling = node;
        while ((prevSibling = prevSibling.getPreviousSibling()) != null && this.isFilteredInClient(prevSibling)) {
        }
        return prevSibling;
    }

    public Node getNextSiblingInClientDOM(Node node) {
        Node nextSibling = node;
        while ((nextSibling = nextSibling.getNextSibling()) != null && this.isFilteredInClient(nextSibling)) {
        }
        return nextSibling;
    }
}

