/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import java.io.Serializable;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class NodeListBaseImpl
implements Serializable {
    protected Node topNode;

    public NodeListBaseImpl(Node topNode) {
        if (topNode == null) {
            throw new DOMException(8, "The parent node cannot be null");
        }
        this.topNode = topNode;
    }

    protected Element searchChild(Node parent, NumberCounter counter, String name) {
        Element child = ItsNatTreeWalker.getFirstChildElement(parent);
        while (child != null) {
            Element found;
            if (this.machElement(child, name)) {
                if (counter.isFinished()) {
                    return child;
                }
                counter.inc();
            } else if (this.isRecursive() && (found = this.searchChild(child, counter, name)) != null) {
                return found;
            }
            child = ItsNatTreeWalker.getNextSiblingElement(child);
        }
        return null;
    }

    public int getLength(String name) {
        NumberCounter counter = new NumberCounter(Integer.MAX_VALUE);
        this.searchChild(this.topNode, counter, name);
        return counter.getCount();
    }

    public Node item(int index, String name) {
        if (index < 0) {
            return null;
        }
        return this.searchChild(this.topNode, new NumberCounter(index), name);
    }

    public abstract boolean isRecursive();

    public abstract boolean machElement(Element var1, String var2);

    public static class NumberCounter {
        private int index;
        private int count;

        public NumberCounter(int index) {
            this.index = index;
        }

        public boolean isFinished() {
            return this.index == this.count;
        }

        public int inc() {
            ++this.count;
            return this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

